/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.coordinate.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.smc.coordinate.api.SmcUmcHandleCoordinateService;
import com.tydic.dyc.smc.coordinate.bo.SmcUmcCoordinateBO;
import com.tydic.dyc.smc.coordinate.bo.SmcUmcHandleCoordinateReqBO;
import com.tydic.dyc.smc.coordinate.bo.SmcUmcHandleCoordinateRspBO;
import com.tydic.dyc.smc.repository.coordinate.api.SmcUmcCoordinateRepository;
import com.tydic.dyc.smc.repository.coordinate.bo.SmcUmcCoordinate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.coordinate.api.SmcUmcHandleCoordinateService"})
public class SmcUmcHandleCoordinateServiceImpl
implements SmcUmcHandleCoordinateService {
    @Autowired
    private SmcUmcCoordinateRepository umcCoordinateRepository;

    @Override
    @PostMapping(value={"handleCoordinate"})
    public SmcUmcHandleCoordinateRspBO handleCoordinate(@RequestBody SmcUmcHandleCoordinateReqBO reqBO) {
        this.checkParam(reqBO);
        this.dealCoordinate(reqBO);
        return (SmcUmcHandleCoordinateRspBO)SmcRu.success(SmcUmcHandleCoordinateRspBO.class);
    }

    private void dealCoordinate(SmcUmcHandleCoordinateReqBO reqBO) {
        List addList = new ArrayList();
        SmcUmcCoordinate umcCoordinate = new SmcUmcCoordinate();
        umcCoordinate.setCreateUserId(reqBO.getUserId());
        this.umcCoordinateRepository.del(umcCoordinate);
        addList = SmcRu.jsl(reqBO.getList(), SmcUmcCoordinate.class);
        if (!CollectionUtils.isEmpty(addList)) {
            for (SmcUmcCoordinate coordinate : addList) {
                coordinate.setCreateUserId(reqBO.getUserId());
                coordinate.setCreateUserCode(reqBO.getUsername());
            }
            this.umcCoordinateRepository.insertBatch(addList);
        }
    }

    private void checkParam(SmcUmcHandleCoordinateReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getList())) {
            throw new ZTBusinessException("\u5750\u6807\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        for (SmcUmcCoordinateBO bo : reqBO.getList()) {
            if (StringUtils.isBlank((CharSequence)bo.getXCoordinate())) {
                throw new ZTBusinessException("\u6a2a\u5750\u6807\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getYCoordinate())) {
                throw new ZTBusinessException("\u7eb5\u5750\u6807\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getClassCode())) {
                throw new ZTBusinessException("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getHigh())) {
                throw new ZTBusinessException("\u9ad8\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)bo.getWeight())) continue;
            throw new ZTBusinessException("\u5bbd\u4e3a\u7a7a");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4ebaid\u4e3a\u7a7a");
        }
    }
}

