/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.shippingAddress.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.base.utils.StrUtil;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.po.SmcUmcShippingAddressPo;
import com.tydic.dyc.smc.repository.shippingAddress.api.SmcUmcShippingAddressRepository;
import com.tydic.dyc.smc.shippingAddress.api.SmcUmcUpdateShippingAddressService;
import com.tydic.dyc.smc.shippingAddress.bo.SmcUmcUpdateShippingAddressReqBO;
import com.tydic.dyc.smc.shippingAddress.bo.SmcUmcUpdateShippingAddressRspBO;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.shippingAddress.api.SmcUmcUpdateShippingAddressService"})
public class SmcUmcUpdateShippingAddressServiceImpl
implements SmcUmcUpdateShippingAddressService {
    @Autowired
    private SmcUmcShippingAddressRepository smcUmcShippingAddressRepository;
    @Value(value="${umc.shippingAddress.dataAuth.value:1}")
    private String dataAuth;

    @Override
    @PostMapping(value={"updateShippingAddress"})
    public SmcUmcUpdateShippingAddressRspBO updateShippingAddress(@RequestBody SmcUmcUpdateShippingAddressReqBO reqBO) {
        SmcUmcUpdateShippingAddressRspBO rspBO = (SmcUmcUpdateShippingAddressRspBO)SmcRu.success(SmcUmcUpdateShippingAddressRspBO.class);
        this.val(reqBO);
        this.valExistsAddress(reqBO);
        this.valDataRepeat(reqBO);
        List<SmcUmcShippingAddressPo> list = this.valExistsDefaultAddress(reqBO, rspBO);
        this.cancelDefault(reqBO, list);
        this.updateInfo(reqBO);
        return rspBO;
    }

    private void cancelDefault(SmcUmcUpdateShippingAddressReqBO reqBO, List<SmcUmcShippingAddressPo> list) {
        if (SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES.equals(reqBO.getIsDefault())) {
            for (SmcUmcShippingAddressPo po : list) {
                po.setIsDefault(SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_NO);
                this.smcUmcShippingAddressRepository.updateById((Object)po);
            }
        }
    }

    private void updateInfo(SmcUmcUpdateShippingAddressReqBO reqBO) {
        StrUtil.noNullStringAttr((Object)((Object)reqBO));
        SmcUmcShippingAddressPo update = (SmcUmcShippingAddressPo)SmcRu.js((Object)((Object)reqBO), SmcUmcShippingAddressPo.class);
        update.setAreaName(update.getShippingProvinceName() + update.getShippingCityName() + update.getShippingCountyName() + (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)update.getShippingTownName()) ? "" : update.getShippingTownName()) + update.getShippingAddress());
        SmcRu.setUpdate((Object)((Object)reqBO), (Object)update);
        if (StringUtils.isEmpty((Object)update.getShippingEmail())) {
            update.setShippingEmail("");
        }
        if (StringUtils.isEmpty((Object)update.getShippingFixPhone())) {
            update.setShippingFixPhone("");
        }
        if (StringUtils.isEmpty((Object)update.getZipCode())) {
            update.setZipCode("");
        }
        if (StringUtils.isEmpty((Object)update.getRemark())) {
            update.setRemark("");
        }
        if (!this.smcUmcShippingAddressRepository.updateById((Object)update)) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5931\u8d25");
        }
    }

    private void valExistsAddress(SmcUmcUpdateShippingAddressReqBO reqBO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ID", (Object)reqBO.getId());
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        SmcUmcShippingAddressPo umcShippingAddressPo = (SmcUmcShippingAddressPo)this.smcUmcShippingAddressRepository.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)umcShippingAddressPo)) {
            throw new ZTBusinessException("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5\u6536\u8d27\u5730\u5740");
        }
    }

    private List<SmcUmcShippingAddressPo> valExistsDefaultAddress(SmcUmcUpdateShippingAddressReqBO reqBO, SmcUmcUpdateShippingAddressRspBO rspBO) {
        QueryWrapper queryDefaultWrapper = new QueryWrapper();
        queryDefaultWrapper.eq((Object)SmcUmcUpdateShippingAddressServiceImpl.toDatabaseColumnName("isDefault"), (Object)SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES);
        if ("1".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_USER_ID", (Object)reqBO.getUserId());
        } else if ("2".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_ORG_ID", (Object)reqBO.getOrgId());
        } else if ("3".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_COMPANY_ID", (Object)reqBO.getOrgId());
        }
        queryDefaultWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        queryDefaultWrapper.ne((Object)"ID", (Object)reqBO.getId());
        List list = this.smcUmcShippingAddressRepository.list((Wrapper)queryDefaultWrapper);
        if (ObjectUtil.isEmpty((Object)list) && !SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES.equals(reqBO.getIsDefault())) {
            reqBO.setIsDefault(SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES);
            rspBO.setIsMainFlag(true);
        }
        return list;
    }

    private void valDataRepeat(SmcUmcUpdateShippingAddressReqBO reqBO) {
        QueryWrapper queryRepeatWrapper = new QueryWrapper();
        Stream.of(SmcUmcUpdateShippingAddressReqBO.class.getDeclaredFields()).filter(field -> field.getName().startsWith("shipping")).forEach(field -> {
            try {
                field.setAccessible(true);
                String fieldName = SmcUmcUpdateShippingAddressServiceImpl.toDatabaseColumnName(field.getName());
                Object fieldValue = field.get((Object)reqBO);
                if (ObjectUtil.isNotEmpty((Object)fieldValue)) {
                    queryRepeatWrapper.eq((Object)fieldName, fieldValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        if ("1".equals(this.dataAuth)) {
            queryRepeatWrapper.eq((Object)"CREATE_USER_ID", (Object)reqBO.getUserId());
        } else if ("2".equals(this.dataAuth)) {
            queryRepeatWrapper.eq((Object)"CREATE_ORG_ID", (Object)reqBO.getOrgId());
        } else if ("3".equals(this.dataAuth)) {
            queryRepeatWrapper.eq((Object)"CREATE_COMPANY_ID", (Object)reqBO.getOrgId());
        }
        queryRepeatWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        List list = this.smcUmcShippingAddressRepository.list((Wrapper)queryRepeatWrapper);
        List collect = list.stream().filter(address -> !reqBO.getId().equals(address.getId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(collect)) {
            throw new ZTBusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u6536\u8d27\u5730\u5740\u4fe1\u606f");
        }
    }

    public static String toDatabaseColumnName(String fieldName) {
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (int i = 0; i < fieldName.length(); ++i) {
            char currentChar = fieldName.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                if (i != 0) {
                    result.append('_');
                }
                result.append(Character.toUpperCase(currentChar));
                capitalizeNext = false;
                continue;
            }
            if (Character.isLowerCase(currentChar)) {
                if (capitalizeNext) {
                    result.append(Character.toUpperCase(currentChar));
                    continue;
                }
                result.append(currentChar);
                continue;
            }
            result.append(currentChar);
            capitalizeNext = false;
        }
        return result.toString().toUpperCase();
    }

    private void val(SmcUmcUpdateShippingAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getId())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u4e3b\u952e[id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingName())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u6536\u8d27\u4eba[shippingName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingProvinceId())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u7701\u7f16\u7801[shippingProvinceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingProvinceName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u7701\u540d\u79f0[shippingProvinceName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCityId())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u5e02\u7f16\u7801[shippingCityId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCityName())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u5e02\u540d\u79f0[shippingCityName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCountyId())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u533a\u53bf\u7f16\u7801[shippingCountyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCountyName())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u533a\u53bf\u540d\u79f0[shippingCountyName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingAddress())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u8be6\u7ec6\u5730\u5740[shippingAddress]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingMobile())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u624b\u673a\u53f7\u7801[shippingMobile]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getIsDefault())) {
            throw new ZTBusinessException("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u5730\u5740[isDefault]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

