/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.org.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.SmcIdUtil;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.base.utils.StrUtil;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.org.api.SmcUmcDealOrgInfoSyncService;
import com.tydic.dyc.smc.org.bo.SmcUmcDealOrgInfoBO;
import com.tydic.dyc.smc.org.bo.SmcUmcDealOrgInfoSyncReqBO;
import com.tydic.dyc.smc.org.bo.SmcUmcDealOrgInfoSyncRspBO;
import com.tydic.dyc.smc.po.SmcUmcEnterpriseContactPo;
import com.tydic.dyc.smc.po.SmcUmcEnterpriseInfoPo;
import com.tydic.dyc.smc.po.SmcUmcExtOrgSyncLogsPo;
import com.tydic.dyc.smc.po.SmcUmcExtOrgSyncTempPo;
import com.tydic.dyc.smc.po.SmcUmcOrgInfoPo;
import com.tydic.dyc.smc.po.SmcUmcOrgTagRelPo;
import com.tydic.dyc.smc.po.SmcUmcUserInfoPo;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcEnterpriseContactRepository;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcEnterpriseInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgTagRelRepository;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcEnterpriseContactDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoQryDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgTagRelDO;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtOrgSyncLogsRepository;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtOrgSyncTempRepository;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserInfoRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.org.api.SmcUmcDealOrgInfoSyncService"})
public class SmcUmcDealOrgInfoSyncServiceImpl
implements SmcUmcDealOrgInfoSyncService {
    @Autowired
    private SmcUmcOrgInfoRepository umcOrgInfoRepository;
    @Autowired
    private SmcUmcEnterpriseInfoRepository umcEnterpriseInfoRepository;
    @Autowired
    private SmcUmcUserInfoRepository umcUserInfoRepository;
    @Autowired
    private SmcUmcOrgTagRelRepository umcOrgTagRelRepository;
    @Autowired
    private SmcUmcEnterpriseContactRepository umcEnterpriseContactRepository;
    @Autowired
    private SmcUmcExtOrgSyncTempRepository umcExtOrgSyncTempRepository;
    @Autowired
    private SmcUmcExtOrgSyncLogsRepository umcExtOrgSyncLogsRepository;
    @Value(value="${dealOrgInfoSync.outPersonageUserPath}")
    private String outPersonageUserPath;
    @Value(value="${dealOrgInfoSync.outEnterpriseUserPath}")
    private String outEnterpriseUserPath;
    @Value(value="${dealOrgInfoSync.innerEnterpriseUserPath}")
    private String innerEnterpriseUserPath;
    @Value(value="${dealOrgInfoSync.outPersonageUserParentId}")
    private Long outPersonageUserParentId;
    @Value(value="${dealOrgInfoSync.outEnterpriseUserParentId}")
    private Long outEnterpriseUserParentId;
    @Value(value="${dealOrgInfoSync.innerEnterpriseUserParentId}")
    private Long innerEnterpriseUserParentId;
    @Value(value="${dealOrgInfoSync.topParentCode}")
    private String topParentCode;
    @Value(value="${dealOrgInfoSync.updateUpOrgTypeEnable}")
    private boolean updateUpOrgTypeEnable;
    @Value(value="${dealOrgInfoSync.updateOrgTreePathType}")
    private String updateOrgTreePathType;
    @Value(value="${dealOrgInfoSync.dealOrgMaxCount}")
    private Integer dealOrgMaxCount;

    @Override
    @PostMapping(value={"dealOrgInfoSync"})
    public SmcUmcDealOrgInfoSyncRspBO dealOrgInfoSync(@RequestBody SmcUmcDealOrgInfoSyncReqBO reqBO) {
        List orgCodeList = reqBO.getDealOrgInfoBOList().stream().map(SmcUmcDealOrgInfoBO::getOrgCode).collect(Collectors.toList());
        List parentCodeList = reqBO.getDealOrgInfoBOList().stream().map(SmcUmcDealOrgInfoBO::getParentCode).collect(Collectors.toList());
        HashMap<String, SmcUmcOrgInfoDO> orgInfoMap = new HashMap();
        SmcUmcOrgInfoQryDO orgInfoQryDO = new SmcUmcOrgInfoQryDO();
        orgInfoQryDO.setOrgCodes(orgCodeList);
        orgInfoQryDO.setOrgTagId("1");
        orgInfoQryDO.setQrySideInfo(Boolean.TRUE);
        List umcOrgInfoDOList = this.umcOrgInfoRepository.getOrgInfoByTag(orgInfoQryDO).getRows();
        if (ObjectUtil.isNotEmpty((Object)umcOrgInfoDOList)) {
            orgInfoMap = umcOrgInfoDOList.stream().collect(Collectors.toMap(SmcUmcOrgInfoDO::getOrgCode, Function.identity()));
        }
        HashMap<String, SmcUmcOrgInfoDO> parentOrgInfoMap = new HashMap();
        SmcUmcOrgInfoQryDO parentOrgInfoQryDO = new SmcUmcOrgInfoQryDO();
        parentOrgInfoQryDO.setOrgCodes(parentCodeList);
        parentOrgInfoQryDO.setOrgTagId("1");
        List umcParentOrgInfoDOList = this.umcOrgInfoRepository.getOrgInfoByTag(parentOrgInfoQryDO).getRows();
        if (ObjectUtil.isNotEmpty((Object)umcParentOrgInfoDOList)) {
            parentOrgInfoMap = umcParentOrgInfoDOList.stream().collect(Collectors.toMap(SmcUmcOrgInfoDO::getOrgCode, Function.identity()));
        }
        HashMap<Long, String> failResultMap = new HashMap<Long, String>();
        ArrayList<Long> nextIdList = new ArrayList<Long>();
        ArrayList<Long> successIdList = new ArrayList<Long>();
        ArrayList<SmcUmcExtOrgSyncLogsPo> insertOrgLogsList = new ArrayList<SmcUmcExtOrgSyncLogsPo>();
        ArrayList<SmcUmcOrgInfoPo> insertOrgInfoList = new ArrayList<SmcUmcOrgInfoPo>();
        ArrayList<SmcUmcOrgInfoPo> updateOrgInfoList = new ArrayList<SmcUmcOrgInfoPo>();
        ArrayList<Long> deleteOrgIdList = new ArrayList<Long>();
        ArrayList<SmcUmcOrgTagRelPo> insertOrgTagList = new ArrayList<SmcUmcOrgTagRelPo>();
        ArrayList<SmcUmcEnterpriseInfoPo> insertEnterpriseInfoList = new ArrayList<SmcUmcEnterpriseInfoPo>();
        ArrayList<SmcUmcEnterpriseInfoPo> updateEnterpriseInfoList = new ArrayList<SmcUmcEnterpriseInfoPo>();
        ArrayList<SmcUmcEnterpriseContactPo> insertEnterpriseContactList = new ArrayList<SmcUmcEnterpriseContactPo>();
        ArrayList<SmcUmcEnterpriseContactPo> updateEnterpriseContactList = new ArrayList<SmcUmcEnterpriseContactPo>();
        for (SmcUmcDealOrgInfoBO dealOrgInfoBO : reqBO.getDealOrgInfoBOList()) {
            try {
                SmcUmcOrgInfoPo orgInfoPo;
                StrUtil.noNullStringAttr((Object)dealOrgInfoBO);
                if (this.dealMaxCount(dealOrgInfoBO, parentOrgInfoMap, failResultMap) || this.dealDelData(dealOrgInfoBO, orgInfoMap, deleteOrgIdList, successIdList, failResultMap)) continue;
                if (!orgInfoMap.containsKey(dealOrgInfoBO.getOrgCode())) {
                    if (!parentOrgInfoMap.containsKey(dealOrgInfoBO.getParentCode())) {
                        nextIdList.add(dealOrgInfoBO.getId());
                        continue;
                    }
                    SmcUmcOrgInfoDO parentOrgInfo = (SmcUmcOrgInfoDO)parentOrgInfoMap.get(dealOrgInfoBO.getParentCode());
                    orgInfoPo = this.setInsertOrgInfo(dealOrgInfoBO, parentOrgInfo, insertOrgInfoList);
                    this.setInsertOrgTagRel(dealOrgInfoBO, orgInfoPo, insertOrgTagList, null);
                    this.setInsertEnterpriseInfo(dealOrgInfoBO, orgInfoPo, insertEnterpriseInfoList);
                    this.setInsertEnterpriseContact(dealOrgInfoBO, orgInfoPo, insertEnterpriseContactList);
                    successIdList.add(dealOrgInfoBO.getId());
                    continue;
                }
                if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getParentCode()) && !parentOrgInfoMap.containsKey(dealOrgInfoBO.getParentCode())) {
                    nextIdList.add(dealOrgInfoBO.getId());
                    continue;
                }
                SmcUmcOrgInfoDO oldOrgInfoPo = (SmcUmcOrgInfoDO)orgInfoMap.get(dealOrgInfoBO.getOrgCode());
                orgInfoPo = this.updateOrgInfo(dealOrgInfoBO, oldOrgInfoPo, parentOrgInfoMap, updateOrgInfoList);
                List orgTagRelList = oldOrgInfoPo.getOrgTagRelList();
                List<String> tagIdList = orgTagRelList.stream().map(SmcUmcOrgTagRelDO::getTagId).collect(Collectors.toList());
                this.setInsertOrgTagRel(dealOrgInfoBO, orgInfoPo, insertOrgTagList, tagIdList);
                this.setUpdateEnterpriseInfo(dealOrgInfoBO, orgInfoPo, updateEnterpriseInfoList);
                this.setUpdateEnterpriseContact(dealOrgInfoBO, oldOrgInfoPo, orgInfoPo, updateEnterpriseContactList, insertEnterpriseContactList);
                successIdList.add(dealOrgInfoBO.getId());
            }
            catch (Exception e) {
                failResultMap.put(dealOrgInfoBO.getId(), e.getMessage());
            }
        }
        this.dealInsert(insertOrgInfoList, insertOrgTagList, insertEnterpriseInfoList, insertEnterpriseContactList);
        this.dealUpdate(updateOrgInfoList, updateEnterpriseInfoList, updateEnterpriseContactList);
        this.dealDelete(deleteOrgIdList);
        this.dealTemp(failResultMap, reqBO.getFailIdList(), insertOrgLogsList, nextIdList, successIdList);
        return (SmcUmcDealOrgInfoSyncRspBO)SmcRu.success(SmcUmcDealOrgInfoSyncRspBO.class);
    }

    private void dealTemp(Map<Long, String> failResultMap, List<Long> failIdList, List<SmcUmcExtOrgSyncLogsPo> insertOrgLogsList, List<Long> nextIdList, List<Long> successIdList) {
        if (ObjectUtil.isNotEmpty(failResultMap)) {
            ArrayList<Long> dealFailIdList = new ArrayList<Long>(failResultMap.keySet());
            List dealFailTempList = this.umcExtOrgSyncTempRepository.listByIds(dealFailIdList);
            dealFailTempList.forEach(temp -> {
                SmcUmcExtOrgSyncLogsPo logs = (SmcUmcExtOrgSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtOrgSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc((String)failResultMap.get(temp.getId()));
                insertOrgLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(failIdList)) {
            List failTempList = this.umcExtOrgSyncTempRepository.listByIds(failIdList);
            failTempList.forEach(temp -> {
                SmcUmcExtOrgSyncLogsPo logs = (SmcUmcExtOrgSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtOrgSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc("\u5fc5\u4f20\u53c2\u6570\u7f3a\u5931");
                insertOrgLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(nextIdList)) {
            LambdaUpdateWrapper nextOrgDeal = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)nextOrgDeal.in(SmcUmcExtOrgSyncTempPo::getId, nextIdList)).set(SmcUmcExtOrgSyncTempPo::getDealTime, (Object)new Date())).set(SmcUmcExtOrgSyncTempPo::getDealResult, (Object)SmcUmcConstants.DealResult.NEXT);
            this.umcExtOrgSyncTempRepository.update((Wrapper)nextOrgDeal);
        }
        if (ObjectUtil.isNotEmpty(successIdList)) {
            List successTemp = this.umcExtOrgSyncTempRepository.listByIds(successIdList);
            successTemp.forEach(temp -> {
                SmcUmcExtOrgSyncLogsPo logs = (SmcUmcExtOrgSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtOrgSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.SUCCESS);
                logs.setDealResultDesc("\u5904\u7406\u6210\u529f");
                insertOrgLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(insertOrgLogsList)) {
            List ids = insertOrgLogsList.stream().map(SmcUmcExtOrgSyncLogsPo::getId).collect(Collectors.toList());
            this.umcExtOrgSyncLogsRepository.saveBatch(insertOrgLogsList);
            this.umcExtOrgSyncTempRepository.removeBatchByIds(ids);
        }
    }

    private void dealDelete(List<Long> deleteOrgIdList) {
        if (ObjectUtil.isNotEmpty(deleteOrgIdList)) {
            LambdaUpdateWrapper delOrgWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delOrgWrapper.in(SmcUmcOrgInfoPo::getOrgId, deleteOrgIdList)).set(SmcUmcOrgInfoPo::getDelFlag, (Object)"1");
            this.umcOrgInfoRepository.update((Wrapper)delOrgWrapper);
            LambdaUpdateWrapper delEnterpriseWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delEnterpriseWrapper.in(SmcUmcEnterpriseInfoPo::getOrgId, deleteOrgIdList)).set(SmcUmcEnterpriseInfoPo::getDelFlag, (Object)"1");
            this.umcEnterpriseInfoRepository.update((Wrapper)delEnterpriseWrapper);
            LambdaUpdateWrapper delOrgTagWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delOrgTagWrapper.in(SmcUmcOrgTagRelPo::getOrgId, deleteOrgIdList)).set(SmcUmcOrgTagRelPo::getDelFlag, (Object)"1");
            this.umcOrgTagRelRepository.update((Wrapper)delOrgTagWrapper);
            LambdaUpdateWrapper delEnterpriseContactWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)delEnterpriseContactWrapper.in(SmcUmcEnterpriseContactPo::getOrgId, deleteOrgIdList)).eq(SmcUmcEnterpriseContactPo::getTagId, (Object)"1")).set(SmcUmcEnterpriseContactPo::getDelFlag, (Object)"1");
            this.umcEnterpriseContactRepository.update((Wrapper)delEnterpriseContactWrapper);
        }
    }

    private void dealUpdate(List<SmcUmcOrgInfoPo> updateOrgInfoList, List<SmcUmcEnterpriseInfoPo> updateEnterpriseInfoList, List<SmcUmcEnterpriseContactPo> updateEnterpriseContactList) {
        if (ObjectUtil.isNotEmpty(updateOrgInfoList)) {
            updateOrgInfoList.forEach(updateOrgInfo -> this.umcOrgInfoRepository.updateById(updateOrgInfo));
        }
        if (ObjectUtil.isNotEmpty(updateEnterpriseInfoList)) {
            updateEnterpriseInfoList.forEach(updateEnterpriseInfo -> this.umcEnterpriseInfoRepository.updateById(updateEnterpriseInfo));
        }
        if (ObjectUtil.isNotEmpty(updateEnterpriseContactList)) {
            updateEnterpriseContactList.forEach(updateEnterpriseContact -> this.umcEnterpriseContactRepository.updateById(updateEnterpriseContact));
        }
    }

    private void dealInsert(List<SmcUmcOrgInfoPo> insertOrgInfoList, List<SmcUmcOrgTagRelPo> insertOrgTagList, List<SmcUmcEnterpriseInfoPo> insertEnterpriseInfoList, List<SmcUmcEnterpriseContactPo> insertEnterpriseContactList) {
        if (ObjectUtil.isNotEmpty(insertOrgInfoList)) {
            this.umcOrgInfoRepository.saveBatch(insertOrgInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertOrgTagList)) {
            this.umcOrgTagRelRepository.saveBatch(insertOrgTagList);
        }
        if (ObjectUtil.isNotEmpty(insertEnterpriseInfoList)) {
            this.umcEnterpriseInfoRepository.saveBatch(insertEnterpriseInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertEnterpriseContactList)) {
            this.umcEnterpriseContactRepository.saveBatch(insertEnterpriseContactList);
        }
    }

    private boolean dealDelData(SmcUmcDealOrgInfoBO dealOrgInfoBO, Map<String, SmcUmcOrgInfoDO> orgInfoMap, List<Long> deleteOrgIdList, List<Long> successIdList, Map<Long, String> failResultMap) {
        if ("1".equals(dealOrgInfoBO.getDelFlag())) {
            SmcUmcOrgInfoDO umcOrgInfoDO;
            if (orgInfoMap.containsKey(dealOrgInfoBO.getOrgCode())) {
                umcOrgInfoDO = orgInfoMap.get(dealOrgInfoBO.getOrgCode());
                LambdaQueryWrapper querySubWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)querySubWrapper.likeRight(SmcUmcOrgInfoPo::getOrgTreePath, (Object)umcOrgInfoDO.getOrgTreePath())).ne(SmcUmcOrgInfoPo::getOrgId, (Object)umcOrgInfoDO.getOrgId())).eq(SmcUmcOrgInfoPo::getDelFlag, (Object)"0");
                List subOrgInfoList = this.umcOrgInfoRepository.list((Wrapper)querySubWrapper);
                if (ObjectUtil.isNotEmpty((Object)subOrgInfoList)) {
                    failResultMap.put(dealOrgInfoBO.getId(), "\u5f53\u524d\u673a\u6784\u5b58\u5728\u4e0b\u7ea7\u673a\u6784\uff0c\u4e0d\u80fd\u5220\u9664");
                    return true;
                }
                LambdaQueryWrapper queryUserWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryUserWrapper.likeRight(SmcUmcUserInfoPo::getOrgTreePath, (Object)umcOrgInfoDO.getOrgTreePath())).eq(SmcUmcUserInfoPo::getDelFlag, (Object)"0");
                List userInfoList = this.umcUserInfoRepository.list((Wrapper)queryUserWrapper);
                if (ObjectUtil.isNotEmpty((Object)userInfoList)) {
                    failResultMap.put(dealOrgInfoBO.getId(), "\u5f53\u524d\u673a\u6784\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664");
                    return true;
                }
            } else {
                failResultMap.put(dealOrgInfoBO.getId(), "\u5f53\u524d\u673a\u6784\u5728\u6b63\u5f0f\u8868\u4e0d\u5b58\u5728");
                return true;
            }
            deleteOrgIdList.add(umcOrgInfoDO.getOrgId());
            successIdList.add(dealOrgInfoBO.getId());
            return true;
        }
        return false;
    }

    private boolean dealMaxCount(SmcUmcDealOrgInfoBO dealOrgInfoBO, Map<String, SmcUmcOrgInfoDO> parentOrgInfoMap, Map<Long, String> failResultMap) {
        if (dealOrgInfoBO.getCurrentDealCount() > this.dealOrgMaxCount) {
            if (parentOrgInfoMap.containsKey(dealOrgInfoBO.getParentCode())) {
                failResultMap.put(dealOrgInfoBO.getId(), "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c\u6570\u636e\u65e0\u6cd5\u5904\u7406");
            } else {
                failResultMap.put(dealOrgInfoBO.getId(), "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c\u4e0a\u7ea7\u673a\u6784\u3010" + dealOrgInfoBO.getParentCode() + "\u3011\u4e0d\u5b58\u5728");
            }
            return true;
        }
        return false;
    }

    private void setUpdateEnterpriseContact(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoDO oldOrgInfoPo, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseContactPo> updateEnterpriseContactList, List<SmcUmcEnterpriseContactPo> insertEnterpriseContactList) {
        if (dealOrgInfoBO.isCreateContactInfo()) {
            SmcUmcEnterpriseContactDO umcEnterpriseContactDO = (SmcUmcEnterpriseContactDO)oldOrgInfoPo.getEnterpriseContactList().get(0);
            SmcUmcEnterpriseContactPo umcEnterpriseContactPo = new SmcUmcEnterpriseContactPo();
            umcEnterpriseContactPo.setOrgId(orgInfoPo.getOrgId());
            umcEnterpriseContactPo.setTagId("1");
            umcEnterpriseContactPo.setTenantId(dealOrgInfoBO.getTenantId());
            umcEnterpriseContactPo.setContactName(dealOrgInfoBO.getContactName());
            umcEnterpriseContactPo.setPhoneNumber(dealOrgInfoBO.getPhoneNumber());
            umcEnterpriseContactPo.setTel(dealOrgInfoBO.getTel());
            umcEnterpriseContactPo.setEmail(dealOrgInfoBO.getEmail());
            if (ObjectUtil.isNotEmpty((Object)umcEnterpriseContactDO)) {
                umcEnterpriseContactPo.setContactId(umcEnterpriseContactDO.getContactId());
                umcEnterpriseContactPo.setUpdateOperId(orgInfoPo.getUpdateOperId());
                umcEnterpriseContactPo.setUpdateOperName(orgInfoPo.getUpdateOperName());
                umcEnterpriseContactPo.setUpdateTime(orgInfoPo.getUpdateTime());
                updateEnterpriseContactList.add(umcEnterpriseContactPo);
            } else {
                umcEnterpriseContactPo.setContactId(Long.valueOf(SmcIdUtil.nextId()));
                umcEnterpriseContactPo.setCreateOperId(orgInfoPo.getCreateOperId());
                umcEnterpriseContactPo.setCreateOperName(orgInfoPo.getCreateOperName());
                umcEnterpriseContactPo.setCreateTime(orgInfoPo.getCreateTime());
                umcEnterpriseContactPo.setDelFlag("0");
                insertEnterpriseContactList.add(umcEnterpriseContactPo);
            }
        }
    }

    private void setUpdateEnterpriseInfo(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseInfoPo> updateEnterpriseInfoList) {
        SmcUmcEnterpriseInfoPo enterpriseInfoPo = (SmcUmcEnterpriseInfoPo)SmcRu.js((Object)dealOrgInfoBO, SmcUmcEnterpriseInfoPo.class);
        enterpriseInfoPo.setIsMerchant(null);
        enterpriseInfoPo.setIsShopOrg(null);
        enterpriseInfoPo.setOrgId(orgInfoPo.getOrgId());
        enterpriseInfoPo.setUpdateOperId(orgInfoPo.getUpdateOperId());
        enterpriseInfoPo.setUpdateOperName(orgInfoPo.getUpdateOperName());
        enterpriseInfoPo.setUpdateTime(orgInfoPo.getUpdateTime());
        updateEnterpriseInfoList.add(enterpriseInfoPo);
    }

    private SmcUmcOrgInfoPo updateOrgInfo(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoDO oldOrgInfoPo, Map<String, SmcUmcOrgInfoDO> parentOrgInfoMap, List<SmcUmcOrgInfoPo> updateOrgInfoList) {
        SmcUmcOrgInfoPo orgInfoPo = (SmcUmcOrgInfoPo)SmcRu.js((Object)dealOrgInfoBO, SmcUmcOrgInfoPo.class);
        orgInfoPo.setOrgId(oldOrgInfoPo.getOrgId());
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getParentCode())) {
            SmcUmcOrgInfoDO parentOrgInfo = parentOrgInfoMap.get(dealOrgInfoBO.getParentCode());
            this.setParentIdAndOrgTreePath(dealOrgInfoBO, orgInfoPo, parentOrgInfo);
        }
        this.setCompanyId(dealOrgInfoBO, orgInfoPo);
        this.updateCompanyId(oldOrgInfoPo, orgInfoPo);
        this.updateOrgTreePath(oldOrgInfoPo, orgInfoPo);
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getUpdateOperId())) {
            orgInfoPo.setUpdateOperId(dealOrgInfoBO.getUpdateOperId());
        } else {
            orgInfoPo.setUpdateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getUpdateOperName())) {
            orgInfoPo.setUpdateOperName(dealOrgInfoBO.getUpdateOperName());
        } else {
            orgInfoPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getUpdateTime())) {
            orgInfoPo.setUpdateTime(dealOrgInfoBO.getUpdateTime());
        } else {
            orgInfoPo.setUpdateTime(new Date());
        }
        updateOrgInfoList.add(orgInfoPo);
        return orgInfoPo;
    }

    private void updateOrgTreePath(SmcUmcOrgInfoDO oldOrgInfoPo, SmcUmcOrgInfoPo orgInfoPo) {
        if (!oldOrgInfoPo.getOrgTreePath().equals(orgInfoPo.getOrgTreePath())) {
            if ("2".equals(this.updateOrgTreePathType)) {
                LambdaUpdateWrapper updateOrgWrapper = new LambdaUpdateWrapper();
                updateOrgWrapper.likeRight(SmcUmcOrgInfoPo::getOrgTreePath, (Object)oldOrgInfoPo.getOrgTreePath());
                updateOrgWrapper.setSql("org_tree_path = REPLACE(org_tree_path, '" + oldOrgInfoPo.getOrgTreePath() + "', '" + orgInfoPo.getOrgTreePath() + "')");
                this.umcOrgInfoRepository.update(null, (Wrapper)updateOrgWrapper);
                LambdaUpdateWrapper updateUserWrapper = new LambdaUpdateWrapper();
                updateUserWrapper.likeRight(SmcUmcUserInfoPo::getOrgTreePath, (Object)oldOrgInfoPo.getOrgTreePath());
                updateUserWrapper.setSql("org_tree_path = REPLACE(org_tree_path, '" + oldOrgInfoPo.getOrgTreePath() + "', '" + orgInfoPo.getOrgTreePath() + "')");
                this.umcUserInfoRepository.update(null, (Wrapper)updateUserWrapper);
            } else {
                LambdaUpdateWrapper updateOrgTreePathWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)updateOrgTreePathWrapper.eq(SmcUmcUserInfoPo::getOrgId, (Object)orgInfoPo.getOrgId())).set(SmcUmcUserInfoPo::getOrgTreePath, (Object)orgInfoPo.getOrgTreePath());
                this.umcUserInfoRepository.update((Wrapper)updateOrgTreePathWrapper);
            }
        }
    }

    private void updateCompanyId(SmcUmcOrgInfoDO oldOrgInfoPo, SmcUmcOrgInfoPo orgInfoPo) {
        if (!oldOrgInfoPo.getCompanyId().equals(orgInfoPo.getCompanyId()) && !this.updateUpOrgTypeEnable) {
            LambdaQueryWrapper querySubWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)querySubWrapper.likeRight(SmcUmcOrgInfoPo::getOrgTreePath, (Object)orgInfoPo.getOrgTreePath())).eq(SmcUmcOrgInfoPo::getDelFlag, (Object)"0");
            List subOrgInfoPoList = this.umcOrgInfoRepository.list((Wrapper)querySubWrapper);
            for (SmcUmcOrgInfoPo subOrgInfoPo : subOrgInfoPoList) {
                SmcUmcOrgInfoPo updateSubCompanyId = new SmcUmcOrgInfoPo();
                updateSubCompanyId.setOrgId(subOrgInfoPo.getOrgId());
                updateSubCompanyId.setCompanyId(this.umcOrgInfoRepository.getParentNoDepartmentId(subOrgInfoPo.getOrgTreePath()));
                this.umcOrgInfoRepository.updateById((Object)updateSubCompanyId);
                LambdaUpdateWrapper updateSubCompanyWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)updateSubCompanyWrapper.eq(SmcUmcUserInfoPo::getOrgId, (Object)subOrgInfoPo.getOrgId())).set(SmcUmcUserInfoPo::getCompanyId, (Object)updateSubCompanyId.getCompanyId());
                this.umcUserInfoRepository.update((Wrapper)updateSubCompanyWrapper);
            }
        }
    }

    private void setInsertEnterpriseContact(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseContactPo> insertEnterpriseContactList) {
        if (dealOrgInfoBO.isCreateContactInfo()) {
            SmcUmcEnterpriseContactPo umcEnterpriseContactPo = new SmcUmcEnterpriseContactPo();
            umcEnterpriseContactPo.setContactId(Long.valueOf(SmcIdUtil.nextId()));
            umcEnterpriseContactPo.setOrgId(orgInfoPo.getOrgId());
            umcEnterpriseContactPo.setTagId("1");
            umcEnterpriseContactPo.setTenantId(dealOrgInfoBO.getTenantId());
            umcEnterpriseContactPo.setContactName(dealOrgInfoBO.getContactName());
            umcEnterpriseContactPo.setPhoneNumber(dealOrgInfoBO.getPhoneNumber());
            umcEnterpriseContactPo.setTel(dealOrgInfoBO.getTel());
            umcEnterpriseContactPo.setEmail(dealOrgInfoBO.getEmail());
            umcEnterpriseContactPo.setCreateOperId(orgInfoPo.getCreateOperId());
            umcEnterpriseContactPo.setCreateOperName(orgInfoPo.getCreateOperName());
            umcEnterpriseContactPo.setCreateTime(orgInfoPo.getCreateTime());
            umcEnterpriseContactPo.setDelFlag("0");
            insertEnterpriseContactList.add(umcEnterpriseContactPo);
        }
    }

    private void setInsertOrgTagRel(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcOrgTagRelPo> insertOrgTagList, List<String> tagIdList) {
        if (!StringUtils.isBlank((CharSequence)dealOrgInfoBO.getIsProfess())) {
            for (int i = 0; i < dealOrgInfoBO.getIsProfess().length(); ++i) {
                if (ObjectUtil.isNotEmpty(tagIdList) && tagIdList.contains(dealOrgInfoBO.getIsProfess().charAt(i) + "")) continue;
                SmcUmcOrgTagRelPo orgTagRelPo = new SmcUmcOrgTagRelPo();
                orgTagRelPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                orgTagRelPo.setOrgId(orgInfoPo.getOrgId());
                orgTagRelPo.setTenantId(dealOrgInfoBO.getTenantId());
                orgTagRelPo.setTagId(String.valueOf(dealOrgInfoBO.getIsProfess().charAt(i)));
                orgTagRelPo.setTagStatus("1");
                orgTagRelPo.setDelFlag("0");
                orgTagRelPo.setCreateOperId(orgInfoPo.getCreateOperId());
                orgTagRelPo.setCreateOperName(orgInfoPo.getCreateOperName());
                orgTagRelPo.setCreateTime(orgInfoPo.getCreateTime());
                insertOrgTagList.add(orgTagRelPo);
            }
        }
    }

    private SmcUmcOrgInfoPo setInsertOrgInfo(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoDO parentOrgInfo, List<SmcUmcOrgInfoPo> insertOrgInfoList) {
        SmcUmcOrgInfoPo orgInfoPo = (SmcUmcOrgInfoPo)SmcRu.js((Object)dealOrgInfoBO, SmcUmcOrgInfoPo.class);
        orgInfoPo.setOrgId(Long.valueOf(SmcIdUtil.nextId()));
        this.setParentIdAndOrgTreePath(dealOrgInfoBO, orgInfoPo, parentOrgInfo);
        this.setCompanyId(dealOrgInfoBO, orgInfoPo);
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getCreateOperId())) {
            orgInfoPo.setCreateOperId(dealOrgInfoBO.getCreateOperId());
        } else {
            orgInfoPo.setCreateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getCreateOperName())) {
            orgInfoPo.setCreateOperName(dealOrgInfoBO.getCreateOperName());
        } else {
            orgInfoPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isNotEmpty((Object)dealOrgInfoBO.getCreateTime())) {
            orgInfoPo.setCreateTime(dealOrgInfoBO.getCreateTime());
        } else {
            orgInfoPo.setCreateTime(new Date());
        }
        orgInfoPo.setDelFlag("0");
        insertOrgInfoList.add(orgInfoPo);
        return orgInfoPo;
    }

    private void setInsertEnterpriseInfo(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseInfoPo> insertEnterpriseInfoList) {
        SmcUmcEnterpriseInfoPo enterpriseInfoPo = (SmcUmcEnterpriseInfoPo)SmcRu.js((Object)dealOrgInfoBO, SmcUmcEnterpriseInfoPo.class);
        enterpriseInfoPo.setOrgId(orgInfoPo.getOrgId());
        enterpriseInfoPo.setIsMerchant("0");
        enterpriseInfoPo.setIsShopOrg("0");
        enterpriseInfoPo.setCreateOperId(orgInfoPo.getCreateOperId());
        enterpriseInfoPo.setCreateOperName(orgInfoPo.getCreateOperName());
        enterpriseInfoPo.setCreateTime(orgInfoPo.getCreateTime());
        enterpriseInfoPo.setDelFlag("0");
        insertEnterpriseInfoList.add(enterpriseInfoPo);
    }

    private void setParentIdAndOrgTreePath(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoPo orgInfoPo, SmcUmcOrgInfoDO parentOrgInfo) {
        if (this.topParentCode.equals(dealOrgInfoBO.getParentCode())) {
            if ("1".equals(dealOrgInfoBO.getOrgClass())) {
                orgInfoPo.setParentId(this.outPersonageUserParentId);
            } else if ("2".equals(dealOrgInfoBO.getOrgClass())) {
                orgInfoPo.setParentId(this.outEnterpriseUserParentId);
            } else if ("4".equals(dealOrgInfoBO.getOrgClass())) {
                orgInfoPo.setParentId(this.innerEnterpriseUserParentId);
            }
            if ("1".equals(dealOrgInfoBO.getOrgClass())) {
                orgInfoPo.setOrgTreePath(this.outPersonageUserPath + orgInfoPo.getOrgId() + "-");
            } else if ("2".equals(dealOrgInfoBO.getOrgClass())) {
                orgInfoPo.setOrgTreePath(this.outEnterpriseUserPath + orgInfoPo.getOrgId() + "-");
            } else if ("4".equals(dealOrgInfoBO.getOrgClass())) {
                orgInfoPo.setOrgTreePath(this.innerEnterpriseUserPath + orgInfoPo.getOrgId() + "-");
            }
        } else {
            orgInfoPo.setParentId(parentOrgInfo.getOrgId());
            orgInfoPo.setOrgTreePath(parentOrgInfo.getOrgTreePath() + orgInfoPo.getOrgId() + "-");
        }
        orgInfoPo.setDeep(Integer.valueOf(orgInfoPo.getOrgTreePath().split("-").length));
    }

    private void setCompanyId(SmcUmcDealOrgInfoBO dealOrgInfoBO, SmcUmcOrgInfoPo orgInfoPo) {
        if (!SmcUmcConstants.OrgType.DEPT.equals(dealOrgInfoBO.getOrgType())) {
            orgInfoPo.setCompanyId(orgInfoPo.getOrgId());
        } else if (this.updateUpOrgTypeEnable) {
            SmcUmcOrgInfoPo upOrgPo = new SmcUmcOrgInfoPo();
            upOrgPo.setOrgId(orgInfoPo.getParentId());
            upOrgPo.setCompanyId(orgInfoPo.getParentId());
            upOrgPo.setOrgType(SmcUmcConstants.OrgType.COMPANY);
            this.umcOrgInfoRepository.updateById((Object)upOrgPo);
            orgInfoPo.setCompanyId(orgInfoPo.getParentId());
        } else {
            String parentOrgTreePath = null;
            if (this.topParentCode.equals(dealOrgInfoBO.getParentCode())) {
                if ("1".equals(dealOrgInfoBO.getOrgClass())) {
                    parentOrgTreePath = this.outPersonageUserPath;
                } else if ("2".equals(dealOrgInfoBO.getOrgClass())) {
                    parentOrgTreePath = this.outEnterpriseUserPath;
                } else if ("4".equals(dealOrgInfoBO.getOrgClass())) {
                    parentOrgTreePath = this.innerEnterpriseUserPath;
                }
            } else {
                parentOrgTreePath = orgInfoPo.getOrgTreePath();
            }
            orgInfoPo.setCompanyId(this.umcOrgInfoRepository.getParentNoDepartmentId(parentOrgTreePath));
        }
    }
}

