/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.supplier.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.SmcIdUtil;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.base.utils.StrUtil;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.po.SmcUmcEnterpriseContactPo;
import com.tydic.dyc.smc.po.SmcUmcEnterpriseInfoPo;
import com.tydic.dyc.smc.po.SmcUmcExtSupplierSyncLogsPo;
import com.tydic.dyc.smc.po.SmcUmcExtSupplierSyncTempPo;
import com.tydic.dyc.smc.po.SmcUmcOrgInfoPo;
import com.tydic.dyc.smc.po.SmcUmcOrgTagRelPo;
import com.tydic.dyc.smc.po.SmcUmcUserInfoPo;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcEnterpriseContactRepository;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcEnterpriseInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgTagRelRepository;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcEnterpriseContactDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoQryDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgTagRelDO;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtSupplierSyncLogsRepository;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtSupplierSyncTempRepository;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserInfoRepository;
import com.tydic.dyc.smc.supplier.api.SmcUmcDealSupplierInfoSyncService;
import com.tydic.dyc.smc.supplier.bo.SmcUmcDealSupplierInfoBO;
import com.tydic.dyc.smc.supplier.bo.SmcUmcDealSupplierInfoSyncReqBO;
import com.tydic.dyc.smc.supplier.bo.SmcUmcDealSupplierInfoSyncRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.supplier.api.SmcUmcDealSupplierInfoSyncService"})
public class SmcUmcDealSupplierInfoSyncServiceImpl
implements SmcUmcDealSupplierInfoSyncService {
    @Autowired
    private SmcUmcOrgInfoRepository umcOrgInfoRepository;
    @Autowired
    private SmcUmcUserInfoRepository umcUserInfoRepository;
    @Autowired
    private SmcUmcEnterpriseInfoRepository umcEnterpriseInfoRepository;
    @Autowired
    private SmcUmcOrgTagRelRepository umcOrgTagRelRepository;
    @Autowired
    private SmcUmcEnterpriseContactRepository umcEnterpriseContactRepository;
    @Autowired
    private SmcUmcExtSupplierSyncTempRepository umcExtSupplierSyncTempRepository;
    @Autowired
    private SmcUmcExtSupplierSyncLogsRepository umcExtSupplierSyncLogsRepository;
    @Value(value="${dealSupplierInfoSync.outPersonageUserPath}")
    private String outPersonageUserPath;
    @Value(value="${dealSupplierInfoSync.outEnterpriseUserPath}")
    private String outEnterpriseUserPath;
    @Value(value="${dealSupplierInfoSync.outPersonageUserParentId}")
    private Long outPersonageUserParentId;
    @Value(value="${dealSupplierInfoSync.outEnterpriseUserParentId}")
    private Long outEnterpriseUserParentId;
    @Value(value="${dealSupplierInfoSync.dealOrgMaxCount}")
    private Integer dealOrgMaxCount;

    @Override
    @PostMapping(value={"dealSupplierInfoSync"})
    public SmcUmcDealSupplierInfoSyncRspBO dealSupplierInfoSync(@RequestBody SmcUmcDealSupplierInfoSyncReqBO reqBO) {
        List orgCodeList = reqBO.getDealSupplierInfoBOList().stream().map(SmcUmcDealSupplierInfoBO::getOrgCode).collect(Collectors.toList());
        HashMap<String, SmcUmcOrgInfoDO> orgInfoMap = new HashMap();
        SmcUmcOrgInfoQryDO orgInfoQryDO = new SmcUmcOrgInfoQryDO();
        orgInfoQryDO.setOrgCodes(orgCodeList);
        orgInfoQryDO.setQrySideInfo(Boolean.TRUE);
        List umcOrgInfoDOList = this.umcOrgInfoRepository.getOrgInfoByTag(orgInfoQryDO).getRows();
        if (ObjectUtil.isNotEmpty((Object)umcOrgInfoDOList)) {
            orgInfoMap = umcOrgInfoDOList.stream().collect(Collectors.toMap(SmcUmcOrgInfoDO::getOrgCode, Function.identity()));
        }
        HashMap<Long, String> failResultMap = new HashMap<Long, String>();
        ArrayList<Long> nextIdList = new ArrayList<Long>();
        ArrayList<Long> successIdList = new ArrayList<Long>();
        ArrayList<SmcUmcExtSupplierSyncLogsPo> insertSupplierLogsList = new ArrayList<SmcUmcExtSupplierSyncLogsPo>();
        ArrayList<SmcUmcOrgInfoPo> insertOrgInfoList = new ArrayList<SmcUmcOrgInfoPo>();
        ArrayList<SmcUmcOrgInfoPo> updateOrgInfoList = new ArrayList<SmcUmcOrgInfoPo>();
        ArrayList<Long> deleteOrgIdList = new ArrayList<Long>();
        ArrayList<SmcUmcOrgTagRelPo> insertOrgTagList = new ArrayList<SmcUmcOrgTagRelPo>();
        ArrayList<SmcUmcEnterpriseInfoPo> insertEnterpriseInfoList = new ArrayList<SmcUmcEnterpriseInfoPo>();
        ArrayList<SmcUmcEnterpriseInfoPo> updateEnterpriseInfoList = new ArrayList<SmcUmcEnterpriseInfoPo>();
        ArrayList<SmcUmcEnterpriseContactPo> insertEnterpriseContactList = new ArrayList<SmcUmcEnterpriseContactPo>();
        ArrayList<SmcUmcEnterpriseContactPo> updateEnterpriseContactList = new ArrayList<SmcUmcEnterpriseContactPo>();
        for (SmcUmcDealSupplierInfoBO dealSupplierInfoBO : reqBO.getDealSupplierInfoBOList()) {
            try {
                StrUtil.noNullStringAttr((Object)dealSupplierInfoBO);
                if (this.dealMaxCount(dealSupplierInfoBO, failResultMap) || this.dealDelData(dealSupplierInfoBO, orgInfoMap, deleteOrgIdList, successIdList, failResultMap)) continue;
                if (!orgInfoMap.containsKey(dealSupplierInfoBO.getOrgCode())) {
                    if ("4".equals(dealSupplierInfoBO.getOrgClass())) {
                        nextIdList.add(dealSupplierInfoBO.getId());
                    }
                    SmcUmcOrgInfoPo orgInfoPo = this.setInsertSupplierInfo(dealSupplierInfoBO, insertOrgInfoList);
                    this.setInsertOrgTagRel(dealSupplierInfoBO, orgInfoPo, insertOrgTagList, null);
                    this.setInsertEnterpriseInfo(dealSupplierInfoBO, orgInfoPo, insertEnterpriseInfoList);
                    this.setInsertEnterpriseContact(dealSupplierInfoBO, orgInfoPo, insertEnterpriseContactList);
                    successIdList.add(dealSupplierInfoBO.getId());
                    continue;
                }
                SmcUmcOrgInfoDO oldOrgInfoPo = (SmcUmcOrgInfoDO)orgInfoMap.get(dealSupplierInfoBO.getOrgCode());
                SmcUmcOrgInfoPo orgInfoPo = this.updateOrgInfo(dealSupplierInfoBO, oldOrgInfoPo, updateOrgInfoList);
                List orgTagRelList = oldOrgInfoPo.getOrgTagRelList();
                List<String> tagIdList = orgTagRelList.stream().map(SmcUmcOrgTagRelDO::getTagId).collect(Collectors.toList());
                this.setInsertOrgTagRel(dealSupplierInfoBO, orgInfoPo, insertOrgTagList, tagIdList);
                this.setUpdateEnterpriseInfo(dealSupplierInfoBO, orgInfoPo, updateEnterpriseInfoList);
                this.setUpdateEnterpriseContact(dealSupplierInfoBO, oldOrgInfoPo, orgInfoPo, updateEnterpriseContactList, insertEnterpriseContactList);
                successIdList.add(dealSupplierInfoBO.getId());
            }
            catch (Exception e) {
                failResultMap.put(dealSupplierInfoBO.getId(), e.getMessage());
            }
        }
        this.dealInsert(insertOrgInfoList, insertOrgTagList, insertEnterpriseInfoList, insertEnterpriseContactList);
        this.dealUpdate(updateOrgInfoList, updateEnterpriseInfoList, updateEnterpriseContactList);
        this.dealDelete(deleteOrgIdList);
        this.dealTemp(failResultMap, reqBO.getFailIdList(), insertSupplierLogsList, nextIdList, successIdList);
        return (SmcUmcDealSupplierInfoSyncRspBO)SmcRu.success(SmcUmcDealSupplierInfoSyncRspBO.class);
    }

    private void dealTemp(Map<Long, String> failResultMap, List<Long> failIdList, List<SmcUmcExtSupplierSyncLogsPo> insertSupplierLogsList, List<Long> nextIdList, List<Long> successIdList) {
        if (ObjectUtil.isNotEmpty(failResultMap)) {
            ArrayList<Long> dealFailIdList = new ArrayList<Long>(failResultMap.keySet());
            List dealFailTempList = this.umcExtSupplierSyncTempRepository.listByIds(dealFailIdList);
            dealFailTempList.forEach(temp -> {
                SmcUmcExtSupplierSyncLogsPo logs = (SmcUmcExtSupplierSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtSupplierSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc((String)failResultMap.get(temp.getId()));
                insertSupplierLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(failIdList)) {
            List failTempList = this.umcExtSupplierSyncTempRepository.listByIds(failIdList);
            failTempList.forEach(temp -> {
                SmcUmcExtSupplierSyncLogsPo logs = (SmcUmcExtSupplierSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtSupplierSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc("\u5fc5\u4f20\u53c2\u6570\u7f3a\u5931");
                insertSupplierLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(nextIdList)) {
            LambdaUpdateWrapper nextSupplierDeal = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)nextSupplierDeal.in(SmcUmcExtSupplierSyncTempPo::getId, nextIdList)).set(SmcUmcExtSupplierSyncTempPo::getDealTime, (Object)new Date())).set(SmcUmcExtSupplierSyncTempPo::getDealResult, (Object)SmcUmcConstants.DealResult.NEXT);
            this.umcExtSupplierSyncTempRepository.update((Wrapper)nextSupplierDeal);
        }
        if (ObjectUtil.isNotEmpty(successIdList)) {
            List successTemp = this.umcExtSupplierSyncTempRepository.listByIds(successIdList);
            successTemp.forEach(temp -> {
                SmcUmcExtSupplierSyncLogsPo logs = (SmcUmcExtSupplierSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtSupplierSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.SUCCESS);
                logs.setDealResultDesc("\u5904\u7406\u6210\u529f");
                insertSupplierLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(insertSupplierLogsList)) {
            List ids = insertSupplierLogsList.stream().map(SmcUmcExtSupplierSyncLogsPo::getId).collect(Collectors.toList());
            this.umcExtSupplierSyncLogsRepository.saveBatch(insertSupplierLogsList);
            this.umcExtSupplierSyncTempRepository.removeBatchByIds(ids);
        }
    }

    private void dealDelete(List<Long> deleteOrgIdList) {
        if (ObjectUtil.isNotEmpty(deleteOrgIdList)) {
            LambdaUpdateWrapper delOrgWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delOrgWrapper.in(SmcUmcOrgInfoPo::getOrgId, deleteOrgIdList)).set(SmcUmcOrgInfoPo::getDelFlag, (Object)"1");
            this.umcOrgInfoRepository.update((Wrapper)delOrgWrapper);
            LambdaUpdateWrapper delEnterpriseWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delEnterpriseWrapper.in(SmcUmcEnterpriseInfoPo::getOrgId, deleteOrgIdList)).set(SmcUmcEnterpriseInfoPo::getDelFlag, (Object)"1");
            this.umcEnterpriseInfoRepository.update((Wrapper)delEnterpriseWrapper);
            LambdaUpdateWrapper delOrgTagWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delOrgTagWrapper.in(SmcUmcOrgTagRelPo::getOrgId, deleteOrgIdList)).set(SmcUmcOrgTagRelPo::getDelFlag, (Object)"1");
            this.umcOrgTagRelRepository.update((Wrapper)delOrgTagWrapper);
            LambdaUpdateWrapper delEnterpriseContactWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)delEnterpriseContactWrapper.in(SmcUmcEnterpriseContactPo::getOrgId, deleteOrgIdList)).eq(SmcUmcEnterpriseContactPo::getTagId, (Object)"1")).set(SmcUmcEnterpriseContactPo::getDelFlag, (Object)"1");
            this.umcEnterpriseContactRepository.update((Wrapper)delEnterpriseContactWrapper);
        }
    }

    private void dealUpdate(List<SmcUmcOrgInfoPo> updateOrgInfoList, List<SmcUmcEnterpriseInfoPo> updateEnterpriseInfoList, List<SmcUmcEnterpriseContactPo> updateEnterpriseContactList) {
        if (ObjectUtil.isNotEmpty(updateOrgInfoList)) {
            updateOrgInfoList.forEach(updateOrgInfo -> this.umcOrgInfoRepository.updateById(updateOrgInfo));
        }
        if (ObjectUtil.isNotEmpty(updateEnterpriseInfoList)) {
            updateEnterpriseInfoList.forEach(updateEnterpriseInfo -> this.umcEnterpriseInfoRepository.updateById(updateEnterpriseInfo));
        }
        if (ObjectUtil.isNotEmpty(updateEnterpriseContactList)) {
            updateEnterpriseContactList.forEach(updateEnterpriseContact -> this.umcEnterpriseContactRepository.updateById(updateEnterpriseContact));
        }
    }

    private void dealInsert(List<SmcUmcOrgInfoPo> insertOrgInfoList, List<SmcUmcOrgTagRelPo> insertOrgTagList, List<SmcUmcEnterpriseInfoPo> insertEnterpriseInfoList, List<SmcUmcEnterpriseContactPo> insertEnterpriseContactList) {
        if (ObjectUtil.isNotEmpty(insertOrgInfoList)) {
            this.umcOrgInfoRepository.saveBatch(insertOrgInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertOrgTagList)) {
            this.umcOrgTagRelRepository.saveBatch(insertOrgTagList);
        }
        if (ObjectUtil.isNotEmpty(insertEnterpriseInfoList)) {
            this.umcEnterpriseInfoRepository.saveBatch(insertEnterpriseInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertEnterpriseContactList)) {
            this.umcEnterpriseContactRepository.saveBatch(insertEnterpriseContactList);
        }
    }

    private boolean dealDelData(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, Map<String, SmcUmcOrgInfoDO> orgInfoMap, List<Long> deleteOrgIdList, List<Long> successIdList, Map<Long, String> failResultMap) {
        if ("1".equals(dealSupplierInfoBO.getDelFlag())) {
            SmcUmcOrgInfoDO umcOrgInfoDO;
            if (orgInfoMap.containsKey(dealSupplierInfoBO.getOrgCode())) {
                umcOrgInfoDO = orgInfoMap.get(dealSupplierInfoBO.getOrgCode());
                LambdaQueryWrapper querySubWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)querySubWrapper.likeRight(SmcUmcOrgInfoPo::getOrgTreePath, (Object)umcOrgInfoDO.getOrgTreePath())).ne(SmcUmcOrgInfoPo::getOrgId, (Object)umcOrgInfoDO.getOrgId());
                List subOrgInfoList = this.umcOrgInfoRepository.list((Wrapper)querySubWrapper);
                if (ObjectUtil.isNotEmpty((Object)subOrgInfoList)) {
                    failResultMap.put(dealSupplierInfoBO.getId(), "\u5f53\u524d\u4f9b\u5e94\u5546\u5b58\u5728\u4e0b\u7ea7\u673a\u6784\uff0c\u4e0d\u80fd\u5220\u9664");
                    return true;
                }
                LambdaQueryWrapper queryUserWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryUserWrapper.likeRight(SmcUmcUserInfoPo::getOrgTreePath, (Object)umcOrgInfoDO.getOrgTreePath())).eq(SmcUmcUserInfoPo::getDelFlag, (Object)"0");
                List userInfoList = this.umcUserInfoRepository.list((Wrapper)queryUserWrapper);
                if (ObjectUtil.isNotEmpty((Object)userInfoList)) {
                    failResultMap.put(dealSupplierInfoBO.getId(), "\u5f53\u524d\u4f9b\u5e94\u5546\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664");
                    return true;
                }
            } else {
                failResultMap.put(dealSupplierInfoBO.getId(), "\u5f53\u524d\u4f9b\u5e94\u5546\u5728\u6b63\u5f0f\u8868\u4e0d\u5b58\u5728");
                return true;
            }
            deleteOrgIdList.add(umcOrgInfoDO.getOrgId());
            successIdList.add(dealSupplierInfoBO.getId());
            return true;
        }
        return false;
    }

    private boolean dealMaxCount(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, Map<Long, String> failResultMap) {
        if (dealSupplierInfoBO.getCurrentDealCount() > this.dealOrgMaxCount) {
            failResultMap.put(dealSupplierInfoBO.getId(), "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c\u6570\u636e\u65e0\u6cd5\u5904\u7406");
            return true;
        }
        return false;
    }

    private void setUpdateEnterpriseContact(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, SmcUmcOrgInfoDO oldOrgInfoPo, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseContactPo> updateEnterpriseContactList, List<SmcUmcEnterpriseContactPo> insertEnterpriseContactList) {
        if (dealSupplierInfoBO.isCreateContactInfo()) {
            List collect = oldOrgInfoPo.getEnterpriseContactList().stream().filter(contact -> "2".equals(contact.getTagId())).collect(Collectors.toList());
            SmcUmcEnterpriseContactPo umcEnterpriseContactPo = new SmcUmcEnterpriseContactPo();
            umcEnterpriseContactPo.setOrgId(orgInfoPo.getOrgId());
            umcEnterpriseContactPo.setTagId("2");
            umcEnterpriseContactPo.setTenantId(dealSupplierInfoBO.getTenantId());
            umcEnterpriseContactPo.setContactName(dealSupplierInfoBO.getContactName());
            umcEnterpriseContactPo.setPhoneNumber(dealSupplierInfoBO.getPhoneNumber());
            umcEnterpriseContactPo.setTel(dealSupplierInfoBO.getTel());
            umcEnterpriseContactPo.setEmail(dealSupplierInfoBO.getEmail());
            if (ObjectUtil.isNotEmpty(collect)) {
                umcEnterpriseContactPo.setContactId(((SmcUmcEnterpriseContactDO)collect.get(0)).getContactId());
                umcEnterpriseContactPo.setUpdateOperId(orgInfoPo.getUpdateOperId());
                umcEnterpriseContactPo.setUpdateOperName(orgInfoPo.getUpdateOperName());
                umcEnterpriseContactPo.setUpdateTime(orgInfoPo.getUpdateTime());
                updateEnterpriseContactList.add(umcEnterpriseContactPo);
            } else {
                umcEnterpriseContactPo.setContactId(Long.valueOf(SmcIdUtil.nextId()));
                umcEnterpriseContactPo.setCreateOperId(orgInfoPo.getCreateOperId());
                umcEnterpriseContactPo.setCreateOperName(orgInfoPo.getCreateOperName());
                umcEnterpriseContactPo.setCreateTime(orgInfoPo.getCreateTime());
                umcEnterpriseContactPo.setDelFlag("0");
                insertEnterpriseContactList.add(umcEnterpriseContactPo);
            }
        }
    }

    private void setUpdateEnterpriseInfo(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseInfoPo> updateEnterpriseInfoList) {
        SmcUmcEnterpriseInfoPo enterpriseInfoPo = (SmcUmcEnterpriseInfoPo)SmcRu.js((Object)dealSupplierInfoBO, SmcUmcEnterpriseInfoPo.class);
        enterpriseInfoPo.setIsMerchant(null);
        enterpriseInfoPo.setIsShopOrg(null);
        enterpriseInfoPo.setOrgId(orgInfoPo.getOrgId());
        enterpriseInfoPo.setUpdateOperId(orgInfoPo.getUpdateOperId());
        enterpriseInfoPo.setUpdateOperName(orgInfoPo.getUpdateOperName());
        enterpriseInfoPo.setUpdateTime(orgInfoPo.getUpdateTime());
        updateEnterpriseInfoList.add(enterpriseInfoPo);
    }

    private SmcUmcOrgInfoPo updateOrgInfo(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, SmcUmcOrgInfoDO oldOrgInfoPo, List<SmcUmcOrgInfoPo> updateOrgInfoList) {
        SmcUmcOrgInfoPo orgInfoPo = (SmcUmcOrgInfoPo)SmcRu.js((Object)dealSupplierInfoBO, SmcUmcOrgInfoPo.class);
        orgInfoPo.setOrgId(oldOrgInfoPo.getOrgId());
        if (ObjectUtil.isNotEmpty((Object)dealSupplierInfoBO.getUpdateOperId())) {
            orgInfoPo.setUpdateOperId(dealSupplierInfoBO.getUpdateOperId());
        } else {
            orgInfoPo.setUpdateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isNotEmpty((Object)dealSupplierInfoBO.getUpdateOperName())) {
            orgInfoPo.setUpdateOperName(dealSupplierInfoBO.getUpdateOperName());
        } else {
            orgInfoPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isNotEmpty((Object)dealSupplierInfoBO.getUpdateTime())) {
            orgInfoPo.setUpdateTime(dealSupplierInfoBO.getUpdateTime());
        } else {
            orgInfoPo.setUpdateTime(new Date());
        }
        updateOrgInfoList.add(orgInfoPo);
        return orgInfoPo;
    }

    private void setInsertEnterpriseContact(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseContactPo> insertEnterpriseContactList) {
        if (dealSupplierInfoBO.isCreateContactInfo()) {
            SmcUmcEnterpriseContactPo umcEnterpriseContactPo = new SmcUmcEnterpriseContactPo();
            umcEnterpriseContactPo.setContactId(Long.valueOf(SmcIdUtil.nextId()));
            umcEnterpriseContactPo.setOrgId(orgInfoPo.getOrgId());
            umcEnterpriseContactPo.setTagId("2");
            umcEnterpriseContactPo.setTenantId(dealSupplierInfoBO.getTenantId());
            umcEnterpriseContactPo.setContactName(dealSupplierInfoBO.getContactName());
            umcEnterpriseContactPo.setPhoneNumber(dealSupplierInfoBO.getPhoneNumber());
            umcEnterpriseContactPo.setTel(dealSupplierInfoBO.getTel());
            umcEnterpriseContactPo.setEmail(dealSupplierInfoBO.getEmail());
            umcEnterpriseContactPo.setCreateOperId(orgInfoPo.getCreateOperId());
            umcEnterpriseContactPo.setCreateOperName(orgInfoPo.getCreateOperName());
            umcEnterpriseContactPo.setCreateTime(orgInfoPo.getCreateTime());
            umcEnterpriseContactPo.setDelFlag("0");
            insertEnterpriseContactList.add(umcEnterpriseContactPo);
        }
    }

    private void setInsertOrgTagRel(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcOrgTagRelPo> insertOrgTagList, List<String> tagIdList) {
        if (ObjectUtil.isNotEmpty(tagIdList) && tagIdList.contains("2")) {
            return;
        }
        SmcUmcOrgTagRelPo orgTagRelPo = new SmcUmcOrgTagRelPo();
        orgTagRelPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
        orgTagRelPo.setOrgId(orgInfoPo.getOrgId());
        orgTagRelPo.setTenantId(dealSupplierInfoBO.getTenantId());
        orgTagRelPo.setTagId("2");
        orgTagRelPo.setTagStatus("1");
        orgTagRelPo.setDelFlag("0");
        orgTagRelPo.setCreateOperId(orgInfoPo.getCreateOperId());
        orgTagRelPo.setCreateOperName(orgInfoPo.getCreateOperName());
        orgTagRelPo.setCreateTime(orgInfoPo.getCreateTime());
        insertOrgTagList.add(orgTagRelPo);
    }

    private SmcUmcOrgInfoPo setInsertSupplierInfo(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, List<SmcUmcOrgInfoPo> insertOrgInfoList) {
        SmcUmcOrgInfoPo orgInfoPo = (SmcUmcOrgInfoPo)SmcRu.js((Object)dealSupplierInfoBO, SmcUmcOrgInfoPo.class);
        orgInfoPo.setOrgId(Long.valueOf(SmcIdUtil.nextId()));
        orgInfoPo.setOrgType(SmcUmcConstants.OrgType.COMPANY);
        if ("1".equals(dealSupplierInfoBO.getOrgClass())) {
            orgInfoPo.setParentId(this.outPersonageUserParentId);
        } else if ("2".equals(dealSupplierInfoBO.getOrgClass())) {
            orgInfoPo.setParentId(this.outEnterpriseUserParentId);
        }
        if ("1".equals(dealSupplierInfoBO.getOrgClass())) {
            orgInfoPo.setOrgTreePath(this.outPersonageUserPath + orgInfoPo.getOrgId() + "-");
        } else if ("2".equals(dealSupplierInfoBO.getOrgClass())) {
            orgInfoPo.setOrgTreePath(this.outEnterpriseUserPath + orgInfoPo.getOrgId() + "-");
        }
        orgInfoPo.setDeep(Integer.valueOf(orgInfoPo.getOrgTreePath().split("-").length));
        orgInfoPo.setCompanyId(orgInfoPo.getOrgId());
        if (ObjectUtil.isNotEmpty((Object)dealSupplierInfoBO.getCreateOperId())) {
            orgInfoPo.setCreateOperId(dealSupplierInfoBO.getCreateOperId());
        } else {
            orgInfoPo.setCreateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isNotEmpty((Object)dealSupplierInfoBO.getCreateOperName())) {
            orgInfoPo.setCreateOperName(dealSupplierInfoBO.getCreateOperName());
        } else {
            orgInfoPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isNotEmpty((Object)dealSupplierInfoBO.getCreateTime())) {
            orgInfoPo.setCreateTime(dealSupplierInfoBO.getCreateTime());
        } else {
            orgInfoPo.setCreateTime(new Date());
        }
        orgInfoPo.setDelFlag("0");
        insertOrgInfoList.add(orgInfoPo);
        return orgInfoPo;
    }

    private void setInsertEnterpriseInfo(SmcUmcDealSupplierInfoBO dealSupplierInfoBO, SmcUmcOrgInfoPo orgInfoPo, List<SmcUmcEnterpriseInfoPo> insertEnterpriseInfoList) {
        SmcUmcEnterpriseInfoPo enterpriseInfoPo = (SmcUmcEnterpriseInfoPo)SmcRu.js((Object)dealSupplierInfoBO, SmcUmcEnterpriseInfoPo.class);
        enterpriseInfoPo.setOrgId(orgInfoPo.getOrgId());
        enterpriseInfoPo.setIsMerchant("1");
        enterpriseInfoPo.setIsShopOrg("1");
        enterpriseInfoPo.setCreateOperId(orgInfoPo.getCreateOperId());
        enterpriseInfoPo.setCreateOperName(orgInfoPo.getCreateOperName());
        enterpriseInfoPo.setCreateTime(orgInfoPo.getCreateTime());
        enterpriseInfoPo.setDelFlag("0");
        insertEnterpriseInfoList.add(enterpriseInfoPo);
    }
}

