/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecAnswerLikeBusiService;
import com.tydic.uec.busi.bo.UecAnswerLikeBusiReqBO;
import com.tydic.uec.busi.bo.UecAnswerLikeBusiRspBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.AnswerThumbUpRecMapper;
import com.tydic.uec.dao.po.AnswerThumbUpRecPO;
import com.tydic.uec.utils.UecGenerateIdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecAnswerLikeBusiServiceImpl
implements UecAnswerLikeBusiService {
    private final AnswerThumbUpRecMapper answerThumbUpRecMapper;
    private final UecGenerateIdUtil generateIdUtil;

    @Autowired
    public UecAnswerLikeBusiServiceImpl(AnswerThumbUpRecMapper answerThumbUpRecMapper, UecGenerateIdUtil generateIdUtil) {
        this.answerThumbUpRecMapper = answerThumbUpRecMapper;
        this.generateIdUtil = generateIdUtil;
    }

    @Override
    public UecAnswerLikeBusiRspBO dealAnswerLike(UecAnswerLikeBusiReqBO reqBO) {
        UecAnswerLikeBusiRspBO rspBO = new UecAnswerLikeBusiRspBO();
        if (UecCommonConstant.YES_FLAG.equals(reqBO.getCancelFlag())) {
            AnswerThumbUpRecPO updateThumb = new AnswerThumbUpRecPO();
            updateThumb.setMemId(reqBO.getThumbUpRec().getMemId());
            updateThumb.setAnswerId(reqBO.getThumbUpRec().getAnswerId());
            updateThumb.setQuestionId(reqBO.getThumbUpRec().getQuestionId());
            updateThumb.setThumbUpType(reqBO.getThumbUpRec().getThumbUpType());
            updateThumb.setIpAddr(reqBO.getThumbUpRec().getIpAddr());
            updateThumb.setState(UecCommonConstant.StateEnum.NO.value);
            int count = this.answerThumbUpRecMapper.updateByPO(updateThumb);
            if (count == 0) {
                rspBO.setRespCode("2222");
                rspBO.setRespDesc("\u8be5\u4f1a\u5458\u70b9\u8d5e\u8bb0\u5f55\u4e0d\u5b58\u5728");
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u56de\u7b54\u53d6\u6d88\u70b9\u8d5e\u6210\u529f");
            return rspBO;
        }
        AnswerThumbUpRecPO paramPO = new AnswerThumbUpRecPO();
        paramPO.setMemId(reqBO.getThumbUpRec().getMemId());
        paramPO.setThumbUpType(reqBO.getThumbUpRec().getThumbUpType());
        paramPO.setAnswerId(reqBO.getThumbUpRec().getAnswerId());
        paramPO.setQuestionId(reqBO.getThumbUpRec().getQuestionId());
        paramPO.setState(UecCommonConstant.StateEnum.YES.value);
        AnswerThumbUpRecPO existThumb = this.answerThumbUpRecMapper.getModelBy(paramPO);
        if (existThumb != null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u5df2\u70b9\u8d5e\u8be5\u56de\u7b54\uff0c\u4e0d\u80fd\u91cd\u590d\u70b9\u8d5e");
            return rspBO;
        }
        AnswerThumbUpRecPO insertPO = new AnswerThumbUpRecPO();
        BeanUtils.copyProperties((Object)reqBO.getThumbUpRec(), (Object)insertPO);
        if (insertPO.getIsAnonymous() == null) {
            insertPO.setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        insertPO.setState(UecCommonConstant.StateEnum.YES.value);
        insertPO.setId(this.generateIdUtil.nextId());
        this.answerThumbUpRecMapper.insert(insertPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u56de\u7b54\u70b9\u8d5e\u6210\u529f");
        return rspBO;
    }
}

