/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.uec.atom.UecAnswerListQryAtomService;
import com.tydic.uec.atom.bo.UecAnswerListQryAtomReqBO;
import com.tydic.uec.atom.bo.UecAnswerListQryAtomRspBO;
import com.tydic.uec.busi.UecQuestionListQryBusiService;
import com.tydic.uec.busi.bo.UecQuestionListQryBusiReqBO;
import com.tydic.uec.busi.bo.UecQuestionListQryBusiRspBO;
import com.tydic.uec.common.bo.answer.CommodityQuestionBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.CommodityQuestionMapper;
import com.tydic.uec.dao.po.CommodityQuestionPO;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecQuestionListQryBusiServiceImpl
implements UecQuestionListQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UecQuestionListQryBusiServiceImpl.class);
    private static final String ORDER_COLUMN = "PUT_TIME DESC";
    private final CommodityQuestionMapper commodityQuestionMapper;
    private final UecAnswerListQryAtomService uecAnswerListQryAtomService;
    private final RedisUtil redisUtil;

    @Autowired
    public UecQuestionListQryBusiServiceImpl(CommodityQuestionMapper commodityQuestionMapper, UecAnswerListQryAtomService uecAnswerListQryAtomService, RedisUtil redisUtil) {
        this.commodityQuestionMapper = commodityQuestionMapper;
        this.uecAnswerListQryAtomService = uecAnswerListQryAtomService;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecQuestionListQryBusiRspBO qryQuestionList(UecQuestionListQryBusiReqBO reqBO) {
        UecQuestionListQryBusiRspBO rspBO;
        String redisQryKey = this.getListRedisKey(reqBO);
        Long redisListSize = null;
        boolean saveRedis = false;
        if (redisQryKey != null && (redisListSize = this.redisUtil.zGetSize(redisQryKey)) != null) {
            saveRedis = true;
            rspBO = this.returnListFromRedis(redisQryKey, redisListSize.intValue(), reqBO.getPageNo(), reqBO.getPageSize());
            if (rspBO != null) {
                return rspBO;
            }
        }
        rspBO = new UecQuestionListQryBusiRspBO();
        CommodityQuestionPO paramPO = new CommodityQuestionPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)paramPO);
        paramPO.setOrderBy(ORDER_COLUMN);
        Page questionPage = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.commodityQuestionMapper.getList(paramPO));
        ArrayList<CommodityQuestionBO> questionList = new ArrayList<CommodityQuestionBO>(reqBO.getPageSize());
        if (!CollectionUtils.isEmpty((Collection)questionPage.getResult())) {
            if (saveRedis && (long)((reqBO.getPageNo() - 1) * reqBO.getPageSize()) > redisListSize) {
                saveRedis = false;
            }
            HashSet saveIdTuples = null;
            HashMap saveQuestionMap = null;
            if (saveRedis) {
                saveIdTuples = Sets.newHashSetWithExpectedSize((int)reqBO.getPageSize());
                saveQuestionMap = Maps.newHashMapWithExpectedSize((int)(reqBO.getPageSize() + 1));
            }
            this.handleListProcess(questionList, questionPage.getResult(), saveIdTuples, saveQuestionMap);
            if (saveRedis) {
                this.saveListIntoRedis(redisQryKey, redisListSize.intValue(), questionPage.getResult().size(), (int)questionPage.getTotal(), saveIdTuples, saveQuestionMap);
            }
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotalRecords((int)questionPage.getTotal());
        rspBO.setTotalPages(questionPage.getPages());
        rspBO.setRows(questionList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u95ee\u9898\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private String getListRedisKey(UecQuestionListQryBusiReqBO reqBO) {
        boolean checkParam;
        String redisKey = null;
        boolean bl = checkParam = UecCommonConstant.StateEnum.YES.value.equals(reqBO.getState()) && reqBO.getIsAnonymous() == null && (StringUtils.isNotBlank((CharSequence)reqBO.getObjId()) || StringUtils.isNotBlank((CharSequence)reqBO.getMemId()));
        if (checkParam) {
            if (StringUtils.isBlank((CharSequence)reqBO.getObjId()) && StringUtils.isNotBlank((CharSequence)reqBO.getMemId())) {
                redisKey = "uec_question_list_" + reqBO.getSysCode() + "_memId#" + reqBO.getMemId();
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getObjId()) && reqBO.getObjType() != null && StringUtils.isBlank((CharSequence)reqBO.getMemId())) {
                redisKey = "uec_question_list_" + reqBO.getSysCode() + "_objType#" + reqBO.getObjType() + "_objId#" + reqBO.getObjId();
            }
        }
        return redisKey;
    }

    private UecQuestionListQryBusiRspBO returnListFromRedis(String redisKey, int redisListSize, int pageNo, int pageSize) {
        if ((pageNo - 1) * pageSize < redisListSize) {
            boolean notInPage;
            Object hashCount = this.redisUtil.hashGet("uec_question_list_", redisKey + "_totalRecords");
            if (hashCount == null) {
                return null;
            }
            int totalCount = (Integer)hashCount;
            int totalPage = (totalCount - 1) / pageSize + 1;
            boolean bl = notInPage = pageNo < totalPage && pageNo * pageSize > redisListSize || pageNo == totalPage && totalCount - (totalPage - 1) * pageSize != redisListSize - (pageNo - 1) * pageSize;
            if (notInPage) {
                return null;
            }
            Set<Object> questionIds = this.redisUtil.zGet(redisKey, (pageNo - 1) * pageSize, pageNo * pageSize - 1, true);
            if (!CollectionUtils.isEmpty(questionIds)) {
                List<Object> hashObjects = this.redisUtil.hashMultiGet("uec_question_list_", questionIds);
                if (CollectionUtils.isEmpty(hashObjects) || hashObjects.size() != questionIds.size()) {
                    this.redisUtil.zRemove(redisKey, questionIds.toArray());
                    return null;
                }
                ArrayList<CommodityQuestionBO> questionList = new ArrayList<CommodityQuestionBO>(hashObjects.size());
                try {
                    for (Object e : hashObjects) {
                        if (e == null) continue;
                        questionList.add((CommodityQuestionBO)e);
                    }
                }
                catch (ClassCastException e) {
                    log.error("\u95ee\u9898\u5217\u8868\u67e5\u8be2\u670d\u52a1\u7f13\u5b58\u5bf9\u8c61\u8f6c\u95ee\u9898\u5bf9\u8c61\u5f02\u5e38");
                    this.redisUtil.hashDel("uec_question_list_", questionIds.toArray());
                }
                if (questionList.size() != questionIds.size()) {
                    this.redisUtil.zRemove(redisKey, questionIds.toArray());
                    return null;
                }
                questionList.forEach(question -> this.qryAnswerList(Long.parseLong(question.getQuestionId()), (CommodityQuestionBO)question));
                UecQuestionListQryBusiRspBO rspBO = new UecQuestionListQryBusiRspBO();
                rspBO.setPageNo(pageNo);
                rspBO.setTotalRecords(totalCount);
                rspBO.setTotalPages(totalPage);
                rspBO.setRows(questionList);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u95ee\u9898\u5217\u8868\u6210\u529f");
                return rspBO;
            }
        }
        return null;
    }

    private void qryAnswerList(Long questionId, CommodityQuestionBO questionBO) {
        UecAnswerListQryAtomReqBO atomReqBO = new UecAnswerListQryAtomReqBO();
        atomReqBO.setQuestionId(questionId);
        atomReqBO.setState(UecCommonConstant.StateEnum.YES.value);
        atomReqBO.setPageNo(UecCommonConstant.DEFAULT_PAGE_NO);
        atomReqBO.setPageSize(UecCommonConstant.DEFAULT_PAGE_SIZE);
        UecAnswerListQryAtomRspBO atomRspBO = this.uecAnswerListQryAtomService.qryAnswerList(atomReqBO);
        questionBO.setAnswerRecords(atomRspBO.getTotalRecords());
        questionBO.setAnswerPages(atomRspBO.getTotalPages());
        questionBO.setAnswerList(atomRspBO.getRows());
    }

    private void handleListProcess(List<CommodityQuestionBO> questionList, List<CommodityQuestionPO> questionPOList, Set<ZSetOperations.TypedTuple<Object>> saveIdTuples, Map<String, Object> saveQuestionMap) {
        boolean saveRedis = saveIdTuples != null;
        for (CommodityQuestionPO questionPO : questionPOList) {
            CommodityQuestionBO questionBO = new CommodityQuestionBO();
            BeanUtils.copyProperties((Object)questionPO, (Object)questionBO);
            if (StringUtils.isNotBlank((CharSequence)questionPO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(questionPO.getIsAnonymous())) {
                questionBO.setMemName(questionPO.getMemName().substring(0, 1) + "***" + questionPO.getMemName().substring(questionPO.getMemName().length() - 1));
            }
            questionBO.setQuestionId(questionPO.getQuestionId().toString());
            this.qryAnswerList(questionPO.getQuestionId(), questionBO);
            questionList.add(questionBO);
            if (!saveRedis) continue;
            saveIdTuples.add((ZSetOperations.TypedTuple<Object>)new DefaultTypedTuple((Object)questionBO.getQuestionId(), Double.valueOf(questionBO.getPutTime().getTime())));
            saveQuestionMap.put(questionBO.getQuestionId(), questionBO);
        }
    }

    private void saveListIntoRedis(String redisKey, int redisListSize, int saveSize, int totalCount, Set<ZSetOperations.TypedTuple<Object>> saveIdTuples, Map<String, Object> saveQuestionMap) {
        if (redisListSize + saveSize > 30) {
            this.redisUtil.zRemoveRange(redisKey, 0L, redisListSize + saveSize - 30 - 1);
        }
        this.redisUtil.zAddTuple(redisKey, saveIdTuples, UecRedisConstant.getExpireMinutes(30, 10));
        saveQuestionMap.put(redisKey + "_totalRecords", totalCount);
        this.redisUtil.hashMapSet("uec_question_list_", saveQuestionMap, UecRedisConstant.getExpireMinutes(30, 30));
    }
}

