/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.organization.AuthGetOrgRoleListService;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgRoleListReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgRoleListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.organization.AuthGetOrgRoleListService"})
public class AuthGetOrgRoleListServiceImpl
implements AuthGetOrgRoleListService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"getOrgRoleList"})
    public AuthGetOrgRoleListRspBo getOrgRoleList(@RequestBody AuthGetOrgRoleListReqBo reqBo) {
        AuthGetOrgRoleListRspBo rspBo = AuthRu.success(AuthGetOrgRoleListRspBo.class);
        this.validateArg(reqBo);
        UmcEnterpriseInfoQryBo qryBo = new UmcEnterpriseInfoQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        UmcEnterpriseInfoDo rspDo = this.iUmcEnterpriseInfoModel.getOrgInfoDetails(qryBo);
        if (rspDo == null || rspDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        UmcEnterpriseInfoQryBo roleQryBo = new UmcEnterpriseInfoQryBo();
        roleQryBo.setOrgId(rspDo.getOrgId());
        UmcEnterpriseInfoDo roleInfoDo = this.iUmcEnterpriseInfoModel.getRoleInfoListByOrg(roleQryBo);
        List<AuthRoleInfoBo> roleBoList = AuthRu.jsl(roleInfoDo.getOrgRoleList(), AuthRoleInfoBo.class);
        rspBo.setRoleInfoBoList(roleBoList);
        return rspBo;
    }

    private void validateArg(AuthGetOrgRoleListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetOrgInfoDetailReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

