/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.service.role.AuthDataPowerOrgTreeEchoService;
import com.tydic.dyc.authority.service.role.bo.AuthDataPowerOrgTreeEchoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDataPowerOrgTreeEchoRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthOtherOrgBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryRspBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthDataPowerOrgTreeEchoService"})
public class AuthDataPowerOrgTreeEchoServiceImpl
implements AuthDataPowerOrgTreeEchoService {
    @Autowired
    private IUmcEnterpriseInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getDataPowerOrgTreeEcho"})
    public AuthDataPowerOrgTreeEchoRspBo getDataPowerOrgTreeEcho(@RequestBody AuthDataPowerOrgTreeEchoReqBo reqBo) {
        AuthDataPowerOrgTreeEchoRspBo rspBo = AuthRu.success(AuthDataPowerOrgTreeEchoRspBo.class);
        this.validateArg(reqBo);
        ArrayList allOrgId = new ArrayList();
        ArrayList<AuthOtherOrgBo> list = new ArrayList<AuthOtherOrgBo>();
        UmcEnterpriseInfoDo orgInfoDo = new UmcEnterpriseInfoDo();
        orgInfoDo.setOrgIds(reqBo.getOrgIdList());
        UmcEnterpriseInfoQryRspBo infoModelList = this.iSysOrgInfoModel.getList(orgInfoDo);
        for (UmcEnterpriseInfoDo row : infoModelList.getRows()) {
            String[] split = row.getOrgTreePath().split("-");
            List idList = Arrays.stream(split).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            allOrgId.addAll(idList);
        }
        List<Long> collect = allOrgId.stream().distinct().collect(Collectors.toList());
        orgInfoDo.setOrgIds(collect);
        UmcEnterpriseInfoQryRspBo modelList = this.iSysOrgInfoModel.getList(orgInfoDo);
        for (UmcEnterpriseInfoDo row : modelList.getRows()) {
            AuthOtherOrgBo authOtherOrgBo = new AuthOtherOrgBo();
            authOtherOrgBo.setOrgId(row.getOrgId());
            authOtherOrgBo.setOrgName(row.getOrgName());
            authOtherOrgBo.setHasSel(true);
            authOtherOrgBo.setParentId(row.getParentId());
            list.add(authOtherOrgBo);
        }
        rspBo.setRows(list);
        return rspBo;
    }

    private void validateArg(AuthDataPowerOrgTreeEchoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDataPowerOrgTreeEchoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdList() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

