/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.menu.sub.SysRoleMenuBtnDo;
import com.tydic.dyc.authority.service.role.AuthRoleMenuPowerQryListService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuBtnBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuPowerQryListReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuPowerQryListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.authority.service.role.AuthRoleMenuPowerQryListService"})
public class AuthRoleMenuPowerQryListServiceImpl
implements AuthRoleMenuPowerQryListService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    @PostMapping(value={"getRoleMenuPowerList"})
    public AuthRoleMenuPowerQryListRspBo getRoleMenuPowerList(@RequestBody AuthRoleMenuPowerQryListReqBo reqBo) {
        SysMenuQryBo sysMenuQryBo = new SysMenuQryBo();
        sysMenuQryBo.setMenuId(reqBo.getMenuId());
        List menuBtnList = this.iSysMenuModel.getMenuBtnList(sysMenuQryBo).getRows();
        List<AuthRoleMenuBtnBo> authRoleMenuBtnBos = AuthRu.jsl(menuBtnList, AuthRoleMenuBtnBo.class);
        sysMenuQryBo.setRoleId(reqBo.getRoleId());
        List roleMenuBtnList = this.iSysMenuModel.getRoleMenuBtnList(sysMenuQryBo).getRows();
        this.build(authRoleMenuBtnBos, roleMenuBtnList);
        AuthRoleMenuPowerQryListRspBo authRoleMenuPowerQryListRspBo = new AuthRoleMenuPowerQryListRspBo();
        authRoleMenuPowerQryListRspBo.setRows(authRoleMenuBtnBos);
        return authRoleMenuPowerQryListRspBo;
    }

    private void build(List<AuthRoleMenuBtnBo> authRoleMenuBtnBos, List<SysRoleMenuBtnDo> roleMenuBtnList) {
        Map sysRoleMenuBtnDoMap = roleMenuBtnList.stream().collect(Collectors.toMap(SysRoleMenuBtnDo::getBtnCode, Function.identity()));
        for (AuthRoleMenuBtnBo btnBo : authRoleMenuBtnBos) {
            if (!ObjectUtil.isEmpty(sysRoleMenuBtnDoMap.get(btnBo.getBtnCode()))) {
                btnBo.setHasSel(true);
                continue;
            }
            btnBo.setHasSel(false);
        }
    }
}

