/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.audit.IUmcAuditOrderModel;
import com.tydic.dyc.umc.model.audit.UmcAuditOrderDo;
import com.tydic.dyc.umc.model.audit.sub.UmcApprovalLog;
import com.tydic.dyc.umc.model.audit.sub.UmcApprovalObj;
import com.tydic.dyc.umc.service.domainservice.UmcApproveCreateService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcApproveCreateServiceReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcApproveCreateServiceRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.umc.service.domainservice.UmcApproveCreateService"})
public class UmcApproveCreateServiceImpl
implements UmcApproveCreateService {
    @Autowired
    private IUmcAuditOrderModel iUmcAuditOrderModel;

    @PostMapping(value={"createApprove"})
    public UmcApproveCreateServiceRspBo createApprove(@RequestBody UmcApproveCreateServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UmcApproveCreateServiceRspBo rspBo = UmcRu.success(UmcApproveCreateServiceRspBo.class);
        long auditId = IdUtil.nextId();
        UmcAuditOrderDo auditDo = UmcRu.js(reqBo, UmcAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getUsername());
        auditDo.setOrderId(reqBo.getOrderId());
        auditDo.setAuditOrderStatus("2");
        ArrayList<UmcApprovalObj> objList = new ArrayList<UmcApprovalObj>();
        auditDo.setApprovalObjs(objList);
        UmcApprovalObj approvalObj = new UmcApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBo.getObjId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrderId());
        approvalObj.setObjType(reqBo.getObjType());
        approvalObj.setObjBusiType(reqBo.getObjBusiType());
        UmcApprovalLog umcApprovalLog = new UmcApprovalLog();
        umcApprovalLog.setAuditOrderId(auditId);
        umcApprovalLog.setId(IdUtil.nextId());
        umcApprovalLog.setOperid(reqBo.getUserId().toString());
        umcApprovalLog.setOperName(reqBo.getUsername());
        umcApprovalLog.setOperDept(reqBo.getOrgId() + "");
        umcApprovalLog.setCreateTime(new Date());
        umcApprovalLog.setObjNum(objList.size());
        umcApprovalLog.setObjType(reqBo.getObjBusiType());
        umcApprovalLog.setAuditResult(UmcCommConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(umcApprovalLog);
        this.iUmcAuditOrderModel.saveAudit(auditDo);
        rspBo.setAuditOrderId(Long.valueOf(auditId));
        return rspBo;
    }

    private void validateArg(UmcApproveCreateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UocApproveCreateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61id\uff0c\u4f8b\u5982\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjType())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjBusiType())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u4e1a\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

