/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.shoppingcart;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.shoppingcart.IUmcShoppingCartModel;
import com.tydic.dyc.umc.model.shoppingcart.UmcShoppingCartDo;
import com.tydic.dyc.umc.model.shoppingcart.sub.UmcShoppingCartLog;
import com.tydic.dyc.umc.service.shoppingcart.UmcAddShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/3.3.0/com.tydic.dyc.umc.service.shoppingcart.UmcAddShoppingCartService"})
public class UmcAddShoppingCartServiceImpl
implements UmcAddShoppingCartService {
    @Autowired
    private IUmcShoppingCartModel iUmcShoppingCartModel;
    @Value(value="${shopping.cart.choice.default:0}")
    private Integer defaultChoiceState;

    @PostMapping(value={"addShoppingCart"})
    public UmcAddShoppingCartRspBo addShoppingCart(@RequestBody UmcAddShoppingCartReqBo reqBo) {
        this.validateAgr(reqBo);
        ArrayList<UmcAddShoppingCartBo> rspBos = new ArrayList<UmcAddShoppingCartBo>();
        for (UmcAddShoppingCartBo bo : reqBo.getUmcAddShoppingCartBos()) {
            UmcShoppingCartDo umcShoppingCartDo = UmcRu.js(bo, UmcShoppingCartDo.class);
            UmcShoppingCartLog umcShoppingCartLog = UmcRu.js(bo, UmcShoppingCartLog.class);
            umcShoppingCartDo.setDelFlag("0");
            umcShoppingCartDo.setCreateOperId(reqBo.getUserId());
            umcShoppingCartDo.setCreateOperName(reqBo.getUserName());
            umcShoppingCartDo.setCreateTime(new Date());
            umcShoppingCartDo.setUserId(reqBo.getUserId());
            umcShoppingCartDo.setJoinTime(new Date());
            umcShoppingCartDo.setShopCode(bo.getSupplierShopId().toString());
            umcShoppingCartDo.setIsChoice(this.defaultChoiceState);
            umcShoppingCartDo.setTenantId(reqBo.getTenantId());
            if (null != bo.getPurchaseModId()) {
                if ("1".equals(bo.getPurchaseModId().toString())) {
                    umcShoppingCartDo.setIsPlanRelevancy("0");
                } else {
                    umcShoppingCartDo.setIsPlanRelevancy("1");
                }
            }
            umcShoppingCartLog.setDelFlag("0");
            umcShoppingCartLog.setCreateOperId(reqBo.getUserId());
            umcShoppingCartLog.setCreateOperName(reqBo.getUserName());
            umcShoppingCartLog.setCreateTime(new Date());
            umcShoppingCartLog.setUserId(reqBo.getUserId());
            umcShoppingCartLog.setJoinTime(new Date());
            umcShoppingCartLog.setShopCode(bo.getSupplierShopId().toString());
            umcShoppingCartLog.setIsChoice(this.defaultChoiceState);
            umcShoppingCartLog.setOperTime(new Date());
            umcShoppingCartLog.setOperNum(bo.getProductAmount());
            umcShoppingCartLog.setLoginSource(reqBo.getLoginSource());
            umcShoppingCartLog.setOperType(11);
            umcShoppingCartDo.setShoppingCartLogs(Collections.singletonList(umcShoppingCartLog));
            UmcShoppingCartDo umcShoppingCartDo1 = this.iUmcShoppingCartModel.addShoppingCart(umcShoppingCartDo);
            rspBos.add(UmcRu.js((Object)umcShoppingCartDo1, UmcAddShoppingCartBo.class));
        }
        UmcAddShoppingCartRspBo rspBo = new UmcAddShoppingCartRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setUmcAddShoppingCartBos(rspBos);
        return rspBo;
    }

    private void validateAgr(UmcAddShoppingCartReqBo reqBo) {
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getUmcAddShoppingCartBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2UserId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcAddShoppingCartBo bo : reqBo.getUmcAddShoppingCartBos()) {
            if (bo.getSkuId() == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2SkuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getProductAmount() == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2ProductAmount\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getSupplierShopId() == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2SupplierShopId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getOrderSource() == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2OrderSource\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!UmcCommConstant.CompareType.OTHERS.equals(bo.getComparisonType()) || !StringUtils.isBlank((CharSequence)bo.getComparisonGoodsNo())) continue;
            throw new BaseBusinessException("200001", "\u6cbf\u7528\u5176\u4ed6\u6bd4\u9009\u5355\u65f6\uff0c\u6bd4\u9009\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

