/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcQryWaitDoneConfigListQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoDoneQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoItemQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoUrlQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoCount;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoCountListRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDoneList;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItem;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoItemPageRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoListDo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoUrl;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoUrlList;
import com.tydic.dyc.umc.model.todo.sub.UmcTransferRspBo;
import com.tydic.dyc.umc.model.todo.sub.UmcWaitDoneConfig;
import com.tydic.dyc.umc.model.todo.sub.UmcWaitDoneConfigListBo;
import com.tydic.dyc.umc.repository.UmcTodoRepository;
import com.tydic.dyc.umc.repository.dao.UmcTodoDoneMapper;
import com.tydic.dyc.umc.repository.dao.UmcTodoItemMapper;
import com.tydic.dyc.umc.repository.dao.UmcTodoMapper;
import com.tydic.dyc.umc.repository.dao.UmcTodoUrlMapper;
import com.tydic.dyc.umc.repository.dao.UmcWaitDoneConfigMapper;
import com.tydic.dyc.umc.repository.dao.UmcWaitDoneItemMapper;
import com.tydic.dyc.umc.repository.po.UmcTodoCountPo;
import com.tydic.dyc.umc.repository.po.UmcTodoDonePO;
import com.tydic.dyc.umc.repository.po.UmcTodoItemPo;
import com.tydic.dyc.umc.repository.po.UmcTodoPO;
import com.tydic.dyc.umc.repository.po.UmcTodoUrlPo;
import com.tydic.dyc.umc.repository.po.UmcWaitDoneConfigPo;
import com.tydic.dyc.umc.repository.po.UmcWaitDoneItemPo;
import com.tydic.dyc.umc.service.todo.bo.UmcDealTransferTodoBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQryToDoListBO;
import com.tydic.dyc.umc.service.todo.bo.UmcQryToDoListReqBO;
import com.tydic.dyc.umc.service.todo.bo.UmcQryToDoListRspBO;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoCountReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoCountRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoItemCountInfoBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoModuleCountInfoBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcTodoRepositoryImpl
implements UmcTodoRepository {
    @Autowired
    private UmcTodoMapper umcTodoMapper;
    @Autowired
    private UmcTodoDoneMapper umcTodoDoneMapper;
    @Autowired
    private UmcTodoItemMapper umcTodoItemMapper;
    @Autowired
    private UmcWaitDoneItemMapper umcWaitDoneItemMapper;
    @Autowired
    private UmcWaitDoneConfigMapper umcWaitDoneConfigMapper;
    @Autowired
    private UmcTodoUrlMapper umcTodoUrlMapper;

    public UmcQryToDoListRspBO qryToDoList(UmcQryToDoListReqBO reqBO) {
        UmcQryToDoListRspBO rspBO = new UmcQryToDoListRspBO();
        if (reqBO.getTodoType() == 0) {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            UmcTodoPO umcTodoPO = new UmcTodoPO();
            umcTodoPO.setDealUserId(reqBO.getDealUserId());
            umcTodoPO.setTodoModuleCode(reqBO.getTodoModuleCode());
            umcTodoPO.setTodoItemCode(reqBO.getTodoItemCode());
            umcTodoPO.setCreateStartTime(reqBO.getCreateStartTime());
            umcTodoPO.setCreateEndTime(reqBO.getCreateEndTime());
            umcTodoPO.setTodoTitle(reqBO.getTodoName());
            umcTodoPO.setSortOrder(reqBO.getSortOrder());
            List<UmcTodoPO> umcTodoPOS = this.umcTodoMapper.getToDoPage(umcTodoPO, (Page<UmcTodoPO>)page);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setRows(UmcRu.jsl(umcTodoPOS, UmcQryToDoListBO.class));
        } else if (reqBO.getTodoType() == 1) {
            Page page1 = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            UmcTodoDonePO umcTodoDonePO = new UmcTodoDonePO();
            umcTodoDonePO.setDealUserId(reqBO.getDealUserId());
            umcTodoDonePO.setTodoModuleCode(reqBO.getTodoModuleCode());
            umcTodoDonePO.setTodoItemCode(reqBO.getTodoItemCode());
            umcTodoDonePO.setCreateStartTime(reqBO.getCreateStartTime());
            umcTodoDonePO.setCreateEndTime(reqBO.getCreateEndTime());
            umcTodoDonePO.setTodoTitle(reqBO.getTodoName());
            umcTodoDonePO.setTodoStatus(UmcCommConstant.TODO_STATUS.DONE);
            umcTodoDonePO.setSortOrder(reqBO.getSortOrder());
            List<UmcTodoDonePO> umcTodoDonePOS = this.umcTodoDoneMapper.getTodoDonePage(umcTodoDonePO, (Page<UmcTodoDonePO>)page1);
            rspBO.setPageNo(page1.getPageNo());
            rspBO.setTotal(page1.getTotalPages());
            rspBO.setRecordsTotal(page1.getTotalCount());
            rspBO.setRows(UmcRu.jsl(umcTodoDonePOS, UmcQryToDoListBO.class));
        } else {
            throw new BaseBusinessException("200001", "\u5165\u53c2todoType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return rspBO;
    }

    public UmcQueryToDoCountRspBo queryToDoCount(UmcQueryToDoCountReqBo reqBO) {
        UmcQueryToDoCountRspBo rspBO = new UmcQueryToDoCountRspBo();
        rspBO.setPageNo(0);
        rspBO.setRecordsTotal(0);
        rspBO.setTotal(0);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        int newTodoModuleCount = 0;
        int todoModuleCount = 0;
        if (StringUtils.isBlank((CharSequence)reqBO.getTodoModuleCode())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2todoModuleCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTodoType() == 0) {
            UmcTodoPO umcTodoPO = new UmcTodoPO();
            umcTodoPO.setTodoModuleCode(reqBO.getTodoModuleCode());
            umcTodoPO.setDealUserId(Long.parseLong(reqBO.getCandidateOperId()));
            umcTodoPO.setCreateTime(DateUtils.strToDate((String)DateUtils.dateToStr((Date)new Date())));
            List<UmcTodoPO> umcTodoPOS = this.umcTodoMapper.queryToDoCount(umcTodoPO);
            List<UmcTodoPO> umcTodoPOSToday = this.umcTodoMapper.queryToDoCountToday(umcTodoPO);
            ArrayList<UmcToDoModuleCountInfoBo> umcToDoModuleCountInfoBos = new ArrayList<UmcToDoModuleCountInfoBo>();
            List umcToDoItemCountInfoBos = JSONArray.parseArray((String)JSON.toJSONString(umcTodoPOS), UmcToDoItemCountInfoBo.class);
            if (umcTodoPOS.size() < 1) {
                return rspBO;
            }
            Map<String, UmcToDoItemCountInfoBo> map = umcToDoItemCountInfoBos.stream().collect(Collectors.toMap(UmcToDoItemCountInfoBo::getTodoItemCode, a -> a));
            if (!CollectionUtils.isEmpty(umcTodoPOSToday)) {
                umcTodoPOSToday.forEach(umcTodoPO1 -> ((UmcToDoItemCountInfoBo)map.get(umcTodoPO1.getTodoItemCode())).setNewTodoItemCount(umcTodoPO1.getTodoItemCount()));
            }
            UmcToDoModuleCountInfoBo umcToDoModuleCountInfoBo = new UmcToDoModuleCountInfoBo();
            umcToDoModuleCountInfoBo.setTodoModuleCode(reqBO.getTodoModuleCode());
            umcToDoModuleCountInfoBo.setTodoItemCountInfos(umcToDoItemCountInfoBos);
            for (UmcToDoItemCountInfoBo umcToDoItemCountInfoBo : umcToDoItemCountInfoBos) {
                todoModuleCount += umcToDoItemCountInfoBo.getTodoItemCount().intValue();
                if (umcToDoItemCountInfoBo.getNewTodoItemCount() == null) continue;
                newTodoModuleCount += umcToDoItemCountInfoBo.getNewTodoItemCount().intValue();
            }
            umcToDoModuleCountInfoBo.setTodoModuleCount(Integer.valueOf(todoModuleCount));
            umcToDoModuleCountInfoBo.setNewTodoModuleCount(Integer.valueOf(newTodoModuleCount));
            umcToDoModuleCountInfoBos.add(umcToDoModuleCountInfoBo);
            rspBO.setRows(umcToDoModuleCountInfoBos);
        } else if (reqBO.getTodoType() == 1) {
            UmcTodoDonePO umcTodoDonePO = new UmcTodoDonePO();
            umcTodoDonePO.setTodoModuleCode(reqBO.getTodoModuleCode());
            ArrayList<UmcToDoModuleCountInfoBo> umcToDoModuleCountInfoBos = new ArrayList<UmcToDoModuleCountInfoBo>();
            List<UmcTodoDonePO> umcTodoDonePOS = this.umcTodoDoneMapper.queryToDoCount(umcTodoDonePO);
            List umcToDoItemCountInfoBos = JSONArray.parseArray((String)JSON.toJSONString(umcTodoDonePOS), UmcToDoItemCountInfoBo.class);
            if (umcToDoItemCountInfoBos.size() < 1) {
                return rspBO;
            }
            UmcToDoModuleCountInfoBo umcToDoModuleCountInfoBo = new UmcToDoModuleCountInfoBo();
            umcToDoModuleCountInfoBo.setTodoModuleCode(reqBO.getTodoModuleCode());
            umcToDoModuleCountInfoBo.setTodoModuleName(((UmcToDoItemCountInfoBo)umcToDoItemCountInfoBos.get(0)).getTodoModuleName());
            umcToDoModuleCountInfoBo.setTodoItemCountInfos(umcToDoItemCountInfoBos);
            for (UmcToDoItemCountInfoBo umcToDoItemCountInfoBo : umcToDoItemCountInfoBos) {
                todoModuleCount += umcToDoItemCountInfoBo.getTodoItemCount().intValue();
                newTodoModuleCount += umcToDoItemCountInfoBo.getNewTodoItemCount().intValue();
            }
            umcToDoModuleCountInfoBo.setTodoModuleCount(Integer.valueOf(todoModuleCount));
            umcToDoModuleCountInfoBo.setNewTodoModuleCount(Integer.valueOf(newTodoModuleCount));
            umcToDoModuleCountInfoBos.add(umcToDoModuleCountInfoBo);
            rspBO.setRows(umcToDoModuleCountInfoBos);
        } else {
            throw new BaseBusinessException("200001", "\u5165\u53c2todoType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return rspBO;
    }

    public UmcTodoCountListRspBo selectTodoCount(UmcTodoQryBo umcTodoQryBo) {
        List<UmcTodoCountPo> umcTodoCountPos = this.umcTodoMapper.selectTodoCount((UmcTodoPO)UmcRu.js((Object)umcTodoQryBo, UmcTodoPO.class));
        List<UmcTodoCountPo> donePos = this.umcTodoMapper.selectDoneCount((UmcTodoPO)UmcRu.js((Object)umcTodoQryBo, UmcTodoPO.class));
        if (!CollectionUtils.isEmpty(donePos)) {
            ConcurrentMap<String, Integer> doneTodayCountMap = donePos.stream().collect(Collectors.toConcurrentMap(UmcTodoCountPo::getTodoItemCode, UmcTodoCountPo::getNewCount));
            donePos.forEach(umcTodoCountPo -> {
                Integer todayDoneCount = (Integer)doneTodayCountMap.get(umcTodoCountPo.getTodoItemCode());
                if (null != todayDoneCount) {
                    umcTodoCountPo.setNewCount(umcTodoCountPo.getNewCount() + todayDoneCount);
                }
            });
        }
        List todoCounts = UmcRu.jsl(umcTodoCountPos, UmcTodoCount.class);
        UmcTodoCountListRspBo umcTodoCountListRspBo = new UmcTodoCountListRspBo();
        umcTodoCountListRspBo.setRows(todoCounts);
        return umcTodoCountListRspBo;
    }

    public UmcTodoItemPageRspBo selectTodoItemListPage(UmcTodoItemQryBo umcTodoItemQryBo) {
        UmcTodoItemPo umcTodoItemPo = (UmcTodoItemPo)UmcRu.js((Object)umcTodoItemQryBo, UmcTodoItemPo.class);
        Page page = new Page(umcTodoItemQryBo.getPageNo(), umcTodoItemQryBo.getPageSize());
        List<UmcTodoItemPo> umcTodoItemPos = this.umcTodoItemMapper.selectListPage(umcTodoItemPo, (Page<UmcTodoItemPo>)page);
        UmcTodoItemPageRspBo pageRspBo = new UmcTodoItemPageRspBo();
        pageRspBo.setPageNo(page.getPageNo());
        pageRspBo.setTotal(page.getTotalPages());
        pageRspBo.setRecordsTotal(page.getTotalCount());
        pageRspBo.setRows(UmcRu.jsl(umcTodoItemPos, UmcTodoItem.class));
        return pageRspBo;
    }

    public UmcTodoItemPageRspBo selectTodoItemList(UmcTodoItemQryBo umcTodoItemQryBo) {
        UmcTodoItemPo umcTodoItemPo = (UmcTodoItemPo)UmcRu.js((Object)umcTodoItemQryBo, UmcTodoItemPo.class);
        List<UmcTodoItemPo> umcTodoItemPos = this.umcTodoItemMapper.selectByCondition(umcTodoItemPo);
        UmcTodoItemPageRspBo umcTodoItemPageRspBo = new UmcTodoItemPageRspBo();
        umcTodoItemPageRspBo.setRows(UmcRu.jsl(umcTodoItemPos, UmcTodoItem.class));
        return umcTodoItemPageRspBo;
    }

    public UmcTodoListDo selectTodoListPage(UmcTodoQryBo umcTodoQryBo) {
        UmcTodoListDo pageRspBo = new UmcTodoListDo();
        return pageRspBo;
    }

    public UmcTodoListDo selectTodoList(UmcTodoQryBo umcTodoQryBo) {
        UmcTodoListDo umcTodoListDo = new UmcTodoListDo();
        return umcTodoListDo;
    }

    public UmcTodoDoneList selectDoneListPage(UmcTodoDoneQryBo umcTodoDoneQryBo) {
        UmcTodoDoneList pageRspBo = new UmcTodoDoneList();
        return pageRspBo;
    }

    public Integer createTodo(UmcTodoListDo umcTodoDos) {
        int insertBatch = this.umcTodoMapper.insertBatch(UmcRu.jsl((List)umcTodoDos.getUmcTodoDos(), UmcTodoPO.class));
        return insertBatch;
    }

    public List<UmcTodoDo> getTodoList(UmcTodoDo umcTodoDo) {
        UmcTodoPO qryBo = (UmcTodoPO)UmcRu.js((Object)umcTodoDo, UmcTodoPO.class);
        List<UmcTodoPO> results = this.umcTodoMapper.selectByCondition(qryBo);
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        return UmcRu.jsl(results, UmcTodoDo.class);
    }

    public Integer createDone(UmcTodoDoneList umcTodoDones) {
        int insertBatch = this.umcTodoDoneMapper.insertBatch(UmcRu.jsl((List)umcTodoDones.getUmcTodoDoneList(), UmcTodoDonePO.class));
        return insertBatch;
    }

    public UmcTodoDo deleteTodo(UmcTodoDo umcTodoDo) {
        int delete = this.umcTodoMapper.delete((UmcTodoPO)UmcRu.js((Object)umcTodoDo, UmcTodoPO.class));
        UmcTodoDo umcTodoDoCheck = new UmcTodoDo();
        umcTodoDoCheck.setCheck(Integer.valueOf(delete));
        return umcTodoDoCheck;
    }

    public UmcTodoItemPageRspBo selectWaitDoneList(UmcTodoItem js) {
        List itemCodes;
        String fieldValue;
        if (js.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2userID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<UmcTodoItem> umcWaitDoneBOS = new ArrayList<UmcTodoItem>();
        UmcWaitDoneItemPo js1 = (UmcWaitDoneItemPo)UmcRu.js((Object)js, UmcWaitDoneItemPo.class);
        js1.setDelFlag("0");
        List<UmcWaitDoneItemPo> list = this.umcWaitDoneItemMapper.getList(js1);
        if (!(CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)(fieldValue = list.get(0).getWaitDoneValue())) || CollectionUtils.isEmpty((Collection)(itemCodes = JSON.parseArray((String)fieldValue, String.class))))) {
            for (String itemCode : itemCodes) {
                UmcTodoItem umcWaitDoneBO = new UmcTodoItem();
                umcWaitDoneBO.setTodoItemCode(itemCode);
                umcWaitDoneBOS.add(umcWaitDoneBO);
            }
        }
        UmcTodoItemPageRspBo umcTodoItemPageRspBo = new UmcTodoItemPageRspBo();
        umcTodoItemPageRspBo.setRows(umcWaitDoneBOS);
        return umcTodoItemPageRspBo;
    }

    public void ealWaitDoneSet(UmcTodoItem reqItem) {
        UmcWaitDoneItemPo insertPo = new UmcWaitDoneItemPo();
        insertPo.setWaitDoneId(IdUtil.nextId());
        insertPo.setUserId(reqItem.getUserId());
        insertPo.setDelFlag("0");
        insertPo.setWaitDoneValue(reqItem.getTodoItemCode());
        int insert = this.umcWaitDoneItemMapper.insert(insertPo);
        if (insert < 1) {
            throw new BaseBusinessException("200100", "\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
    }

    public void deleteWaiteDoneItem(UmcTodoItem deleteItem) {
        UmcWaitDoneItemPo deleteWherePo = new UmcWaitDoneItemPo();
        deleteWherePo.setUserId(deleteItem.getUserId());
        UmcWaitDoneItemPo deleteSetPo = new UmcWaitDoneItemPo();
        deleteSetPo.setDelFlag("1");
        int i = this.umcWaitDoneItemMapper.updateBy(deleteSetPo, deleteWherePo);
    }

    public UmcWaitDoneConfigListBo qryWaitDoneList(UmcQryWaitDoneConfigListQryBo noNullStringAttr) {
        ArrayList configs = new ArrayList();
        Page page = new Page(noNullStringAttr.getPageNo().intValue(), noNullStringAttr.getPageSize().intValue());
        List<UmcWaitDoneConfigPo> listPage = this.umcWaitDoneConfigMapper.getListPage((UmcWaitDoneConfigPo)UmcRu.js((Object)noNullStringAttr, UmcWaitDoneConfigPo.class), (Page<UmcWaitDoneConfigPo>)page);
        UmcWaitDoneConfigListBo umcWaitDoneConfigListBo = new UmcWaitDoneConfigListBo();
        umcWaitDoneConfigListBo.setRows(UmcRu.jsl(listPage, UmcWaitDoneConfig.class));
        return umcWaitDoneConfigListBo;
    }

    public UmcTodoUrlList getTodoUrlList(UmcTodoUrlQryBo umcTodoUrlQryBo) {
        UmcTodoUrlList umcTodoUrlList = new UmcTodoUrlList();
        List<UmcTodoUrlPo> umcTodoUrlPoList = this.umcTodoUrlMapper.getList((UmcTodoUrlPo)UmcRu.js((Object)umcTodoUrlQryBo, UmcTodoUrlPo.class));
        umcTodoUrlList.setTodoUrlList(UmcRu.jsl(umcTodoUrlPoList, UmcTodoUrl.class));
        return umcTodoUrlList;
    }

    public UmcTransferRspBo updateCandidate(UmcDealTransferTodoBo umcDealTransferTodoBo) {
        UmcTransferRspBo rspBo = new UmcTransferRspBo();
        return rspBo;
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.strToDate((String)DateUtils.dateToStr((Date)new Date())));
    }
}

