/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.busicommon.order.api.DycUocOrderDeleteService;
import com.tydic.dyc.busicommon.order.bo.DycUocOrderDeleteReqBO;
import com.tydic.dyc.busicommon.order.bo.DycUocOrderDeleteRspBO;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderDeleteService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceRspBo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycUocOrderDeleteService"})
public class DycUocOrderDeleteServiceImpl
implements DycUocOrderDeleteService {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderDeleteServiceImpl.class);
    @Autowired
    private UocSaleOrderDeleteService uocSaleOrderDeleteService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;

    @Override
    @PostMapping(value={"dealOrderDelete"})
    public DycUocOrderDeleteRspBO dealOrderDelete(@RequestBody DycUocOrderDeleteReqBO reqBO) {
        this.verifyInputParam(reqBO);
        UocSaleOrderDeleteServiceReqBo uocSaleOrderDeleteServiceReqBo = new UocSaleOrderDeleteServiceReqBo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uocSaleOrderDeleteServiceReqBo);
        UocSaleOrderDeleteServiceRspBo uocSaleOrderDeleteServiceRspBo = this.uocSaleOrderDeleteService.deleteSaleOrder(uocSaleOrderDeleteServiceReqBo);
        if ("0000".equals(uocSaleOrderDeleteServiceRspBo.getRespCode())) {
            DycUocOrderDeleteRspBO rspBO = new DycUocOrderDeleteRspBO();
            BeanUtils.copyProperties((Object)uocSaleOrderDeleteServiceRspBo, (Object)((Object)rspBO));
            this.buryPoint(reqBO);
            return rspBO;
        }
        throw new ZTBusinessException(uocSaleOrderDeleteServiceRspBo.getRespDesc());
    }

    private void buryPoint(DycUocOrderDeleteReqBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrderId", (Object)contextBO.getSaleOrderId());
        jsonObject.put("orderId", (Object)contextBO.getOrderId());
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
        bo.setIdent("DELETE");
        bo.setDycBusiCode("saleOrderSync");
        bo.setDycCenterCode("UOC");
        bo.setData((Object)jsonObject);
        buildsList.add(bo);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u8ba2\u5355\u5220\u9664\uff0c\u9500\u552e\u5355\uff08\u53d8\u66f4\uff09\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }

    private void verifyInputParam(DycUocOrderDeleteReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleOrderId() == null) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

