/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.busicommon.order.api.DycUocRefuseSaleOrderService;
import com.tydic.dyc.busicommon.order.bo.DycUocRefuseSaleOrderServiceReqBO;
import com.tydic.dyc.busicommon.order.bo.DycUocRefuseSaleOrderServiceRspBO;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocCalculateSaleOrderFeeService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycUocRefuseSaleOrderService"})
public class DycUocRefuseSaleOrderServiceImpl
implements DycUocRefuseSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocRefuseSaleOrderServiceImpl.class);
    @Autowired
    private UocSaleOrderRefuseService uocSaleOrderRefuseService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Value(value="${uoc.adjustBudgetExt:true}")
    private boolean adjustBudgetExt;
    @Autowired
    private UocCalculateSaleOrderFeeService uocCalculateSaleOrderFeeService;
    @Value(value="${uoc.DycUocRefuseSaleOrderServiceImpl.sendHaveDoneItemCode:3031}")
    private String sendHaveDoneItemCode;
    @Value(value="${uoc.DycUocRefuseSaleOrderServiceImpl.sendHavaDone:true}")
    private boolean sendHavaDone;

    @Override
    @PostMapping(value={"refuseOrder"})
    public DycUocRefuseSaleOrderServiceRspBO refuseOrder(@RequestBody DycUocRefuseSaleOrderServiceReqBO refuseSaleOrderServiceReqBO) {
        UocSaleOrderRefuseReqBo uocSaleOrderRefuseReqBo = (UocSaleOrderRefuseReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)refuseSaleOrderServiceReqBO)), UocSaleOrderRefuseReqBo.class);
        uocSaleOrderRefuseReqBo.setConfirmResult(UocConstant.CONFIRM_RESULT.PUR_REFUSE);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u62d2\u6536\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocSaleOrderRefuseReqBo));
        UocSaleOrderRefuseRspBo uocSaleOrderRefuseRspBo = this.uocSaleOrderRefuseService.dealSaleOrderRefuse(uocSaleOrderRefuseReqBo);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u62d2\u6536\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocSaleOrderRefuseRspBo));
        if (!"0000".equals(uocSaleOrderRefuseRspBo.getRespCode())) {
            throw new ZTBusinessException(uocSaleOrderRefuseRspBo.getRespDesc());
        }
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(refuseSaleOrderServiceReqBO.getTaskId());
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
        this.adjustBudget(refuseSaleOrderServiceReqBO);
        this.pushTodo(refuseSaleOrderServiceReqBO);
        return (DycUocRefuseSaleOrderServiceRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)dycBusiProcessFlowFuncRspBO), DycUocRefuseSaleOrderServiceRspBO.class));
    }

    private void pushTodo(DycUocRefuseSaleOrderServiceReqBO contextBO) {
        if (this.sendHavaDone) {
            UocGetSaleOrderDetailServiceReqBo qryDetail = new UocGetSaleOrderDetailServiceReqBo();
            qryDetail.setOrderId(contextBO.getOrderId());
            qryDetail.setSaleOrderId(contextBO.getSaleOrderId());
            log.info("\u62d2\u6536\u7f6e\u4e3a\u5df2\u529e\uff0c\u67e5\u8be2\u8ba2\u5355\u7f16\u53f7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qryDetail));
            UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(qryDetail);
            log.info("\u62d2\u6536\u7f6e\u4e3a\u5df2\u529e\uff0c\u67e5\u8be2\u8ba2\u5355\u7f16\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderDetail));
        }
    }

    private void adjustBudget(DycUocRefuseSaleOrderServiceReqBO reqBO) {
        if (this.adjustBudgetExt) {
            UocGetSaleOrderDetailServiceReqBo detailServiceReqBo = (UocGetSaleOrderDetailServiceReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UocGetSaleOrderDetailServiceReqBo.class);
            UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(detailServiceReqBo);
            if (!"0000".equals(saleOrderDetail.getRespCode())) {
                throw new ZTBusinessException(saleOrderDetail.getRespDesc());
            }
            UocCalculateSaleOrderFeeServiceReqBo serviceReqBo = new UocCalculateSaleOrderFeeServiceReqBo();
            UocSaleOrderBO uocSaleOrderBO = new UocSaleOrderBO();
            uocSaleOrderBO.setOrderId(saleOrderDetail.getOrderId().toString());
            uocSaleOrderBO.setSaleOrderId(saleOrderDetail.getSaleOrderId());
            serviceReqBo.setOrderId(Long.valueOf(uocSaleOrderBO.getOrderId()));
            serviceReqBo.setSaleOrderId(uocSaleOrderBO.getSaleOrderId());
            UocCalculateSaleOrderFeeServiceRspBo serviceRspBo = this.uocCalculateSaleOrderFeeService.calculate(serviceReqBo);
            Map<Long, BigDecimal> realCountMap = serviceRspBo.getSaleItemList().stream().collect(Collectors.toMap(UocSaleOrderItemBO::getSaleOrderItemId, UocSaleOrderItemBO::getRealCount));
            for (UocGetSaleOrderDetailServiceRspItemBo each : saleOrderDetail.getSaleOrderDetailServiceRspItemBoList()) {
                each.setPurchaseCount(realCountMap.get(each.getSaleOrderItemId()));
                each.setPurchaseFee(each.getPurchasePrice().multiply(each.getPurchaseCount()));
            }
        }
    }
}

