/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.newretail.bo.ParamDto;
import com.tydic.newretail.constant.FileUploadTarget;
import com.tydic.newretail.util.DateUtils;
import com.tydic.newretail.util.FileUtils;
import com.tydic.newretail.util.fastdfs.FastDFSHelper;
import com.tydic.newretail.util.fastdfs.RequestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/rest"})
public class DcsFileUploadController {
    private static final Logger log = LoggerFactory.getLogger(DcsFileUploadController.class);
    @Value(value="#{'${upload.file.suffix.list:.pdf,.doc,.docx,.xlsx,.xls,.png,.jpg,.jpeg,.gif,.bmp}'.split(',')}")
    private List<String> suffixList;
    @Value(value="${app.dcsfile.intranet.url}")
    private String fileHeadUrl;
    @Value(value="${upload.file.target}")
    private String uploadTarget;
    @Value(value="${ftp.file.path:/tmp/}")
    private String ftpPath;
    @Value(value="${ftp.http.url}")
    private String ftpUrl;
    @Value(value="${local.file.path.enable:false}")
    private Boolean localFile;
    @Value(value="${local.file.path:/tmp/}")
    private String localPath;
    @Value(value="${ftp.http.local.url}")
    private String localUrl;
    @Resource
    private FileClient fileClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/uploadFile"})
    public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block25: {
            try {
                PrintWriter printWriter = response.getWriter();
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
                HashMap<String, Object> res = new HashMap<String, Object>();
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    String filePaths = "";
                    ParamDto dto = RequestUtil.parseParam(request);
                    Map<String, String> pMap = dto.getParamMap();
                    for (String key : pMap.keySet()) {
                        String value = pMap.get(key);
                        request.setAttribute(key, (Object)value);
                        log.debug("name=" + key + ",value=" + value);
                    }
                    List<FileItem> fList = dto.getFileList();
                    if (fList.size() == 0 || fList == null) {
                        throw new Exception("\u8bf7\u4e0a\u4f20\u6587\u4ef6!");
                    }
                    FileItem file = fList.get(0);
                    boolean check = this.checkUploadFile(file.getName(), response);
                    if (!check) break block25;
                    if (this.getFileUploadTarget() == FileUploadTarget.FTP) {
                        try {
                            this.fileClient.uploadFileByInputStream(this.ftpPath, file.getName(), file.getInputStream());
                            res.put("fileId", file.getName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        filePaths = FileUtils.concatFilePath(this.ftpUrl, file.getName());
                    } else if (this.getFileUploadTarget() == FileUploadTarget.LOCAL) {
                        log.info("------\u7f51\u5173\u542f\u7528\u672c\u5730\u4e0a\u4f20\uff0c\u4e0a\u4f20\u5730\u5740{}----\u4e0a\u4f20\u6587\u4ef6\u540d{}---------", (Object)this.ftpPath, (Object)file.getName());
                        OutputStream os = null;
                        InputStream inputStream = file.getInputStream();
                        try {
                            int len;
                            byte[] bs = new byte[1024];
                            String today = DateUtils.formatDate(new Date(), "yyyyMMdd");
                            File tempFile = new File(this.ftpPath + today + "/");
                            if (!tempFile.exists()) {
                                tempFile.mkdirs();
                            }
                            String readFname = file.getName();
                            String tmpFileName = UUID.randomUUID().toString().toLowerCase() + readFname.substring(readFname.lastIndexOf("."), readFname.length());
                            os = new FileOutputStream(tempFile.getPath() + File.separator + tmpFileName);
                            while ((len = inputStream.read(bs)) != -1) {
                                os.write(bs, 0, len);
                            }
                            filePaths = FileUtils.concatFilePath(this.ftpUrl, today + "/" + tmpFileName);
                            res.put("fileId", filePaths);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            try {
                                os.close();
                                inputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        String rstr = FastDFSHelper.upload(file);
                        if (rstr == null || "".equals(rstr)) {
                            throw new Exception("\u6587\u4ef6\u4e0a\u4f20\u5206\u5e03\u5f0f\u670d\u52a1\u5668\u5931\u8d25!");
                        }
                        filePaths = this.fileHeadUrl + rstr;
                        res.put("fileId", rstr);
                    }
                    res.put("success", true);
                    res.put("respCode", "0000");
                    res.put("respDesc", "\u4e0a\u4f20\u6210\u529f");
                    res.put("code", "0000");
                    res.put("message", "\u4e0a\u4f20\u6210\u529f");
                    res.put("fileName", file.getName());
                    res.put("filePath", filePaths);
                    printWriter.write(JSON.toJSONString(res));
                    printWriter.flush();
                    break block25;
                }
                throw new Exception("\u8be5\u63a5\u53e3\u4ec5\u652f\u6301\u6587\u4ef6\u4e0a\u4f20!");
            }
            catch (Exception e) {
                e.printStackTrace();
                PrintWriter printWriter = response.getWriter();
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("success", false);
                res.put("respCode", "9999");
                res.put("respDesc", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
                res.put("code", "9999");
                res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
                printWriter.write(JSON.toJSONString(res));
                printWriter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/uploadFiles"})
    public void uploadFiles(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            int success;
            int totals;
            ArrayList resList;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                ParamDto dto = RequestUtil.parseParam(request);
                Map<String, String> pMap = dto.getParamMap();
                for (String key : pMap.keySet()) {
                    String value = pMap.get(key);
                    request.setAttribute(key, (Object)value);
                    log.debug("name=" + key + ",value=" + value);
                }
                List<FileItem> fList = dto.getFileList();
                if (fList.size() == 0 || fList == null) {
                    throw new Exception("\u8bf7\u9009\u62e9\u9700\u8981\u4e0a\u4f20\u7684\u6587\u4ef6!");
                }
                resList = new ArrayList();
                totals = fList.size();
                success = 0;
                for (FileItem fItem : fList) {
                    HashMap<String, String> iMap = new HashMap<String, String>();
                    if (this.checkUploadFile(fItem.getName())) {
                        if (this.getFileUploadTarget() == FileUploadTarget.FTP) {
                            try {
                                this.fileClient.uploadFileByInputStream(this.ftpPath, fItem.getName(), fItem.getInputStream());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            String filePaths = FileUtils.concatFilePath(this.ftpUrl, fItem.getName());
                            iMap.put("code", "0000");
                            iMap.put("fileName", fItem.getName());
                            iMap.put("filePath", filePaths);
                            iMap.put("fileId", fItem.getName());
                            iMap.put("message", "\u4e0a\u4f20\u6210\u529f!");
                            ++success;
                        } else if (this.getFileUploadTarget() == FileUploadTarget.LOCAL) {
                            log.info("------\u7f51\u5173\u542f\u7528\u672c\u5730\u4e0a\u4f20\uff0c\u4e0a\u4f20\u5730\u5740{}----\u4e0a\u4f20\u6587\u4ef6\u540d{}---------", (Object)this.ftpPath, (Object)fItem.getName());
                            OutputStream os = null;
                            InputStream inputStream = fItem.getInputStream();
                            try {
                                int len;
                                byte[] bs = new byte[1024];
                                String today = DateUtils.formatDate(new Date(), "yyyyMMdd");
                                File tempFile = new File(this.ftpPath + today + "/");
                                if (!tempFile.exists()) {
                                    tempFile.mkdirs();
                                }
                                String readFname = fItem.getName();
                                String tmpFileName = UUID.randomUUID().toString().toLowerCase() + readFname.substring(readFname.lastIndexOf("."), readFname.length());
                                os = new FileOutputStream(tempFile.getPath() + File.separator + tmpFileName);
                                while ((len = inputStream.read(bs)) != -1) {
                                    os.write(bs, 0, len);
                                }
                                String filePaths = FileUtils.concatFilePath(this.ftpUrl, today + "/" + tmpFileName);
                                iMap.put("code", "0000");
                                iMap.put("fileName", fItem.getName());
                                iMap.put("filePath", filePaths);
                                iMap.put("fileId", filePaths);
                                iMap.put("message", "\u4e0a\u4f20\u6210\u529f!");
                                ++success;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                try {
                                    os.close();
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            String rstr = FastDFSHelper.upload(fItem);
                            if (rstr == null || "".equals(rstr)) {
                                iMap.put("code", "9999");
                                iMap.put("fileName", fItem.getName());
                                iMap.put("filePath", "");
                                iMap.put("fileId", "");
                                iMap.put("message", "\u6587\u4ef6\u4e0a\u4f20\u5206\u5e03\u5f0f\u670d\u52a1\u5668\u5931\u8d25!");
                            } else {
                                String filePaths = this.fileHeadUrl + rstr;
                                iMap.put("code", "0000");
                                iMap.put("fileName", fItem.getName());
                                iMap.put("filePath", filePaths);
                                iMap.put("fileId", rstr);
                                iMap.put("message", "\u4e0a\u4f20\u6210\u529f!");
                                ++success;
                            }
                        }
                    } else {
                        iMap.put("code", "9999");
                        iMap.put("fileName", fItem.getName());
                        iMap.put("filePath", "");
                        iMap.put("fileId", "");
                        iMap.put("message", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301");
                    }
                    resList.add(iMap);
                }
            } else {
                throw new Exception("\u8be5\u63a5\u53e3\u4ec5\u652f\u6301\u6587\u4ef6\u4e0a\u4f20!");
            }
            String rMsg = "\u5171\u4e0a\u4f20" + totals + "\u4e2a\u6587\u6863\uff0c\u6210\u529f" + success + "\u4e2a\uff0c\u5931\u8d25" + (totals - success) + "\u4e2a!";
            PrintWriter printWriter = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("code", "0000");
            res.put("message", rMsg);
            res.put("flist", resList);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            PrintWriter printWriter = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("code", "9999");
            res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downFile"})
    public String downLoadFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OutputStream outStream = null;
        InputStream inStream = null;
        try {
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            String fileId = request.getParameter("fileId");
            String fileName = request.getParameter("fileName");
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                if ("GET".equals(request.getMethod()) || "get".equals(request.getMethod())) {
                    fileName = URLDecoder.decode(fileName, "utf-8");
                }
                response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            } else {
                fileName = UUID.randomUUID() + "." + fileId.substring(fileId.lastIndexOf(".") + 1, fileId.length());
                response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            }
            if (this.getFileUploadTarget() == FileUploadTarget.FTP) {
                String filePath = this.ftpPath + fileName;
                File Ftmp = this.fileClient.downloadToFile(filePath);
                inStream = new FileInputStream(Ftmp);
            } else {
                inStream = this.getFileUploadTarget() == FileUploadTarget.LOCAL ? this.downFileWithUrl(fileId) : FastDFSHelper.download(fileId);
            }
            outStream = response.getOutputStream();
            byte[] buf = new byte[1024];
            int byteread = -1;
            while ((byteread = inStream.read(buf)) != -1) {
                outStream.write(buf, 0, byteread);
            }
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u9519\u8bef\uff0c\u6587\u4ef6\u672a\u627e\u5230!", (Throwable)e);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return null;
    }

    @RequestMapping(value={"/delFile"})
    public void delFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileId = request.getParameter("fileId");
        PrintWriter printWriter = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            if (this.getFileUploadTarget() == FileUploadTarget.FTP) {
                res.put("success", true);
                res.put("respCode", "0000");
                res.put("respDesc", "\u64cd\u4f5c\u6210\u529f");
                res.put("code", "0000");
                res.put("message", "\u64cd\u4f5c\u6210\u529f");
            } else {
                if (fileId == null || "".equals(fileId)) {
                    throw new Exception("\u6587\u4ef6ID\u6709\u95ee\u9898!");
                }
                FastDFSHelper.delete(fileId);
                res.put("success", true);
                res.put("respCode", "0000");
                res.put("respDesc", "\u64cd\u4f5c\u6210\u529f");
                res.put("code", "0000");
                res.put("message", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        catch (Exception e) {
            res.put("success", false);
            res.put("respCode", "9999");
            res.put("respDesc", "\u5220\u9664\u5931\u8d25:" + e.getMessage());
            res.put("code", "9999");
            res.put("message", "\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        printWriter.write(JSON.toJSONString(res));
        printWriter.flush();
    }

    private boolean checkUploadFile(String fileName) {
        if (fileName.lastIndexOf(".") > 0) {
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            return this.suffixList.contains(suffix);
        }
        return false;
    }

    private boolean checkUploadFile(String fileName, HttpServletResponse response) {
        String suffix = null;
        if (fileName.lastIndexOf(".") > 0 && this.suffixList.contains(suffix = fileName.substring(fileName.lastIndexOf(".")))) {
            return true;
        }
        log.error("\u4e0d\u652f\u6301\u7684\u683c\u5f0f {}\uff0c\u652f\u6301\u7684\u683c\u5f0f {}", (Object)suffix, this.suffixList);
        try {
            response.resetBuffer();
            PrintWriter printWriter = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("success", false);
            res.put("respCode", "9999");
            res.put("respDesc", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff01");
            res.put("fileName", fileName);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a", (Throwable)e);
        }
        return false;
    }

    private FileUploadTarget getFileUploadTarget() {
        log.info("uploadTarget={}", (Object)this.uploadTarget);
        if (StringUtils.isNotBlank((CharSequence)this.uploadTarget)) {
            if (FileUploadTarget.OSS.toString().equals(this.uploadTarget)) {
                return FileUploadTarget.OSS;
            }
            if (FileUploadTarget.LOCAL.toString().equals(this.uploadTarget)) {
                return FileUploadTarget.LOCAL;
            }
            if (FileUploadTarget.FTP.toString().equals(this.uploadTarget)) {
                return FileUploadTarget.FTP;
            }
        }
        if (this.localFile.booleanValue()) {
            return FileUploadTarget.LOCAL;
        }
        return FileUploadTarget.OSS;
    }

    private InputStream downFileWithUrl(String fileId) {
        InputStream inputStream = null;
        log.info("\u4e0b\u8f7durl\uff1a{}", (Object)fileId);
        try {
            URL url = new URL(fileId);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return inputStream;
    }
}

