/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.newretail.bo.FileBO;
import com.tydic.newretail.constant.FileUploadTarget;
import com.tydic.newretail.util.FileUtils;
import com.tydic.newretail.util.PropertiesUtils;
import com.tydic.newretail.util.oss.OssFileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/rest"})
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    @Value(value="#{'${upload.file.suffix.list:.pdf,.doc,.docx,.xlsx,.xls,.png,.jpg,.jpeg,.gif,.bmp}'.split(',')}")
    private List<String> suffixList;
    @Value(value="${local.file.path.enable:false}")
    private Boolean localFile;
    @Value(value="${local.file.path:/tmp/}")
    private String localPath;
    @Value(value="${upload.file.target}")
    private String uploadTarget;
    @Value(value="${ftp.file.path:/tmp/}")
    private String ftpPath;
    @Value(value="${ftp.http.url}")
    private String ftpUrl;
    @Resource
    private FileClient fileClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"upload"})
    public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block61: {
            String path;
            File dir;
            String uploadFilePath = request.getParameter("uploadFilePath");
            if (StringUtils.isBlank((CharSequence)uploadFilePath)) {
                uploadFilePath = PropertiesUtils.getProperty("OSS_DEFAULT_FILEPATH");
            }
            if (log.isDebugEnabled()) {
                log.info("uploadFilePath=" + uploadFilePath);
            }
            if (!(dir = new File(path = System.getProperty("java.io.tmpdir") + "/")).exists()) {
                dir.mkdir();
            }
            log.info("path=" + path);
            request.setCharacterEncoding("utf-8");
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository(dir);
            factory.setSizeThreshold(0x100000);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            File file = null;
            InputStream in = null;
            OutputStream out = null;
            try {
                List list = upload.parseRequest(request);
                FileItem fileItem = null;
                for (FileItem item : list) {
                    String name = item.getFieldName();
                    if (item.isFormField()) {
                        String value = item.getString();
                        request.setAttribute(name, (Object)value);
                        log.debug("name=" + name + ",value=" + value);
                        continue;
                    }
                    fileItem = item;
                }
                if (null == fileItem) {
                    return;
                }
                String memId = null == request.getAttribute("memId") ? "APIFILE" : request.getAttribute("memId") + "";
                String fileName = memId + "_" + this.fileReName(fileItem.getName());
                String destPath = path + fileName;
                if (log.isDebugEnabled()) {
                    log.debug("fileName=" + fileName);
                    log.debug("destPath=" + destPath);
                }
                file = new File(destPath);
                out = new FileOutputStream(file);
                in = fileItem.getInputStream();
                int length = 0;
                byte[] buf = new byte[1024];
                while ((length = in.read(buf)) != -1) {
                    out.write(buf, 0, length);
                }
            }
            catch (FileUploadException e1) {
                log.error("", (Throwable)e1);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (null != in) {
                        in.close();
                    }
                    if (null != out) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            PrintWriter printWriter = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, Object> res = new HashMap<String, Object>();
            try {
                boolean check = this.checkUploadFile(file.getName(), response);
                if (!check) break block61;
                String fileUrl = null;
                if (this.getFileUploadTarget() == FileUploadTarget.FTP) {
                    log.info("------\u7f51\u5173\u542f\u7528 FTP \u4e0a\u4f20\uff0c\u4e0a\u4f20\u5730\u5740{}----\u4e0a\u4f20\u6587\u4ef6\u540d{}---------", (Object)this.ftpPath, (Object)file.getName());
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(file);
                        this.fileClient.uploadFileByInputStream(this.ftpPath, file.getName(), (InputStream)inputStream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    fileUrl = this.ftpUrl;
                } else if (this.getFileUploadTarget() == FileUploadTarget.LOCAL) {
                    log.info("------\u7f51\u5173\u542f\u7528\u672c\u5730\u4e0a\u4f20\uff0c\u4e0a\u4f20\u5730\u5740{}----\u4e0a\u4f20\u6587\u4ef6\u540d{}---------", (Object)uploadFilePath, (Object)file.getName());
                    OutputStream os = null;
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        int len;
                        String local = FileUtils.concatFilePath(this.localPath, uploadFilePath);
                        byte[] bs = new byte[1024];
                        File tempFile = new File(local);
                        if (!tempFile.exists()) {
                            tempFile.mkdirs();
                        }
                        os = new FileOutputStream(tempFile.getPath() + File.separator + file.getName());
                        while ((len = ((InputStream)inputStream).read(bs)) != -1) {
                            os.write(bs, 0, len);
                        }
                        fileUrl = local;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            os.close();
                            ((InputStream)inputStream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (this.getFileUploadTarget() == FileUploadTarget.OSS) {
                    log.info("------\u7f51\u5173\u542f\u7528 OSS \u4e0a\u4f20\uff0c\u4e0a\u4f20\u5730\u5740{}----\u4e0a\u4f20\u6587\u4ef6\u540d{}---------", (Object)uploadFilePath, (Object)file.getName());
                    OssFileUtils.uploadFileToPath(file, uploadFilePath, null);
                    fileUrl = FileUtils.concatFilePath(PropertiesUtils.getProperty("OSS_ACCESS_URL"), uploadFilePath);
                }
                res.put("success", true);
                res.put("respCode", "0000");
                res.put("respDesc", "\u4e0a\u4f20\u6210\u529f");
                res.put("code", "0000");
                res.put("message", "\u4e0a\u4f20\u6210\u529f");
                res.put("fileName", file.getName());
                res.put("filePath", FileUtils.concatFilePath(fileUrl, file.getName()));
                printWriter.write(JSON.toJSONString(res));
                printWriter.flush();
            }
            catch (Exception e) {
                res.put("success", false);
                res.put("respCode", "9999");
                res.put("respDesc", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
                res.put("code", "9999");
                res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
                printWriter.write(JSON.toJSONString(res));
                printWriter.flush();
            }
        }
    }

    private String fileReName(String fileName) {
        String newfileName = String.valueOf(UUID.randomUUID());
        if (fileName.lastIndexOf(".") >= 0) {
            newfileName = newfileName + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        return newfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"dowload", "download"})
    public String downloadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutputStream outStream = null;
        FileInputStream inStream = null;
        File downloadFile = null;
        try {
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            String fileName = request.getParameter("fileName");
            String filePath = request.getParameter("filePath");
            String downloadFileName = fileName;
            if (this.getFileUploadTarget() == FileUploadTarget.FTP) {
                log.info("------\u7f51\u5173\u542f\u7528 FTP \u4e0b\u8f7d\uff0c\u4e0b\u8f7d\u5730\u5740 {}----\u4e0b\u8f7d\u6587\u4ef6\u540d {}---------", (Object)filePath, (Object)fileName);
                downloadFile = this.fileClient.downloadToFile(filePath);
            } else if (this.getFileUploadTarget() == FileUploadTarget.LOCAL) {
                log.info("------\u7f51\u5173\u542f\u7528\u672c\u5730\u4e0b\u8f7d\uff0c\u4e0b\u8f7d\u5730\u5740 {}----\u4e0b\u8f7d\u6587\u4ef6\u540d {}---------", (Object)filePath, (Object)fileName);
                downloadFile = new File(filePath);
            } else if (this.getFileUploadTarget() == FileUploadTarget.OSS) {
                log.info("------\u7f51\u5173\u542f\u7528 OSS \u4e0b\u8f7d\uff0c\u4e0b\u8f7d\u5730\u5740 {}----\u4e0b\u8f7d\u6587\u4ef6\u540d {}---------", (Object)filePath, (Object)fileName);
                downloadFile = OssFileUtils.downloadFileFromPath(filePath, null, false);
            }
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                log.info("---download start ---fileName:" + downloadFileName + ",filePath:" + filePath);
                String prex = filePath.substring(filePath.lastIndexOf("."), filePath.length());
                downloadFileName = downloadFileName + prex;
                String userAgent = request.getHeader("User-Agent").toLowerCase();
                downloadFileName = userAgent.contains("msie") || userAgent.contains("like gecko") ? URLEncoder.encode(downloadFileName, "UTF8") : new String(downloadFileName.getBytes("UTF-8"), "ISO8859-1");
            }
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                response.setHeader("Content-Disposition", "attachment;fileName=" + downloadFileName);
            } else {
                response.setHeader("Content-Disposition", "attachment;fileName=" + downloadFile.getName());
            }
            inStream = new FileInputStream(downloadFile);
            outStream = response.getOutputStream();
            byte[] buf = new byte[1024];
            int byteread = -1;
            while ((byteread = inStream.read(buf)) != -1) {
                outStream.write(buf, 0, byteread);
            }
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            if (downloadFile != null && downloadFile.exists()) {
                downloadFile.delete();
            }
        }
        return null;
    }

    @RequestMapping(value={"/downBatchSupplierFile"})
    public HttpServletResponse downBatchSupplierFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String fileName = request.getParameter("fileName");
            String supplierId = request.getParameter("supplierId");
            String path = PropertiesUtils.getProperty("OSS_MST_FILEPATH").trim();
            ArrayList<FileBO> fileList = new ArrayList<FileBO>();
            File zipFile = OssFileUtils.downLoadZipFile(fileList, fileName, null);
            String downloadFileName = fileName;
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                downloadFileName = new String(fileName.getBytes("ISO8859-1"), "UTF-8");
                downloadFileName = downloadFileName + ".zip";
                downloadFileName = StringUtils.contains((CharSequence)request.getHeader("User-Agent"), (CharSequence)"Firefox") ? new String(downloadFileName.getBytes(), "ISO8859-1") : (request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(downloadFileName, "UTF8") : new String(downloadFileName.getBytes("gbk"), "ISO8859-1"));
            }
            response.reset();
            response.setContentType("text/plain");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Location", downloadFileName);
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Content-Disposition", "attachment; filename=" + downloadFileName);
            FileInputStream fis = new FileInputStream(zipFile);
            BufferedInputStream buff = new BufferedInputStream(fis);
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] car = new byte[1024];
            int l = 0;
            while ((long)l < zipFile.length()) {
                int j = buff.read(car, 0, 1024);
                l += j;
                out.write(car, 0, j);
            }
            fis.close();
            buff.close();
            out.close();
            zipFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private boolean checkUploadFile(String fileName, HttpServletResponse response) {
        String suffix = null;
        if (fileName.lastIndexOf(".") > 0 && this.suffixList.contains(suffix = fileName.substring(fileName.lastIndexOf(".")))) {
            return true;
        }
        log.error("\u4e0d\u652f\u6301\u7684\u683c\u5f0f {}\uff0c\u652f\u6301\u7684\u683c\u5f0f {}", (Object)suffix, this.suffixList);
        try {
            response.resetBuffer();
            PrintWriter printWriter = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("success", false);
            res.put("respCode", "9999");
            res.put("respDesc", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff01");
            res.put("fileName", fileName);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a", (Throwable)e);
        }
        return false;
    }

    private FileUploadTarget getFileUploadTarget() {
        log.info("uploadTarget={}", (Object)this.uploadTarget);
        if (StringUtils.isNotBlank((CharSequence)this.uploadTarget)) {
            if (FileUploadTarget.OSS.toString().equals(this.uploadTarget)) {
                return FileUploadTarget.OSS;
            }
            if (FileUploadTarget.LOCAL.toString().equals(this.uploadTarget)) {
                return FileUploadTarget.LOCAL;
            }
            if (FileUploadTarget.FTP.toString().equals(this.uploadTarget)) {
                return FileUploadTarget.FTP;
            }
        }
        if (this.localFile.booleanValue()) {
            return FileUploadTarget.LOCAL;
        }
        return FileUploadTarget.OSS;
    }
}

