/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.newretail.util.FileUtils;
import com.tydic.newretail.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.sf.json.JSONArray;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class InitToConsumerXmlServlet
implements ServletContextListener {
    private final Logger logger = LoggerFactory.getLogger(InitToConsumerXmlServlet.class);
    private static JsonNode initJson = null;
    private static JsonNode initTransferJson = null;
    private static JsonNode initWsJson = null;
    @Value(value="${dubbo.address}")
    private String dubboParam;

    public static JsonNode getJsonNode() {
        return initJson;
    }

    public static JsonNode getInitTransferJson() {
        return initTransferJson;
    }

    public static JsonNode getInitWsJson() {
        return initWsJson;
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.logger.info("InitToConsumerXmlServlet \u5f00\u59cb");
        String path = sce.getServletContext().getRealPath("/WEB-INF/classes");
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
        String initPath = path + File.separator + "service";
        String transferPath = path + File.separator + "transfer";
        String wsPath = initPath + File.separator + "ws";
        File jsonFolder = new File(initPath);
        File transferJsonFolder = new File(transferPath);
        File wsJsonFolder = new File(wsPath);
        File[] jsonFiles = null;
        if (jsonFolder.exists() && jsonFolder.isDirectory()) {
            jsonFiles = FileUtils.getFilesByPattern(".*.json", jsonFolder);
        }
        File[] transferJsonFiles = null;
        if (transferJsonFolder.exists() && transferJsonFolder.isDirectory()) {
            transferJsonFiles = FileUtils.getFilesByPattern(".*.json", transferJsonFolder);
        }
        File[] wsFiles = null;
        if (wsJsonFolder.exists() && wsJsonFolder.isDirectory()) {
            wsFiles = FileUtils.getFilesByPattern("ws.json", wsJsonFolder);
        }
        String xmlPath = path + File.separator + "proxy-remote-consumer.xml";
        Properties mergedProps = new Properties();
        ObjectMapper om = new ObjectMapper();
        InputStream ins = null;
        ByteArrayOutputStream originData = null;
        JSONArray jsonArray = new JSONArray();
        ObjectMapper omTRansfer = new ObjectMapper();
        FileInputStream insTRansfer = null;
        ByteArrayOutputStream originDataTRansfer = null;
        JSONArray jsonTRansferArray = new JSONArray();
        ObjectMapper omWs = new ObjectMapper();
        FileInputStream insWs = null;
        ByteArrayOutputStream originDataWs = null;
        JSONArray jsonWsArray = new JSONArray();
        try {
            File dir;
            JSONArray jsonTemp;
            int readLen;
            byte[] data;
            int i;
            if (null != jsonFiles && jsonFiles.length > 0) {
                for (i = 0; i < jsonFiles.length; ++i) {
                    originData = new ByteArrayOutputStream();
                    ins = new FileInputStream(jsonFiles[i].getPath());
                    data = new byte[1024];
                    readLen = 0;
                    readLen = ins.read(data);
                    while (readLen > 0) {
                        originData.write(data, 0, readLen);
                        readLen = ins.read(data);
                    }
                    if (null == originData) continue;
                    jsonTemp = JSONArray.fromObject((Object)originData.toString());
                    jsonArray.addAll((Collection)jsonTemp);
                }
                initJson = om.readTree(StringUtil.parseParameterText(jsonArray.toString(), mergedProps));
            }
            if (null != transferJsonFiles && transferJsonFiles.length > 0) {
                for (i = 0; i < transferJsonFiles.length; ++i) {
                    originDataTRansfer = new ByteArrayOutputStream();
                    insTRansfer = new FileInputStream(transferJsonFiles[i].getPath());
                    data = new byte[1024];
                    readLen = 0;
                    readLen = ((InputStream)insTRansfer).read(data);
                    while (readLen > 0) {
                        originDataTRansfer.write(data, 0, readLen);
                        readLen = ((InputStream)insTRansfer).read(data);
                    }
                    if (null == originDataTRansfer) continue;
                    jsonTemp = JSONArray.fromObject((Object)originDataTRansfer.toString());
                    jsonTRansferArray.addAll((Collection)jsonTemp);
                }
                initTransferJson = omTRansfer.readTree(StringUtil.parseParameterText(jsonTRansferArray.toString(), mergedProps));
            }
            if (null != wsFiles && wsFiles.length > 0) {
                for (i = 0; i < wsFiles.length; ++i) {
                    originDataWs = new ByteArrayOutputStream();
                    insWs = new FileInputStream(wsFiles[i].getPath());
                    data = new byte[1024];
                    readLen = 0;
                    readLen = ((InputStream)insWs).read(data);
                    while (readLen > 0) {
                        originDataWs.write(data, 0, readLen);
                        readLen = ((InputStream)insWs).read(data);
                    }
                    if (null == originDataWs) continue;
                    jsonTemp = JSONArray.fromObject((Object)originDataWs.toString());
                    jsonWsArray.addAll((Collection)jsonTemp);
                }
                initWsJson = omWs.readTree(StringUtil.parseParameterText(jsonWsArray.toString(), mergedProps));
            }
            Iterator beanList = null;
            if (null != initJson) {
                beanList = initJson.elements();
            }
            ArrayList<String> beanDupList = new ArrayList<String>();
            StringBuilder sb = new StringBuilder(4096);
            sb.append("<beans xmlns=\"http://www.springframework.org/schema/beans\"").append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append("       xmlns:dubbo=\"http://code.alibabatech.com/schema/dubbo\"").append("       xsi:schemaLocation=\"http://www.springframework.org/schema/beans").append("        http://www.springframework.org/schema/beans/spring-beans-2.5.xsd").append("        http://code.alibabatech.com/schema/dubbo").append("        http://code.alibabatech.com/schema/dubbo/dubbo.xsd\">");
            Map<String, String> valueMap = this.getValFromProperties("dubbo.address", "proxy.static.cache-dir");
            if (null != beanList) {
                String dubboAddress = this.dubboParam;
                if (null == dubboAddress || "null".equals(dubboAddress) || "".equals(dubboAddress)) {
                    this.logger.warn("\u6ce8\u5165\u7684 dubboParam \u4e3a\u7a7a\uff0c\u5c1d\u8bd5\u4ece\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6 dubbo \u6ce8\u518c\u4e2d\u5fc3\u5730\u5740");
                    dubboAddress = valueMap.get("dubbo.address");
                }
                sb.append("<dubbo:application name=\"DUBBO_API_GATEWAY\"/>").append("<dubbo:registry address=\"" + dubboAddress + "\"/>");
                while (beanList.hasNext()) {
                    String beanName;
                    JsonNode bean = (JsonNode)beanList.next();
                    String generic = "false";
                    if (null != bean.get("generic") && !"".equals(bean.get("generic").asText())) {
                        generic = bean.get("generic").asText();
                    }
                    if (Boolean.parseBoolean(generic)) continue;
                    String consumerInterface = bean.get("service_name").asText();
                    if (null != bean.get("bean_name") && !"".equals(bean.get("bean_name").asText())) {
                        beanName = bean.get("bean_name").asText();
                    } else {
                        String beanNameTemp = consumerInterface.substring(consumerInterface.lastIndexOf(".") + 1, consumerInterface.length());
                        beanName = beanNameTemp.substring(0, 1).toLowerCase() + beanNameTemp.substring(1);
                    }
                    if (beanDupList.contains(beanName)) continue;
                    String consumerVersion = bean.get("service_version").asText();
                    String consumerGroup = bean.get("group_name").asText();
                    String clientTimeout = "30000";
                    if (null != bean.get("client_timeout") && !"".equals(bean.get("client_timeout").asText())) {
                        clientTimeout = bean.get("client_timeout").asText();
                    }
                    beanDupList.add(beanName);
                    sb.append("<dubbo:reference id=").append("\"" + beanName + "\"").append(" interface=").append("\"" + consumerInterface + "\"").append(" version=").append("\"${" + consumerVersion + "}\"").append(" group=").append("\"${" + consumerGroup + "}\"").append("  loadbalance=\"random\" check=\"false\"").append(" generic=").append("\"" + generic + "\"").append(" timeout=").append("\"" + clientTimeout + "\"").append(" />");
                }
            }
            sb.append("</beans>");
            Document document = DocumentHelper.parseText((String)sb.toString());
            InitToConsumerXmlServlet.saveDocument(document, new File(xmlPath));
            this.logger.info("\u751f\u6210\u6d88\u8d39\u8005xml\u8def\u5f84" + xmlPath);
            String proxyStaticCacheDir = valueMap.get("proxy.static.cache-dir");
            this.logger.info("\u6e05\u7406\u9759\u6001\u8d44\u6e90\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)proxyStaticCacheDir);
            if ("default".equals(proxyStaticCacheDir)) {
                proxyStaticCacheDir = System.getProperty("catalina.home") + File.separator + "static-cache";
                dir = new File(proxyStaticCacheDir);
                FileUtils.deleteDir(dir);
            } else if (proxyStaticCacheDir != null) {
                if (proxyStaticCacheDir.lastIndexOf("static-cache") != -1 || proxyStaticCacheDir.lastIndexOf("static-cache/") != -1) {
                    dir = new File(proxyStaticCacheDir);
                    FileUtils.deleteDir(dir);
                } else {
                    this.logger.error("\u9759\u6001\u8d44\u6e90\u7f13\u5b58\u76ee\u5f55\u914d\u7f6e\u9519\u8bef\uff1a{}", (Object)proxyStaticCacheDir);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u6d88\u8d39\u8005xml\u51fa\u9519", (Throwable)e);
            throw new RuntimeException("\u751f\u6210\u6d88\u8d39\u8005xml\u51fa\u9519" + e.getMessage());
        }
        finally {
            if (null != ins) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != om) {
                try {
                    if (originData != null) {
                        originData.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void saveDocument(Document document, File xmlFile) throws IOException {
        OutputStreamWriter osWrite = new OutputStreamWriter(new FileOutputStream(xmlFile));
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((Writer)osWrite, format);
        writer.write(document);
        writer.flush();
        writer.close();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.logger.info("InitToConsumerXmlServlet \u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getValFromProperties(String ... propKeys) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        InputStreamReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String configPath = System.getProperty("config.path");
            this.logger.info("\u4ece\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6 {} \u4e2d\u8bfb\u53d6\u914d\u7f6e\uff1a{}", (Object)configPath, (Object)propKeys);
            File configFile = new File(configPath);
            System.out.println(configFile.exists());
            if (configFile != null) {
                Properties properties = new Properties();
                fileReader = new FileReader(configFile);
                bufferedReader = new BufferedReader(fileReader);
                properties.load(bufferedReader);
                for (String key : propKeys) {
                    String val = properties.getProperty(key);
                    if (val == null) continue;
                    valueMap.put(key, val);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.logger.info("\u4ece\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u914d\u7f6e:values = {}", valueMap);
        return valueMap;
    }

    public static void main(String[] args) {
        String str = "[\n  {\n    \"service\":\"aicamera/listHumanBodyDetect/v2\",\n    \"service_name\":\"com.tydic.newretail.busi.service.QueryHumanBodyDetectResultService\",\n    \"service_version\":\"AICAMERA_VERSION\",\n    \"group_name\":\"AICAMERA_GROUP\",\n    \"method_name\":\"listHumanBodyDetect\",\n    \"client_timeout\":\"30000\",\n    \"param_type\":\"com.tydic.newretail.bo.HumanBodyDetectResultBO\",\n    \"generic\":\"false\"\n  },\n  {\n    \"service\":\"aicamera/test/v2\",\n    \"service_name\":\"com.tydic.newretail.busi.service.QueryHumanBodyDetectResultService\",\n    \"service_version\":\"AICAMERA_VERSION\",\n    \"group_name\":\"AICAMERA_GROUP\",\n    \"method_name\":\"test\",\n    \"client_timeout\":\"30000\",\n    \"param_type\":\"com.tydic.newretail.bo.HumanBodyDetectResultBO\",\n    \"generic\":\"false\",\n    \"skip_aut\":\"true\"\n  }\n]";
        System.out.println(JSONArray.fromObject((Object)str));
    }
}

