/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.bo.UserAgent;
import com.tydic.newretail.util.RSAUtils;
import com.tydic.newretail.util.UserAgentUtil;
import com.tydic.nicc.platform.busi.UserBusiService;
import com.tydic.nicc.platform.busi.bo.LoginReqBo;
import com.tydic.nicc.platform.busi.bo.LoginRspBo;
import com.tydic.nicc.platform.busi.bo.PwdBo;
import com.tydic.nicc.platform.busi.bo.UserLoginLog;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Resource
    private UserBusiService userBusiService;
    @Autowired
    private CacheClient cacheClient;

    @RequestMapping(value={"/login"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object Login(HttpServletRequest request, HttpServletResponse response) {
        String passWord;
        String userName = request.getParameter("username");
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userName, passWord = request.getParameter("password")})) {
            RspBaseBO rBo = new RspBaseBO();
            rBo.setCode("9999");
            rBo.setMessage("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            return rBo;
        }
        try {
            LoginReqBo loginReqBo = new LoginReqBo();
            loginReqBo.setUserName(userName);
            loginReqBo.setPassWord(passWord);
            LoginRspBo loginRspBo = this.userBusiService.userLogin(loginReqBo);
            if (loginRspBo != null && "0".equals(loginRspBo.getLoginCode())) {
                String agent = request.getHeader("user-agent");
                UserAgent userAgent = UserAgentUtil.getUserAgent(agent);
                UserLoginLog uLog = new UserLoginLog();
                uLog.setLoginName(userName);
                uLog.setHost(UserAgentUtil.getIp(request));
                uLog.setBrowser(userAgent.getBrowserType());
                uLog.setMacOs(userAgent.getPlatformType());
                uLog.setLoginTime(new Date());
                uLog.setTenantId(loginRspBo.getuInfo().getTenantId());
                this.userBusiService.userLoginLog(uLog);
            }
            logger.info("\u767b\u9646\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)loginRspBo.toString());
            return loginRspBo;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("dubbo\u670d\u52a1\u8c03\u7528\u5931\u8d25,{}", (Object)e.getMessage());
            RspBaseBO rBo = new RspBaseBO();
            rBo.setCode("9999");
            rBo.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u670d\u52a1\u5f02\u5e38!");
            return rBo;
        }
    }

    @RequestMapping(value={"/logout"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object Logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader("cas-x-token");
        if (token != null && !"".equals(token)) {
            String realToken = RSAUtils.defaultDecrypt(token);
            String[] t = realToken.split("\\|");
            String userId = t[0];
            this.cacheClient.delete(userId);
        }
        RspBaseBO rBo = new RspBaseBO();
        rBo.setCode("0000");
        rBo.setMessage("\u64cd\u4f5c\u6210\u529f!");
        return rBo;
    }

    @RequestMapping(value={"/repwd"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object updatePwd(HttpServletRequest request, HttpServletResponse response) {
        String newPwd = request.getParameter("newPwd");
        String userId = request.getParameter("userId");
        String oldPwd = request.getParameter("oldPwd");
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{newPwd, userId, oldPwd})) {
            RspBaseBO rBo = new RspBaseBO();
            rBo.setCode("9999");
            rBo.setMessage("\u64cd\u4f5c\u5931\u8d25\uff0c\u7f3a\u5931\u5fc5\u8981\u53c2\u6570\uff01");
            return rBo;
        }
        PwdBo pwdBo = new PwdBo();
        pwdBo.setOldPwd(RSAUtils.defaultDecrypt(oldPwd));
        pwdBo.setNewPwd(RSAUtils.defaultDecrypt(newPwd));
        pwdBo.setUserId(userId);
        return this.userBusiService.changePwd(pwdBo);
    }
}

