/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.tydic.newretail.util.ConvertParamsUtils;
import com.tydic.newretail.util.PropertiesUtils;
import com.tydic.newretail.util.oss.OssFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PagesController {
    private static final Logger logger = LoggerFactory.getLogger(PagesController.class);
    @Value(value="${proxy.static.type:http}")
    private String proxyStaticType;
    @Value(value="${proxy.static.url}")
    private String proxyStaticUrl;
    @Value(value="${proxy.static.cache-dir:default}")
    private String proxyStaticCacheDir;
    @Value(value="${app.dcsfile.host.url}")
    private String fileHeadUrl;
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    @RequestMapping(value={"/pages/**"}, produces={"*/*;charset=UTF-8"})
    @ResponseBody
    public void statics(HttpServletRequest request, HttpServletResponse response) {
        if ("default".equals(this.proxyStaticCacheDir)) {
            this.proxyStaticCacheDir = System.getProperty("catalina.home") + File.separator + "static-cache";
        }
        String service = request.getRequestURI();
        if (StringUtils.isBlank((CharSequence)(service = ConvertParamsUtils.getServiceName(service, "/pages")))) {
            logger.error("\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
            return;
        }
        try {
            service = URLDecoder.decode(service, "utf-8");
            if (service.lastIndexOf(".") == -1) {
                service = service + ".html";
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("{} URL\u89e3\u7801\u5931\u8d25\uff1a{}", (Object)service, (Object)e.getMessage());
            return;
        }
        String localFilePath = this.proxyStaticCacheDir + service;
        File localFile = new File(localFilePath);
        if (localFile.exists() && !localFilePath.endsWith(".html")) {
            long startTime = System.currentTimeMillis();
            this.outPutFile(localFile, response);
            long endTime = System.currentTimeMillis();
            logger.info("\u8f93\u51fa\u672c\u5730\u7f13\u5b58 {} \u8d44\u6e90\u8017\u65f6 {} ms", (Object)localFilePath, (Object)(endTime - startTime));
        } else {
            File file = null;
            if ("http".equals(this.proxyStaticType)) {
                String locationUrl = this.proxyStaticUrl + service;
                long startTime = System.currentTimeMillis();
                file = this.doGetDownload(locationUrl, localFilePath);
                long endTime = System.currentTimeMillis();
                logger.info("{} \u65b9\u5f0f\u4ee3\u7406 {} \u8d44\u6e90\u8017\u65f6 {} ms", new Object[]{this.proxyStaticType, localFilePath, endTime - startTime});
            } else if ("oss".equals(this.proxyStaticType)) {
                long startTime = System.currentTimeMillis();
                file = this.doOssDownload(service, localFilePath);
                long endTime = System.currentTimeMillis();
                logger.info("{} \u65b9\u5f0f\u4ee3\u7406 {} \u8d44\u6e90\u8017\u65f6 {} ms", new Object[]{this.proxyStaticType, localFilePath, endTime - startTime});
            } else {
                logger.error("\u8bf7\u914d\u7f6e\u9759\u6001\u8d44\u6e90\u4ee3\u7406\u65b9\u5f0f\uff1aproxy.static.type");
            }
            if (file != null) {
                this.outPutFile(localFile, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File doOssDownload(String service, String targetPath) {
        File file = null;
        try {
            long startTime = System.currentTimeMillis();
            file = OssFileUtils.downloadFileFromPath(PropertiesUtils.getProperty("OSS_PAGES_FILEPATH") + (service.indexOf(".") > 0 ? service : service + ".html"), null, true);
            long endTime = System.currentTimeMillis();
            logger.info("{} \u4e0b\u8f7doss\u8d44\u6e90\u8017\u65f6 {} ms", (Object)service, (Object)(endTime - startTime));
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return null;
        }
        if (file.exists()) {
            FileInputStream in = null;
            FileOutputStream fos = null;
            try {
                in = new FileInputStream(file);
                File targetFile = new File(targetPath);
                String dir = targetPath.substring(0, targetPath.lastIndexOf("/"));
                File dirFile = new File(dir);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                fos = new FileOutputStream(targetFile);
                fos.write(((InputStream)in).read(new byte[((InputStream)in).available()]));
                File file2 = targetFile;
                return file2;
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u9875\u9762\u8d44\u6e90\u5931\u8d25\uff1a", (Object)e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File doGetDownload(String locationUrl, String targetPath) {
        CloseableHttpResponse response = null;
        try {
            if (this.httpClient == null) {
                this.httpClient = HttpClients.createDefault();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(locationUrl);
            HttpGet httpGet = new HttpGet(sb.toString());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();
            httpGet.setConfig(requestConfig);
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                File file = new File(targetPath);
                String dir = targetPath.substring(0, targetPath.lastIndexOf("/"));
                File dirFile = new File(dir);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(bytes);
                if (fos != null) {
                    fos.close();
                }
                File file2 = file;
                return file2;
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Exception e) {
            logger.error("get \u8bf7\u6c42 {} \u5931\u8d25:{}", (Object)locationUrl, (Object)e.getMessage());
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void outPutFile(File file, HttpServletResponse response) {
        try {
            FileInputStream in = new FileInputStream(file);
            response.reset();
            String contentType = "text/html";
            try {
                Path path = Paths.get(file.getPath(), new String[0]);
                contentType = Files.probeContentType(path);
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6contentType\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
            response.setContentType(contentType);
            response.addHeader("Content-Disposition", "filename=\"" + file.getName() + "\"");
            byte[] buffer = new byte[((InputStream)in).available()];
            ((InputStream)in).read(buffer);
            IOUtils.write((byte[])buffer, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            logger.info("\u6587\u4ef6 {} \u8f93\u51fa\u9519\u8bef\uff1a{}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/group1/**"}, produces={"*/*;charset=UTF-8"})
    @ResponseBody
    public void fastDfsStatis(HttpServletRequest request, HttpServletResponse response) {
        String service;
        if ("default".equals(this.proxyStaticCacheDir)) {
            this.proxyStaticCacheDir = System.getProperty("catalina.home") + File.separator + "static-cache";
        }
        if (StringUtils.isBlank((CharSequence)(service = request.getRequestURI()))) {
            logger.error("\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
            return;
        }
        try {
            service = URLDecoder.decode(service, "utf-8");
            if (service.lastIndexOf(".") == -1) {
                service = service + ".html";
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("{} URL\u89e3\u7801\u5931\u8d25\uff1a{}", (Object)service, (Object)e.getMessage());
            return;
        }
        String localFilePath = this.proxyStaticCacheDir + service;
        File localFile = new File(localFilePath);
        if (localFile.exists() && !localFilePath.endsWith(".html")) {
            long startTime = System.currentTimeMillis();
            this.outPutFile(localFile, response);
            long endTime = System.currentTimeMillis();
            logger.info("\u8f93\u51fa\u672c\u5730\u7f13\u5b58 {} \u8d44\u6e90\u8017\u65f6 {} ms", (Object)localFilePath, (Object)(endTime - startTime));
        } else {
            File file = null;
            if ("http".equals(this.proxyStaticType)) {
                String locationUrl = this.fileHeadUrl + service;
                long startTime = System.currentTimeMillis();
                file = this.doGetDownload(locationUrl, localFilePath);
                long endTime = System.currentTimeMillis();
                logger.info("{} \u65b9\u5f0f\u4ee3\u7406 {} \u8d44\u6e90\u8017\u65f6 {} ms", new Object[]{this.proxyStaticType, localFilePath, endTime - startTime});
            } else {
                logger.error("\u8bf7\u914d\u7f6e\u9759\u6001\u8d44\u6e90\u4ee3\u7406\u65b9\u5f0f\uff1aproxy.static.type");
            }
            if (file != null) {
                this.outPutFile(localFile, response);
            }
        }
    }

    public static void main(String[] args) {
        String service = ConvertParamsUtils.getServiceName("http://103.131.152.140:8083/pages/fe-portal/index#/", "/pages");
        System.out.println(service.lastIndexOf("."));
        System.out.println(service.substring(service.lastIndexOf(".")));
    }
}

