/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.alibaba.dubbo.common.utils.IOUtils;
import com.alibaba.dubbo.common.utils.PojoUtils;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.bo.InvokeInfo;
import com.tydic.newretail.bo.ParamInfo;
import com.tydic.newretail.bo.RequestRecordBO;
import com.tydic.newretail.controller.InitToConsumerXmlServlet;
import com.tydic.newretail.thread.WriteRestLogsThread;
import com.tydic.newretail.util.ConvertParamsUtils;
import com.tydic.newretail.util.DateUtils;
import com.tydic.newretail.util.HttpPostRequest;
import com.tydic.newretail.util.HttpRequestUtils;
import com.tydic.newretail.util.MyDateFormat;
import com.tydic.newretail.util.PropertiesUtils;
import com.tydic.newretail.util.RSAUtils;
import com.tydic.newretail.util.RemoteInvokeUtils;
import com.tydic.newretail.util.TokenUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rest"})
public class RestController
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RestController.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    private Map<String, InvokeInfo> beanStore = new HashMap<String, InvokeInfo>();
    private Map<String, List<String>> urlStore = new HashMap<String, List<String>>();
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private String successPattern = "^([0]+)$";
    @Resource
    CacheClient cacheClient;
    @Autowired
    private Properties propertiesFileLoader;
    private JSONObject headJson;
    private JSONObject bodyJson;
    private static final String inputCharset = "UTF-8";
    private static final String formContentTypeUtf = "application/x-www-form-urlencoded;charset=UTF-8";
    private static final String formContentType = "application/x-www-form-urlencoded";

    @RequestMapping(value={"/portal//**"}, produces={"application/json;charset=UTF-8", "text/plain;charset=UTF-8"})
    @ResponseBody
    public Object portal(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        String params = this.getInputParams(request);
        StringBuffer requestUrl = request.getRequestURL();
        String service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "portal/");
        logger.info("\u8bf7\u6c42\u670d\u52a1 :service = {} params = {} , uri = {}", new Object[]{service, params, requestUrl.toString()});
        if (StringUtils.isBlank((CharSequence)service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
        }
        if (!this.beanStore.containsKey(service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011");
        }
        long startTime = System.currentTimeMillis();
        Object result = this.invoke(request, response, params, service, false);
        long endTime = System.currentTimeMillis();
        logger.info("\u670d\u52a1 {} \u8c03\u7528\u7ed3\u675f\uff1a{} ms", (Object)service, (Object)(endTime - startTime));
        return result;
    }

    @RequestMapping(value={"/login//**"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object login(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        StringBuffer requestUrl = request.getRequestURL();
        Object result = null;
        String service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "login/");
        if (StringUtils.isBlank((CharSequence)service)) {
            logger.warn("\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef\uff1aservice = {}", (Object)service);
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
        }
        if (!this.beanStore.containsKey(service)) {
            logger.warn("\u672a\u914d\u7f6e\u767b\u9646\u670d\u52a1\uff1aservice = {}", (Object)service);
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u767b\u9646\u670d\u52a1\u3010" + service + "\u3011");
        }
        result = this.invoke(request, response, null, service, true);
        if (null == result) {
            return result;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        if (isDebug.booleanValue()) {
            logger.debug("\u767b\u5f55\u7ed3\u679cjsonObject=" + jsonObject);
        }
        if (!jsonObject.containsKey((Object)"code")) {
            return jsonObject.toString();
        }
        String rspCode = jsonObject.getString("code");
        if (!Pattern.matches(this.successPattern, rspCode)) {
            return jsonObject.toString();
        }
        String loginToken = RestController.loginToken();
        JSONObject loginInfo = null;
        if (jsonObject.containsKey((Object)"loginInfoInCacheMap") && null != jsonObject.get("loginInfoInCacheMap")) {
            loginInfo = jsonObject.getJSONObject("loginInfoInCacheMap");
            if (loginInfo.containsKey((Object)"loginName") && loginInfo.containsKey((Object)"system")) {
                Object loginName = loginInfo.get("loginName");
                if (isDebug.booleanValue()) {
                    logger.debug("\u7528\u6237[" + loginName + "]\u4e8e" + DateUtils.dateToDateStr(new Date()) + "\u901a\u8fc7[" + loginInfo.get("system") + "]\u767b\u5f55\u7cfb\u7edf");
                }
            }
            if (loginInfo.containsKey((Object)"redirectUrl") && StringUtils.isNotBlank((CharSequence)loginInfo.getString("redirectUrl"))) {
                String redirectUrl = loginInfo.getString("redirectUrl");
                redirectUrl = redirectUrl.contains("?") ? redirectUrl + "&token=" + loginToken : redirectUrl + "?token=" + loginToken;
                try {
                    if (isDebug.booleanValue()) {
                        logger.debug("\u91cd\u5b9a\u5411\u5730\u5740" + redirectUrl);
                    }
                    response.sendRedirect(redirectUrl);
                }
                catch (IOException e) {
                    logger.error("\u91cd\u5b9a\u5411\u51fa\u9519" + e.getMessage());
                }
            }
        }
        if (null == loginInfo) {
            loginInfo = new JSONObject();
        }
        int expire = 1800;
        if (null != PropertiesUtils.getProperty("loginInfo.cache.timeout")) {
            expire = PropertiesUtils.getIntProperty("loginInfo.cache.timeout");
        }
        this.cacheClient.set(loginToken + "_loginInfo", (Object)loginInfo, expire);
        if (isDebug.booleanValue()) {
            logger.debug("\u653e\u5165\u7f13\u5b58\u6570\u636e key=" + loginToken + "_loginInfo" + " value=" + loginInfo + "\u6709\u6548\u65f6\u95f4" + expire);
            logger.debug("\u767b\u5f55\u6210\u529f");
        }
        jsonObject.put((Object)"token", (Object)loginToken);
        return jsonObject.toString();
    }

    @RequestMapping(value={"/api//**"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String apiInvoke(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        this.headJson = new JSONObject();
        this.bodyJson = null;
        JSONObject result = new JSONObject();
        JSONArray reserved = new JSONArray();
        JSONObject attached = new JSONObject();
        StringBuffer requestUrl = request.getRequestURL();
        String service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "api/");
        if (StringUtils.isBlank((CharSequence)service)) {
            result = ConvertParamsUtils.getRspStr("0000000000", reserved, null, attached, null, "0000000000", ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef"));
            return result.toString();
        }
        if (!this.beanStore.containsKey(service)) {
            result = ConvertParamsUtils.getRspStr("0000000000", reserved, null, attached, null, "0000000000", ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011"));
            return result.toString();
        }
        String params = this.getInputParams(request);
        JSONObject checkRsp = this.checkParams(params, Boolean.parseBoolean(this.beanStore.get(service).getSkipAut()));
        if (null != checkRsp) {
            String transId = this.headJson.containsKey((Object)"TRANS_ID") ? this.headJson.getString("TRANS_ID") : "";
            String appId = this.headJson.containsKey((Object)"APP_ID") ? this.headJson.getString("APP_ID") : "";
            result = ConvertParamsUtils.getRspStr(transId, reserved, null, attached, null, appId, checkRsp);
            return result.toString();
        }
        String reqParamStr = null;
        if (null != this.bodyJson) {
            logger.info("bodyJson=" + this.bodyJson.toString());
            JSONObject transJson = ConvertParamsUtils.transJsonParams(this.bodyJson.toString(), false);
            if (null != transJson) {
                reqParamStr = transJson.toString();
                logger.info("reqParamStr=" + reqParamStr);
            }
        }
        Object obj = this.invoke(request, response, reqParamStr, service, false);
        result.put((Object)"code", (Object)"0000");
        result.put((Object)"message", (Object)"\u64cd\u4f5c\u6210\u529f");
        if (null != obj && String.valueOf(obj).contains("9999")) {
            result = JSONObject.fromObject((Object)String.valueOf(obj));
        }
        String apiRspName = ConvertParamsUtils.camel2Underline(this.beanStore.get(service).getMethodName()) + "_RSP";
        result = ConvertParamsUtils.getRspStr(this.headJson.getString("TRANS_ID"), reserved, apiRspName, attached, obj, this.headJson.getString("APP_ID"), result);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/invoke//**"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object invoke(HttpServletRequest request, HttpServletResponse response, String reqParams, String service, Boolean isLogin) {
        String[] parameterNames;
        String origin = request.getHeader("Origin");
        if (StringUtils.isNotBlank((CharSequence)origin)) {
            String val = response.getHeader("Access-Control-Allow-Origin");
            if (StringUtils.isBlank((CharSequence)val)) {
                response.setHeader("Access-Control-Allow-Origin", origin);
                response.setHeader("Access-Control-Allow-Credentials", "true");
            }
        } else {
            response.setHeader("Access-Control-Allow-Origin", "*");
        }
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
        String reqQuery = request.getQueryString();
        boolean checkQuery = PropertiesUtils.getBooleanProperty("api.checkquery", false);
        if (checkQuery && StringUtils.isNotBlank((CharSequence)reqQuery) && (reqQuery.contains("isLogin") || reqQuery.contains("reqParams"))) {
            logger.error("\u975e\u6cd5\u8bf7\u6c42");
            return ConvertParamsUtils.getErrorRsp("9999", "\u975e\u6cd5\u8bf7\u6c42");
        }
        if (null == isLogin) {
            isLogin = true;
        }
        boolean isJson = false;
        if (null != request.getContentType()) {
            isJson = request.getContentType().contains("application/json") || request.getContentType().contains("text/json");
        }
        StringBuffer requestUrl = request.getRequestURL();
        if (StringUtils.isBlank((CharSequence)service)) {
            service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "invoke/");
        }
        if (StringUtils.isBlank((CharSequence)service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
        }
        if (!this.beanStore.containsKey(service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011");
        }
        String token = request.getHeader("token");
        Object loginInfoObj = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            loginInfoObj = this.cacheClient.get(token + "_loginInfo");
        }
        InvokeInfo invokeInfo = this.beanStore.get(service);
        if (isLogin.booleanValue()) {
            String[] loginPatterns;
            String[] stringArray = loginPatterns = null == PropertiesUtils.getProperty("no.login.pattern") ? null : PropertiesUtils.getProperty("no.login.pattern").split(";");
            if (Boolean.parseBoolean(invokeInfo.getSkipAut())) {
                isLogin = false;
            } else if (null != loginPatterns && loginPatterns.length > 0) {
                for (int i = 0; i < loginPatterns.length; ++i) {
                    if (!Pattern.matches(loginPatterns[i], service)) continue;
                    isLogin = false;
                }
            }
        }
        if (isLogin.booleanValue() && null == loginInfoObj) {
            if (PropertiesUtils.getBooleanProperty("no.login." + service, false).booleanValue()) {
                if (isDebug.booleanValue()) {
                    logger.debug("service = " + service + "\u4e3a\u514d\u767b\u9646\u670d\u52a1");
                }
            } else {
                JSONObject json = new JSONObject();
                json.put((Object)"code", (Object)"9999");
                json.put((Object)"message", (Object)"\u7528\u6237\u672a\u767b\u9646");
                return json;
            }
        }
        Object result = null;
        if (null != invokeInfo.getGenericService()) {
            if (!isJson) {
                logger.error("\u6cdb\u5316\u8c03\u7528\u4ec5\u652f\u6301JSON\u683c\u5f0f\u6570\u636e");
            }
            if ((result = this.gsInvoke(reqParams, request, invokeInfo)) != null) {
                try {
                    return this.getResult(result);
                }
                catch (Exception e) {
                    logger.error("\u8fd4\u56de\u7ed3\u679c\u8131\u654f\u5931\u8d25\uff01{}", (Object)e.getMessage());
                    return result;
                }
            }
        }
        Method method = invokeInfo.getMethod();
        if (!invokeInfo.isParsed() && (parameterNames = (String[])this.cacheClient.get(invokeInfo.getRemoteInvokeKey(), String[].class)) != null && parameterNames.length == invokeInfo.getParamInfoList().size()) {
            List<ParamInfo> paramInfoList = invokeInfo.getParamInfoList();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterNames.length; ++i) {
                ParamInfo paramInfo = paramInfoList.get(i);
                paramInfo.setParamName(parameterNames[i]);
                paramInfo.setParamType(parameterTypes[i]);
            }
            invokeInfo.setParsed(true);
        }
        List<ParamInfo> paramInfoList = invokeInfo.getParamInfoList();
        Object[] commands = new Object[paramInfoList.size()];
        JSONObject jsonParam = null;
        if (StringUtils.isNotBlank((CharSequence)reqParams)) {
            jsonParam = JSONObject.fromObject((Object)reqParams);
        }
        JSONObject userInfoJson = new JSONObject();
        this.getUserInfo(request, userInfoJson);
        if (service.startsWith("authority/user/")) {
            userInfoJson.put((Object)"userId", (Object)userInfoJson.getString("userId_IN"));
            logger.debug("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u670d\u52a1\u53c2\u6570\uff1a{}", (Object)userInfoJson.toString());
        }
        for (int i = 0; i < commands.length; ++i) {
            ParamInfo paramInfo = paramInfoList.get(i);
            Object command = null;
            Class<?> paramType = paramInfo.getParamType();
            if (this.isPrimitiveWrapper(paramType)) {
                String value = null;
                value = null != jsonParam && jsonParam.containsKey((Object)paramInfo.getParamName()) ? jsonParam.getString(paramInfo.getParamName()) : request.getParameter(paramInfo.getParamName());
                if (StringUtils.isBlank((CharSequence)value)) {
                    try {
                        value = ConvertParamsUtils.convertToString((InputStream)request.getInputStream());
                    }
                    catch (IOException e) {
                        logger.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                        return ConvertParamsUtils.getErrorRsp("9999", "\u7ed1\u5b9a\u53c2\u6570\u5931\u8d25");
                    }
                }
                if (StringUtils.isBlank((CharSequence)value)) {
                    command = null;
                } else if (this.isIntegerType(paramType)) {
                    command = Integer.valueOf(value);
                } else if (this.isBooleanType(paramType)) {
                    command = Boolean.valueOf(value);
                } else if (this.isLongType(paramType)) {
                    command = Long.valueOf(value);
                } else if (this.isDoubleType(paramType)) {
                    command = Double.valueOf(value);
                } else if (this.isVoidType(paramType)) {
                    command = null;
                } else if (this.isFloatType(paramType)) {
                    command = Float.valueOf(value);
                } else if (this.isShortType(paramType)) {
                    command = Short.valueOf(value);
                } else {
                    if (!this.isStringType(paramType)) return ConvertParamsUtils.getErrorRsp("9999", "\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\u3010" + paramType.getName() + "\u3011");
                    command = value;
                }
            } else if (isJson) {
                String jsonInputStream = null;
                jsonInputStream = null != jsonParam ? jsonParam.toString() : this.getInputParams(request);
                if (StringUtils.isNotBlank((CharSequence)jsonInputStream)) {
                    JSONObject tempJson = null;
                    try {
                        tempJson = JSONObject.fromObject((Object)jsonInputStream);
                    }
                    catch (Exception e) {
                        logger.error("\u5165\u53c2\u683c\u5f0f\u9519\u8bef:" + e.getMessage());
                        return ConvertParamsUtils.getErrorRsp("9999", "\u5165\u53c2\u683c\u5f0f\u9519\u8bef");
                    }
                    try {
                        DateFormat dateFormat = this.objectMapperThreadLocal.get().getDateFormat();
                        this.objectMapperThreadLocal.get().setDateFormat((DateFormat)new MyDateFormat(dateFormat));
                        this.objectMapperThreadLocal.get().configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
                        this.objectMapperThreadLocal.get().configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
                        this.objectMapperThreadLocal.get().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                        this.objectMapperThreadLocal.get().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                        command = this.objectMapperThreadLocal.get().readValue(jsonInputStream, paramType);
                    }
                    catch (Throwable e) {
                        logger.error("\u7ed1\u5b9a\u53c2\u6570\u3010" + paramType.getName() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
                        JSONObject jSONObject = ConvertParamsUtils.getErrorRsp("9999", "\u7ed1\u5b9a\u53c2\u6570\u3010" + paramType.getName() + "\u3011\u5931\u8d25");
                        return jSONObject;
                    }
                    finally {
                        this.objectMapperThreadLocal.remove();
                    }
                }
            } else {
                if (null != jsonParam) {
                    return ConvertParamsUtils.getErrorRsp("9999", "\u5165\u53c2\u6570\u636e\u683c\u5f0f\u9519\u8bef");
                }
                try {
                    command = paramType.newInstance();
                }
                catch (Throwable e) {
                    logger.error("\u7ed1\u5b9a\u53c2\u6570\u3010" + paramType.getName() + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
                    return ConvertParamsUtils.getErrorRsp("9999", "\u7ed1\u5b9a\u53c2\u6570\u3010" + paramType.getName() + "\u3011\u5931\u8d25");
                }
                ServletRequestDataBinder binder = new ServletRequestDataBinder(command);
                binder.bind((ServletRequest)request);
                command = binder.getTarget();
            }
            commands[i] = command;
        }
        RequestRecordBO record = new RequestRecordBO();
        long startTime = 0L;
        long totalTime = 0L;
        try {
            if (null != commands) {
                Object iterator;
                if (null != loginInfoObj) {
                    JSONObject jsonObj = JSONObject.fromObject((Object)loginInfoObj);
                    iterator = jsonObj.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        for (Object obj : commands) {
                            try {
                                Field f = obj.getClass().getDeclaredField(key);
                                if (null == f) continue;
                                f.setAccessible(true);
                                f.set(obj, jsonObj.getString(key));
                            }
                            catch (Exception e) {
                                logger.error("\u653e\u5165\u7528\u6237\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
                            }
                        }
                    }
                }
                if (userInfoJson.size() > 0) {
                    HashMap fieldMap = new HashMap();
                    try {
                        for (Object obj : commands) {
                            ArrayList<Field> fields = new ArrayList<Field>();
                            for (Class<?> tempClass = obj.getClass(); null != tempClass; tempClass = tempClass.getSuperclass()) {
                                fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
                            }
                            for (Field field : fields) {
                                HashMap<Object, Field> objMap = new HashMap<Object, Field>();
                                objMap.put(obj, field);
                                fieldMap.put(field.getName(), objMap);
                            }
                        }
                    }
                    catch (SecurityException e) {
                        logger.error("\u83b7\u53d6\u5165\u53c2\u6240\u6709\u7c7b\u5931\u8d25\uff1a" + e.getMessage());
                    }
                    iterator = userInfoJson.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        if (!fieldMap.containsKey(key)) continue;
                        try {
                            Map map = (Map)fieldMap.get(key);
                            for (Map.Entry entry : map.entrySet()) {
                                Field f = (Field)entry.getValue();
                                Object obj = entry.getKey();
                                f.setAccessible(true);
                                Class<?> type = f.getType();
                                if (this.isLongType(type)) {
                                    f.set(obj, userInfoJson.getLong(key));
                                    continue;
                                }
                                if (this.isIntegerType(type)) {
                                    f.set(obj, userInfoJson.getInt(key));
                                    continue;
                                }
                                if (this.isStringType(type)) {
                                    f.set(obj, userInfoJson.getString(key));
                                    continue;
                                }
                                if (this.isBooleanType(type)) {
                                    f.set(obj, userInfoJson.getBoolean(key));
                                    continue;
                                }
                                if (this.isDoubleType(type)) {
                                    f.set(obj, userInfoJson.getDouble(key));
                                    continue;
                                }
                                f.set(obj, this.objectMapperThreadLocal.get().readValue(userInfoJson.getString(key), f.getType()));
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e);
                        }
                    }
                }
            }
            if (null != commands) {
                String params = null;
                try {
                    params = JSON.toJSONString((Object)commands);
                }
                catch (Exception e) {
                    logger.error("\u5165\u53c2\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
                }
                record.setRequestInput(params);
            }
            startTime = System.currentTimeMillis();
            record.setRequestTime(new Date());
            logger.info("\u670d\u52a1 {}.{} \u8c03\u7528\u53c2\u6570\uff1a{}", new Object[]{service, invokeInfo.getMethodName(), commands});
            result = method.invoke(invokeInfo.getBean(), commands);
            record.setReponseTime(new Date());
            totalTime = System.currentTimeMillis() - startTime;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u3010 {} \u3011\u5f02\u5e38\uff1a{}", (Object)this.getInvokeTargetName(invokeInfo), (Object)e.getMessage());
            record.setRequestOutput("\u8c03\u7528\u63a5\u53e3\u3010" + this.getInvokeTargetName(invokeInfo) + "\u3011\u5f02\u5e38\uff1a" + e);
            JSONObject jSONObject = ConvertParamsUtils.getErrorRsp("9999", "\u8c03\u7528\u63a5\u53e3\u3010" + this.getInvokeTargetName(invokeInfo) + "\u3011\u5f02\u5e38");
            return jSONObject;
        }
        finally {
            try {
                this.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
                logger.info("\u670d\u52a1\u8c03\u7528\u65f6\u957f\uff1a{} ms", (Object)totalTime);
            }
            catch (Exception e) {
                logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        if (result != null) {
            try {
                return this.getResult(result);
            }
            catch (Exception e) {
                logger.error("\u8fd4\u56de\u7ed3\u679c\u8131\u654f\u5931\u8d25\uff01{}", (Object)e.getMessage());
                return result;
            }
        }
        logger.info("\u51fa\u53c2\uff0c\u8f6c\u6362\u540e\u7684\u503c:{}", (Object)(result == null ? null : result.toString()));
        return result;
    }

    private void getUserInfo(HttpServletRequest request, JSONObject tempJson) {
        try {
            String token = request.getHeader("cas-x-token");
            if ("".equals(token) || token == null) {
                return;
            }
            token = RSAUtils.defaultDecrypt(token);
            String[] t = token.split("\\|");
            String userId = t[0];
            logger.info("\u7528\u6237id:{}", (Object)userId);
            if (this.cacheClient.get(userId) == null) {
                return;
            }
            String rv = this.cacheClient.get(userId).toString();
            com.alibaba.fastjson.JSONObject rmap = JSON.parseObject((String)rv);
            Map sPo = (Map)rmap.get("uInfo");
            logger.info("\u4eceredis\u4e2d\u83b7\u53d6\u7528\u6237\u4fe1\u606f:{}", (Object)sPo.toString());
            if (null != sPo) {
                tempJson.put((Object)"userId_IN", sPo.get("userId_IN"));
                tempJson.put((Object)"loginName_IN", sPo.get("loginName_IN"));
                tempJson.put((Object)"mEmpId_IN", sPo.get("mEmpId_IN"));
                tempJson.put((Object)"tenantCode_IN", sPo.get("tenantCode_IN"));
                tempJson.put((Object)"mName_IN", sPo.get("mName_IN"));
                tempJson.put((Object)"cellPhone_IN", sPo.get("cellPhone_IN"));
                tempJson.put((Object)"email_IN", sPo.get("email_IN"));
                tempJson.put((Object)"status_IN", sPo.get("status_IN"));
                if (null != sPo.get("mOrgId_IN")) {
                    tempJson.put((Object)"mOrgId_IN", (Object)sPo.get("mOrgId_IN").toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private Map<String, Object> getUserInfo(HttpServletRequest request) {
        try {
            String token = request.getHeader("cas-x-token");
            System.out.println("cas-x-token:" + token);
            if ("".equals(token) || token == null) {
                return null;
            }
            token = RSAUtils.defaultDecrypt(token);
            String[] t = token.split("\\|");
            String userId = t[0];
            logger.info("\u900f\u4f20->\u7528\u6237id:{}", (Object)userId);
            System.out.println(userId);
            if (this.cacheClient.get(userId) == null) {
                return null;
            }
            String rv = this.cacheClient.get(userId).toString();
            com.alibaba.fastjson.JSONObject rmap = JSON.parseObject((String)rv);
            Map sPo = (Map)rmap.get("uInfo");
            logger.info("\u900f\u4f20->\u4eceredis\u4e2d\u83b7\u53d6\u7528\u6237\u4fe1\u606f:{}", (Object)sPo.toString());
            System.out.println("\u900f\u4f20->\u4eceredis\u4e2d\u83b7\u53d6\u7528\u6237\u4fe1\u606f" + sPo.toString());
            HashMap<String, Object> rMap = new HashMap<String, Object>();
            if (null != sPo) {
                rMap.put("userId_IN", sPo.get("userId_IN"));
                rMap.put("tenantCode_IN", sPo.get("tenantCode_IN"));
                rMap.put("mUname_IN", sPo.get("mUname_IN"));
                rMap.put("mName_IN", sPo.get("mName_IN"));
                if (null != sPo.get("mOrgId_IN")) {
                    rMap.put("mOrgId_IN", sPo.get("mOrgId_IN").toString());
                }
            }
            return rMap;
        }
        catch (Exception e) {
            logger.error("\u900f\u4f20->\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/transfer//**"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object send(HttpServletRequest request, HttpServletResponse response) {
        int listSize;
        StringBuffer requestUrl = request.getRequestURL();
        String service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "transfer/");
        if (StringUtils.isBlank((CharSequence)service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
        }
        if (!this.urlStore.containsKey(service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            header.put(key, value);
        }
        Map<String, Object> rMap = this.getUserInfo(request);
        try {
            header.put("userId", String.valueOf(rMap.get("userId_IN")));
            header.put("userName", URLEncoder.encode(String.valueOf(rMap.get("mName_IN")), inputCharset));
            header.put("userLoginName", URLEncoder.encode(String.valueOf(rMap.get("mUname_IN")), inputCharset));
            header.put("tenantId", String.valueOf(rMap.get("tenantCode_IN")));
            header.put("mOrgId_IN", String.valueOf(rMap.get("mOrgId_IN")));
        }
        catch (Exception e) {
            logger.debug("\u7f51\u5173\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25! ");
        }
        boolean isGzip = false;
        if (isDebug.booleanValue()) {
            logger.debug("request.getHeaderNames():" + ((Object)header).toString());
        }
        List<String> urlList = this.urlStore.get(service);
        if (isDebug.booleanValue()) {
            logger.debug("\u900f\u4f20\u670d\u52a1url\u5217\u8868\uff1a" + urlList.toString());
        }
        if ((listSize = urlList.size()) <= 0) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011\u7684ip\u7aef\u53e3");
        }
        int randomNumber = (int)Math.round(Math.random() * (double)(listSize - 1) + 0.0);
        String urlRandom = urlList.get(randomNumber);
        JSONObject rspObj = new JSONObject();
        String mode = request.getMethod();
        String type = request.getContentType();
        String chat = request.getCharacterEncoding();
        if (isDebug.booleanValue()) {
            logger.debug("request.getContentType():" + type + ",request.getCharacterEncoding():" + chat);
        }
        String params = null;
        String queryString = null;
        ServletInputStream input = null;
        if ("POST".equalsIgnoreCase(mode)) {
            try {
                Map properties = request.getParameterMap();
                if (!properties.isEmpty()) {
                    Map<String, String> paramMap = RestController.getParameterMap(request);
                    paramMap.put("loginName_IN", String.valueOf(rMap.get("mName_IN")));
                    paramMap.put("mName_IN", String.valueOf(rMap.get("mUname_IN")));
                    StringBuffer formparams = new StringBuffer();
                    for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.getValue()}) || "-".equals(entry.getValue())) continue;
                        formparams.append(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), chat) + "&");
                    }
                    params = formparams.substring(0, formparams.length() - 1);
                    if (isDebug.booleanValue()) {
                        logger.debug("\u8bf7\u6c42\u5165\u53c2params\uff1a" + params);
                    }
                } else {
                    input = request.getInputStream();
                    if (isDebug.booleanValue()) {
                        logger.debug("\u8bf7\u6c42\u5165\u53c2request.getInputStream()\uff1a" + request.getInputStream().toString());
                    }
                }
            }
            catch (IOException e1) {
                logger.error("\u83b7\u53d6\u8bf7\u6c42\u5165\u53c2\u51fa\u9519\uff1a" + e1);
                return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25:\u83b7\u53d6\u8bf7\u6c42\u5165\u53c2\u51fa\u9519" + e1.getMessage());
            }
            try {
                rspObj = StringUtils.isNotBlank(params) ? HttpPostRequest.doPost(params, urlRandom, header, chat, isGzip) : HttpPostRequest.doPost((InputStream)input, urlRandom, header, chat, isGzip);
                String ret = rspObj.getString("Data");
                if (ret != null && ret.trim().length() > 0) {
                    try {
                        ret = this.delHtmlTags(ret);
                    }
                    catch (Exception e) {
                        logger.error("\u8fd4\u56de\u7ed3\u679c\u8131\u654f\u5931\u8d25\uff01{}", (Object)e.getMessage());
                    }
                }
                return ret;
            }
            catch (Exception e1) {
                if (listSize <= 1) {
                    return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25\u3010" + rspObj.get("HTTPCODE") + "\u3011");
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u900f\u4f20\u670d\u52a1url\uff1a" + urlRandom + "\u8fd4\u56de" + rspObj.toString() + ",\u66f4\u6362URL\u53d1\u8d77\u91cd\u8bd5");
                }
                ArrayList<String> remove = new ArrayList<String>();
                remove.add(urlList.get(randomNumber));
                urlList.removeAll(remove);
                for (String url : urlList) {
                    try {
                        rspObj = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params}) ? HttpPostRequest.doPost(params, url, header, chat, isGzip) : HttpPostRequest.doPost((InputStream)input, url, header, chat, isGzip);
                        if (!rspObj.containsKey((Object)"HTTPCODE") || 200 != rspObj.getInt("HTTPCODE")) continue;
                        String ret = rspObj.getString("Data");
                        if (ret != null && ret.trim().length() > 0) {
                            try {
                                ret = this.delHtmlTags(ret);
                            }
                            catch (Exception e) {
                                logger.error("\u8fd4\u56de\u7ed3\u679c\u8131\u654f\u5931\u8d25\uff01{}", (Object)e.getMessage());
                            }
                        }
                        return ret;
                    }
                    catch (Exception e) {
                        logger.debug("\u900f\u4f20\u670d\u52a1\u51fa\u9519\uff1a" + e);
                    }
                }
            }
        } else {
            queryString = request.getQueryString();
            urlRandom = urlRandom + "?";
            rspObj = HttpRequestUtils.request(urlRandom = urlRandom + queryString, params, inputCharset, inputCharset, inputCharset, mode, type, header);
            if (rspObj.containsKey((Object)"HTTPCODE") && 200 == rspObj.getInt("HTTPCODE")) {
                String ret = rspObj.getString("Data");
                return ret;
            }
            if (listSize <= 1) {
                return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25\u3010" + rspObj.get("HTTPCODE") + "\u3011");
            }
            if (isDebug.booleanValue()) {
                logger.debug("\u900f\u4f20\u670d\u52a1url\uff1a" + urlRandom + "\u8fd4\u56de" + rspObj.toString() + ",\u66f4\u6362URL\u53d1\u8d77\u91cd\u8bd5");
            }
            ArrayList<String> remove = new ArrayList<String>();
            remove.add(urlList.get(randomNumber));
            urlList.removeAll(remove);
            for (String url : urlList) {
                try {
                    url = url + "?";
                    rspObj = HttpRequestUtils.request(url = url + queryString, params, inputCharset, inputCharset, inputCharset, mode, type, header);
                    if (!rspObj.containsKey((Object)"HTTPCODE") || 200 != rspObj.getInt("HTTPCODE")) continue;
                    String ret = rspObj.getString("Data");
                    if (ret != null && ret.trim().length() > 0) {
                        try {
                            ret = this.delHtmlTags(ret);
                        }
                        catch (Exception e) {
                            logger.error("\u8fd4\u56de\u7ed3\u679c\u8131\u654f\u5931\u8d25\uff01{}", (Object)e.getMessage());
                        }
                    }
                    return ret;
                }
                catch (Exception e) {
                    logger.debug("\u900f\u4f20\u670d\u52a1\u51fa\u9519\uff1a" + e);
                }
            }
        }
        return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25\u3010" + rspObj.get("HTTPCODE") + "\u3011");
    }

    @RequestMapping(value={"/exportfile//**"})
    @ResponseBody
    public Object exportFile(HttpServletRequest request, HttpServletResponse response) {
        int listSize;
        StringBuffer requestUrl = request.getRequestURL();
        logger.info("\u900f\u4f20\u670d\u52a1 :uri = {}", (Object)requestUrl.toString());
        String service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "exportfile/");
        logger.info("\u900f\u4f20\u670d\u52a1 :service = {}", (Object)service);
        if (StringUtils.isBlank((CharSequence)service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
        }
        if (!this.urlStore.containsKey(service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            header.put(key, value);
        }
        Map<String, Object> rMap = this.getUserInfo(request);
        try {
            header.put("userId", String.valueOf(rMap.get("userId_IN")));
            header.put("userName", URLEncoder.encode(String.valueOf(rMap.get("mName_IN")), inputCharset));
            header.put("userLoginName", URLEncoder.encode(String.valueOf(rMap.get("mUname_IN")), inputCharset));
            header.put("tenantId", String.valueOf(rMap.get("tenantCode_IN")));
        }
        catch (Exception e) {
            logger.debug("\u7f51\u5173\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25! ");
        }
        boolean isGzip = false;
        if (isDebug.booleanValue()) {
            logger.debug("request.getHeaderNames():" + ((Object)header).toString());
        }
        List<String> urlList = this.urlStore.get(service);
        if (isDebug.booleanValue()) {
            logger.debug("\u900f\u4f20\u670d\u52a1url\u5217\u8868\uff1a" + urlList.toString());
        }
        if ((listSize = urlList.size()) <= 0) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u672a\u914d\u7f6e\u670d\u52a1\u3010" + service + "\u3011\u7684ip\u7aef\u53e3");
        }
        int randomNumber = (int)Math.round(Math.random() * (double)(listSize - 1) + 0.0);
        String urlRandom = urlList.get(randomNumber);
        JSONObject rspObj = new JSONObject();
        String mode = request.getMethod();
        String type = request.getContentType();
        String chat = request.getCharacterEncoding();
        if (isDebug.booleanValue()) {
            logger.debug("request.getContentType():" + type + ",request.getCharacterEncoding():" + chat);
        }
        String params = null;
        String queryString = null;
        ServletInputStream input = null;
        if ("POST".equalsIgnoreCase(mode)) {
            try {
                Map properties = request.getParameterMap();
                if (!properties.isEmpty()) {
                    Map<String, String> paramMap = RestController.getParameterMap(request);
                    StringBuffer formparams = new StringBuffer();
                    for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.getValue()}) || "-".equals(entry.getValue())) continue;
                        formparams.append(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), chat) + "&");
                    }
                    params = formparams.substring(0, formparams.length() - 1);
                    if (isDebug.booleanValue()) {
                        logger.debug("\u8bf7\u6c42\u5165\u53c2params\uff1a" + params);
                    }
                } else {
                    input = request.getInputStream();
                    if (isDebug.booleanValue()) {
                        logger.debug("\u8bf7\u6c42\u5165\u53c2request.getInputStream()\uff1a" + request.getInputStream().toString());
                    }
                }
            }
            catch (IOException e1) {
                logger.error("\u83b7\u53d6\u8bf7\u6c42\u5165\u53c2\u51fa\u9519\uff1a" + e1);
                return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25:\u83b7\u53d6\u8bf7\u6c42\u5165\u53c2\u51fa\u9519" + e1.getMessage());
            }
            logger.info("\u900f\u4f20\u5165\u53c2\uff1aparam = {}", params);
            try {
                if (StringUtils.isNotBlank(params)) {
                    rspObj = HttpPostRequest.doPost(params, urlRandom, header, chat, isGzip);
                } else {
                    HttpPostRequest.doFilePost((InputStream)input, urlRandom, header, response);
                }
                String ret = rspObj.getString("Data");
                return ret;
            }
            catch (Exception e1) {
                if (listSize <= 1) {
                    return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25\u3010" + rspObj.get("HTTPCODE") + "\u3011");
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u900f\u4f20\u670d\u52a1url\uff1a" + urlRandom + "\u8fd4\u56de" + rspObj.toString() + ",\u66f4\u6362URL\u53d1\u8d77\u91cd\u8bd5");
                }
                ArrayList<String> remove = new ArrayList<String>();
                remove.add(urlList.get(randomNumber));
                urlList.removeAll(remove);
                for (String url : urlList) {
                    try {
                        rspObj = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params}) ? HttpPostRequest.doPost(params, url, header, chat, isGzip) : HttpPostRequest.doPost((InputStream)input, url, header, chat, isGzip);
                        if (!rspObj.containsKey((Object)"HTTPCODE") || 200 != rspObj.getInt("HTTPCODE")) continue;
                        String ret = rspObj.getString("Data");
                        return ret;
                    }
                    catch (Exception e) {
                        logger.debug("\u900f\u4f20\u670d\u52a1\u51fa\u9519\uff1a" + e);
                    }
                }
            }
        } else {
            queryString = request.getQueryString();
            urlRandom = urlRandom + "?";
            rspObj = HttpRequestUtils.request(urlRandom = urlRandom + queryString, params, inputCharset, inputCharset, inputCharset, mode, type, header);
            if (rspObj.containsKey((Object)"HTTPCODE") && 200 == rspObj.getInt("HTTPCODE")) {
                String ret = rspObj.getString("Data");
                return ret;
            }
            if (listSize <= 1) {
                return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25\u3010" + rspObj.get("HTTPCODE") + "\u3011");
            }
            if (isDebug.booleanValue()) {
                logger.debug("\u900f\u4f20\u670d\u52a1url\uff1a" + urlRandom + "\u8fd4\u56de" + rspObj.toString() + ",\u66f4\u6362URL\u53d1\u8d77\u91cd\u8bd5");
            }
            ArrayList<String> remove = new ArrayList<String>();
            remove.add(urlList.get(randomNumber));
            urlList.removeAll(remove);
            for (String url : urlList) {
                try {
                    url = url + "?";
                    rspObj = HttpRequestUtils.request(url = url + queryString, params, inputCharset, inputCharset, inputCharset, mode, type, header);
                    if (!rspObj.containsKey((Object)"HTTPCODE") || 200 != rspObj.getInt("HTTPCODE")) continue;
                    String ret = rspObj.getString("Data");
                    return ret;
                }
                catch (Exception e) {
                    logger.debug("\u900f\u4f20\u670d\u52a1\u51fa\u9519\uff1a" + e);
                }
            }
        }
        return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u5931\u8d25\u3010" + rspObj.get("HTTPCODE") + "\u3011");
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator iter = properties.entrySet().iterator();
        String name = "";
        String value = "";
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        JsonNode bean;
        System.out.println("setApplicationContext");
        PropertiesUtils.init(this.propertiesFileLoader);
        Properties mergedProps = new Properties();
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)mergedProps);
            }
        }
        try {
            JsonNode initJson = InitToConsumerXmlServlet.getJsonNode();
            Iterator beanList = null;
            if (null != initJson) {
                beanList = initJson.elements();
            }
            while (null != beanList && beanList.hasNext()) {
                String beanName;
                bean = (JsonNode)beanList.next();
                String service = bean.get("service").asText();
                logger.debug("service:" + service);
                String consumerInterface = bean.get("service_name").asText();
                logger.debug("consumerInterface:" + consumerInterface);
                String version = bean.get("service_version").asText();
                logger.debug("version:" + version);
                String group = bean.get("group_name").asText();
                logger.debug("group:" + group);
                String consumerMethod = bean.get("method_name").asText();
                logger.debug("consumerMethod:" + consumerMethod);
                String consumerVersion = mergedProps.getProperty(version, null);
                String consumerGroup = mergedProps.getProperty(group, null);
                String skipAut = "false";
                if (null != bean.get("skip_aut")) {
                    skipAut = bean.get("skip_aut").asText();
                }
                if (null != bean.get("bean_name")) {
                    beanName = bean.get("bean_name").asText();
                    logger.debug("beanName:" + beanName);
                } else {
                    String beanNameTemp = consumerInterface.substring(consumerInterface.lastIndexOf(".") + 1, consumerInterface.length());
                    beanName = beanNameTemp.substring(0, 1).toLowerCase() + beanNameTemp.substring(1);
                    logger.debug("beanName:" + beanName);
                }
                try {
                    Object consumer;
                    InvokeInfo invokeInfo = new InvokeInfo();
                    String generic = "false";
                    if (null != bean.get("generic") && !"".equals(bean.get("generic").asText())) {
                        generic = bean.get("generic").asText();
                    }
                    if (null == (consumer = applicationContext.getBean(beanName))) {
                        throw new IllegalStateException("required invoke bean[" + consumerInterface + ":" + consumerGroup + ":" + consumerVersion + "] required method[" + consumerMethod + "]");
                    }
                    Method[] methods = Class.forName(consumerInterface).getMethods();
                    Method targetMethod = null;
                    for (Method method : methods) {
                        if (!method.getName().equals(consumerMethod)) continue;
                        targetMethod = method;
                        break;
                    }
                    if (targetMethod == null) {
                        throw new IllegalStateException("invoke bean[" + consumerInterface + ":" + consumerGroup + ":" + consumerVersion + "] required method[" + consumerMethod + "]");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("find invoke bean[" + consumerInterface + ":" + consumerGroup + ":" + consumerVersion + "]");
                    }
                    invokeInfo.setBean(consumer);
                    invokeInfo.setMethod(targetMethod);
                    Class<?>[] parameterTypes = targetMethod.getParameterTypes();
                    ArrayList<ParamInfo> paramInfoList = new ArrayList<ParamInfo>();
                    for (Class<?> parameterType : parameterTypes) {
                        ParamInfo paramInfo = new ParamInfo();
                        paramInfo.setParamType(parameterType);
                        paramInfoList.add(paramInfo);
                    }
                    invokeInfo.setParamInfoList(paramInfoList);
                    invokeInfo.setSkipAut(skipAut);
                    invokeInfo.setMethodName(consumerMethod);
                    invokeInfo.setRemoteInvokeKey(RemoteInvokeUtils.getRemoteKey(consumerInterface, consumerMethod, consumerGroup, consumerVersion));
                    logger.info("\u52a0\u8f7d\u670d\u52a1\u914d\u7f6e\uff1a{}", (Object)invokeInfo);
                    this.beanStore.put(service, invokeInfo);
                }
                catch (Exception e) {
                    logger.error("\u5f53\u524d\u670d\u52a1\u3010" + service + "\u3011\u914d\u7f6e\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init consumer service error:", e);
        }
        try {
            JsonNode initTransferJson = InitToConsumerXmlServlet.getInitTransferJson();
            Iterator beanTransferList = null;
            if (null != initTransferJson) {
                beanTransferList = initTransferJson.elements();
            }
            while (null != beanTransferList && beanTransferList.hasNext()) {
                bean = (JsonNode)beanTransferList.next();
                String apiService = bean.get("apiservice").asText();
                String transuris = bean.get("transuris").asText();
                String transservice = bean.get("transservice").asText();
                String[] uriArr = transuris.split(";");
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(uriArr));
                ArrayList<String> urlList = new ArrayList<String>();
                if (!CollectionUtils.isEmpty(arrayList)) {
                    for (String string : arrayList) {
                        String uri = PropertiesUtils.getProperty(string);
                        if (null == uri || "".equals(uri)) {
                            logger.error("\u900f\u4f20\u670d\u52a1\u524d\u7f00\uff1a" + string + "\u672a\u914d\u7f6e");
                            continue;
                        }
                        urlList.add(uri + transservice);
                        System.out.println("\u900f\u4f20\u670d\u52a1\u4e3a\uff1a" + uri + transservice);
                    }
                }
                this.urlStore.put(apiService, urlList);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init transfer service error:", e);
        }
    }

    private String getInputParams(HttpServletRequest request) {
        String params = null;
        BufferedReader reader = null;
        try {
            if (null != request.getInputStream()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                params = IOUtils.read((Reader)reader);
            }
            String string = params;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("\u83b7\u53d6\u5165\u53c2\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    private String getInvokeTargetName(InvokeInfo invokeInfo) {
        return invokeInfo.getBean().getClass().getName() + "." + invokeInfo.getMethod().getName();
    }

    private boolean isPrimitiveWrapper(Class<?> paramType) {
        if (this.isVoidType(paramType)) {
            return true;
        }
        if (this.isShortType(paramType)) {
            return true;
        }
        if (this.isIntegerType(paramType)) {
            return true;
        }
        if (this.isLongType(paramType)) {
            return true;
        }
        if (this.isBooleanType(paramType)) {
            return true;
        }
        if (this.isFloatType(paramType)) {
            return true;
        }
        if (this.isDoubleType(paramType)) {
            return true;
        }
        return this.isStringType(paramType);
    }

    private JSONObject checkParams(String params, boolean skipAuth) {
        String appSecret;
        JSONObject jsonParams;
        if (StringUtils.isBlank((CharSequence)params)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            jsonParams = JSONObject.fromObject((Object)params);
        }
        catch (Exception e) {
            logger.error("\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u62a5\u6587\u683c\u5f0f\u9519\u8bef");
        }
        if (!jsonParams.containsKey((Object)"HEAD")) {
            logger.error("\u8bf7\u6c42\u62a5\u6587\u5fc5\u987b\u5305\u542b\u62a5\u6587\u5934");
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42\u62a5\u6587\u5fc5\u987b\u5305\u542b\u62a5\u6587\u5934");
        }
        try {
            this.headJson = jsonParams.getJSONObject("HEAD");
            if (jsonParams.containsKey((Object)"BODY") && jsonParams.get("BODY").getClass().toString().endsWith("JSONObject")) {
                this.bodyJson = jsonParams.getJSONObject("BODY");
            }
        }
        catch (Exception e) {
            logger.error("\u62a5\u6587\u5934\u6216\u62a5\u6587\u4f53\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            return ConvertParamsUtils.getErrorRsp("9999", "\u62a5\u6587\u5934\u6216\u62a5\u6587\u4f53\u683c\u5f0f\u9519\u8bef");
        }
        if (!(this.headJson.containsKey((Object)"TRANS_ID") && this.headJson.containsKey((Object)"TIMESTAMP") && this.headJson.containsKey((Object)"APP_ID") && this.headJson.containsKey((Object)"TOKEN"))) {
            logger.error("\u62a5\u6587\u5934\u683c\u5f0f\u9519\u8bef");
            return ConvertParamsUtils.getErrorRsp("9999", "\u62a5\u6587\u5934\u683c\u5f0f\u9519\u8bef");
        }
        String reserved = null;
        if (this.headJson.containsKey((Object)"RESERVED")) {
            reserved = this.headJson.getString("RESERVED");
        }
        if (null == (appSecret = PropertiesUtils.getProperty(this.headJson.getString("APP_ID")))) {
            return ConvertParamsUtils.getErrorRsp("9999", "appId\u9519\u8bef");
        }
        String token = TokenUtils.getToken(this.headJson.getString("APP_ID"), this.headJson.getString("TIMESTAMP"), this.headJson.getString("TRANS_ID"), reserved, appSecret);
        if (isDebug.booleanValue()) {
            logger.debug("currentToken=" + token);
            logger.debug("targetToken=" + this.headJson.getString("TOKEN"));
        }
        if (!token.equals(this.headJson.getString("TOKEN")) && !skipAuth) {
            logger.error("\u5f53\u524d\u8bf7\u6c42\u65b9\u6ca1\u6709\u8c03\u7528\u6743\u9650");
            return ConvertParamsUtils.getErrorRsp("9999", "\u5f53\u524d\u8bf7\u6c42\u65b9\u6ca1\u6709\u8c03\u7528\u6743\u9650");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object gsInvoke(String reqParams, HttpServletRequest request, InvokeInfo invokeInfo) {
        Object result;
        block13: {
            result = null;
            Object paramMap = null;
            String params = null;
            params = StringUtils.isNotBlank((CharSequence)reqParams) ? reqParams : this.getInputParams(request);
            String[] paramTypeReq = null;
            Object[] paramValueReq = null;
            if (StringUtils.isNotBlank((CharSequence)invokeInfo.getParamType())) {
                paramTypeReq = new String[]{invokeInfo.getParamType()};
                if (StringUtils.isBlank((CharSequence)params)) {
                    return ConvertParamsUtils.getErrorRsp("9999", "\u5165\u53c2\u4e3a\u7a7a");
                }
                paramMap = JSON.parseObject((String)params);
                paramValueReq = new Object[]{PojoUtils.generalize((Object)paramMap)};
            }
            RequestRecordBO record = new RequestRecordBO();
            if (null != paramMap) {
                record.setRequestInput(paramMap.toString());
            }
            long startTime = System.currentTimeMillis();
            long totalTime = 0L;
            record.setRequestTime(new Date());
            result = invokeInfo.getGenericService().$invoke(invokeInfo.getMethodName(), paramTypeReq, paramValueReq);
            totalTime = System.currentTimeMillis() - startTime;
            record.setReponseTime(new Date());
            try {
                this.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
            }
            catch (Exception e) {
                logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            }
            break block13;
            catch (Exception e) {
                JSONObject jSONObject;
                try {
                    logger.error("\u6cdb\u5316\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
                    record.setRequestOutput("\u6cdb\u5316\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
                    jSONObject = ConvertParamsUtils.getErrorRsp("9999", "\u6cdb\u5316\u8c03\u7528\u5f02\u5e38");
                }
                catch (Throwable throwable) {
                    try {
                        this.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
                    }
                    catch (Exception e2) {
                        logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e2.getMessage());
                    }
                    throw throwable;
                }
                try {
                    this.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
                }
                catch (Exception e3) {
                    logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e3.getMessage());
                }
                return jSONObject;
            }
        }
        return result;
    }

    private boolean isListType(Class<?> paramType) {
        return List.class == paramType || List.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isMapType(Class<?> paramType) {
        return Map.class == paramType || Map.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isStringType(Class<?> paramType) {
        return String.class == paramType;
    }

    private boolean isDoubleType(Class<?> paramType) {
        return Double.class == paramType || Double.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isFloatType(Class<?> paramType) {
        return Float.class == paramType || Float.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isBooleanType(Class<?> paramType) {
        return Boolean.class == paramType || Boolean.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isLongType(Class<?> paramType) {
        return Long.class == paramType || Long.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isIntegerType(Class<?> paramType) {
        return Integer.class == paramType || "int".equals(paramType.getName());
    }

    private boolean isShortType(Class<?> paramType) {
        return Short.class == paramType || Short.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private boolean isVoidType(Class<?> paramType) {
        return Void.class == paramType || Void.class.getSimpleName().equalsIgnoreCase(paramType.getName());
    }

    private static String loginToken() {
        Random r = new Random();
        int randomCode = r.nextInt(99999);
        return ConvertParamsUtils.encode("" + randomCode);
    }

    private void writeLogs(long totalTime, long startTime, Object result, RequestRecordBO record, InvokeInfo invokeInfo, HttpServletRequest request) {
        if (0L == totalTime) {
            totalTime = System.currentTimeMillis() - startTime;
        }
        record.setRequestMethod(invokeInfo.getMethodName());
        record.setRequestType(request.getMethod());
        String url = request.getRequestURL().toString();
        if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
            url = url + "?" + request.getQueryString();
        }
        record.setRequestUrl(url);
        record.setTimeConsuming(totalTime);
        if (null != invokeInfo.getMethod()) {
            record.setRequestService(String.valueOf(invokeInfo.getMethod()));
        }
        if (null != invokeInfo.getGenericService()) {
            record.setRequestService(invokeInfo.getGenericService().toString());
        }
        if (null == record.getReponseTime()) {
            record.setReponseTime(new Date());
        }
        if (null != record.getRequestTime()) {
            record.setRequestTimeStr(DateUtils.formatDate(record.getRequestTime(), "yyyy-MM-dd HH:mm:ss SSS"));
        }
        if (null != record.getReponseTime()) {
            record.setResponseTimeStr(DateUtils.formatDate(record.getReponseTime(), "yyyy-MM-dd HH:mm:ss SSS"));
        }
        record.setRequestInput(record.getRequestInput());
        if (null != result) {
            try {
                record.setRequestOutput(JSON.toJSONString((Object)result));
            }
            catch (Exception e) {
                logger.error("\u51fa\u53c2\u8f6c\u6362\u5931\u8d25");
            }
        }
        WriteRestLogsThread thread = new WriteRestLogsThread();
        thread.addRequestRecordBO(record);
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(1);
        linkedBlockingQueue.add(thread);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WRITERESTLOGS-%d").build();
        ThreadPoolExecutor singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, linkedBlockingQueue, namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        singleThreadPool.execute(thread);
        singleThreadPool.shutdown();
    }

    private String delHtmlTags(String result) {
        if (result != null && !"".equals(result)) {
            String scriptRegex = "<script[^>]*?>[\\s\\S]*?<\\/script>";
            String scriptRegex1 = "(on\\w+=[\\s\\S]*?(>|&gt))";
            result = result.replaceAll(scriptRegex1, ">");
            result = result.replaceAll(scriptRegex, "");
            return result;
        }
        return null;
    }

    private Map<String, Class> getMethods(Object object) {
        Class<?> class1 = object.getClass();
        HashMap<String, Class> methodMap = new HashMap<String, Class>();
        Method[] ms = class1.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i].getName() == null || !ms[i].getName().startsWith("set")) continue;
            methodMap.put(ms[i].getName(), ms[i].getParameterTypes()[0]);
        }
        return methodMap;
    }

    private Object getResult(Object result) {
        if (result != null) {
            String resultStr = com.alibaba.fastjson.JSONObject.toJSONString((Object)result);
            logger.debug("\u503c\u8fc7\u6ee4\u524d\uff1a{}", (Object)resultStr);
            resultStr = this.delHtmlTags(resultStr);
            logger.debug("\u503c\u8fc7\u6ee4\u540e\uff1a{}", (Object)resultStr);
            com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)resultStr);
            if (o != null) {
                Map<String, Class> methodMap = this.getMethods(result);
                String method = null;
                Class clazz = null;
                for (Map.Entry entry : o.entrySet()) {
                    Field[] fields;
                    if (entry.getValue() == null) continue;
                    for (Field field : fields = result.getClass().getDeclaredFields()) {
                        if (!entry.getKey().equals(field.getName())) continue;
                        method = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                        try {
                            clazz = methodMap.get(method);
                            Method setMethod = result.getClass().getMethod(method, clazz);
                            if (entry.getValue() instanceof com.alibaba.fastjson.JSONObject) {
                                setMethod.invoke(result, com.alibaba.fastjson.JSONObject.toJavaObject((JSON)((com.alibaba.fastjson.JSONObject)entry.getValue()), (Class)clazz));
                                continue;
                            }
                            setMethod.invoke(result, clazz.cast(entry.getValue()));
                        }
                        catch (Exception e) {
                            logger.warn("\u53cd\u5c04set\u503c\u5f02\u5e38," + method);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        String url = "http://39.106.31.94:8080/rest/api/store/syncStoreInfo/v1";
        String str1 = "\"operID\": \"6350001023_1760\",\n    \"czType\": \"1\",\n    \"sgsID\": \"350000\",\n    \"sgsName\": \"\u798f\u5efa\u7701\",\n    \"dsgsID\": \"350100\",\n    \"dsgsName\": \"\u798f\u5dde\u5e02\",\n    \"mdID\": \"63500010232223\",\n    \"mdName\": \"\u798f\u5dde\u9ccc\u5cf0\u8def\u7cbe\u54c1\u5385\",\n    \"mdAddress\": \"\u798f\u5dde\u53f0\u6c5f\u5149\u660e\u8def2\u53f7\u6995\u6c5f\u65b0\u5929\u5730\u4e00\u5c4204\u53f7\u5e97\u9762\",\n    \"sfID\": \"350000\",\n    \"dsID\": \"\u798f\u5efa\u7701\",\n    \"mdlevel\": \"C\",\n    \"mdleader\": \"\u9648\u4ee3\u6c49\",\n    \"phone\": \"15060036007\",\n    \"manager\": \"\u962e\u82b3\u5c27\"";
        String str = "{\"HEAD\":{\"APP_ID\":\"APP3948371\",\"TIMESTAMP\":\"2018-09-04 11:30:36 771\",\"TRANS_ID\":\"1234\",\"TOKEN\":\"03a60f195386f80baf3c4aec2eefef23\",\"RESERVED\":[]},\"BODY\":{" + str1 + "},\"ATTACHED\":{\"MEDIA_INFO\":\"\"}}";
    }
}

