/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.tydic.newretail.util.PropertiesUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class RootRedirectController
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RootRedirectController.class);
    @Autowired
    private Properties propertiesFileLoader;
    private boolean isRedirect = false;
    private String redirectPath = "";

    @RequestMapping(value={"/"})
    public ModelAndView rootRedirect(HttpServletRequest request, HttpServletResponse response) {
        logger.info("isRedirect={}, redirectPath={}", (Object)this.isRedirect, (Object)this.redirectPath);
        ModelAndView mv = new ModelAndView("forward:/index");
        if (this.isRedirect) {
            mv.setViewName("redirect:" + this.redirectPath);
        }
        return mv;
    }

    @RequestMapping(value={"/index"})
    @ResponseBody
    public String indexPage(HttpServletRequest request, HttpServletResponse response) {
        logger.info("isRedirect={}, redirectPath={}", (Object)this.isRedirect, (Object)this.redirectPath);
        return "welcome service";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        PropertiesUtils.setPropertiesFileLoader(this.propertiesFileLoader);
        String isRedirectStr = PropertiesUtils.getProperty("root.redirect.enabled", "false").trim();
        this.isRedirect = Boolean.parseBoolean(isRedirectStr);
        this.redirectPath = PropertiesUtils.getProperty("root.redirect.path", "").trim();
    }
}

