/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.tydic.newretail.util.DateUtils;
import com.tydic.newretail.util.PropertiesUtils;
import com.tydic.newretail.util.TokenUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class TokenController {
    private static final Logger logger = LoggerFactory.getLogger(TokenController.class);

    @RequestMapping(value={"/tokenUtils"})
    @ResponseBody
    public String require(HttpServletRequest request) {
        String appId = request.getParameter("appId");
        String transId = request.getParameter("transId");
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)transId)) {
            return "{\"rsp\":\"\u5165\u53c2\u4e3a\u7a7a\"}";
        }
        String timeStamp = DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss SSS");
        String appSecret = PropertiesUtils.getProperty(appId);
        if (null == appSecret) {
            return "{\"rsp\":\"\u672a\u914d\u7f6eappId\u5bf9\u5e94\u7684appSecret\"}";
        }
        String token = TokenUtils.getToken(appId, timeStamp, transId, "[]", PropertiesUtils.getProperty(appId));
        String paramStr = "{\n \"HEAD\": {\n        \"APP_ID\": \"" + appId + "\",\n        \"TIMESTAMP\": \"" + timeStamp + "\",\n        \"TRANS_ID\": \"" + transId + "\",\n        \"TOKEN\": \"" + token + "\",\n        \"RESERVED\":[]\n    },\n\"BODY\":{}, \"ATTACHED\": {\n        \"MEDIA_INFO\": \"\"\n }\n}";
        logger.info("paramStr=" + paramStr);
        return paramStr;
    }

    @RequestMapping(value={"/rest/invoke/test"})
    @ResponseBody
    public String test(HttpServletRequest request) {
        return "test success";
    }
}

