/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.controller;

import com.alibaba.dubbo.common.utils.IOUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.tydic.newretail.bo.RequestBody;
import com.tydic.newretail.bo.RequestEntity;
import com.tydic.newretail.bo.RequestHeader;
import com.tydic.newretail.bo.WsMappingBO;
import com.tydic.newretail.controller.InitToConsumerXmlServlet;
import com.tydic.newretail.controller.ModifyHttpServletRequestWrapper;
import com.tydic.newretail.controller.RestController;
import com.tydic.newretail.util.ConvertParamsUtils;
import com.tydic.newretail.util.JaxbXmlUtil;
import com.tydic.newretail.util.PropertiesUtils;
import com.tydic.newretail.util.XmlUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/websoap"})
public class WsController
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(WsController.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    private Map<String, WsMappingBO> wsStore = new HashMap<String, WsMappingBO>();
    @Autowired
    private RestController restController;

    @RequestMapping(value={"/ws//**"}, produces={"text/xml;charset=UTF-8"})
    @ResponseBody
    public Object soapRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String service = null;
        StringBuffer requestUrl = request.getRequestURL();
        if (StringUtils.isBlank(service)) {
            service = ConvertParamsUtils.getServiceName(requestUrl.toString(), "ws/");
        }
        if (StringUtils.isBlank(service)) {
            return ConvertParamsUtils.getErrorRsp("9999", "\u8bf7\u6c42URL\u683c\u5f0f\u9519\u8bef");
        }
        String xmlContent = null;
        String returnXml = null;
        try {
            WsMappingBO ws;
            String ip = this.getIpAddress(request);
            if (isDebug.booleanValue()) {
                logger.debug("WebService\u8bf7\u6c42\u6765\u6e90ip:" + ip);
            }
            if (null != request.getReader()) {
                BufferedReader reader = request.getReader();
                xmlContent = IOUtils.read((Reader)reader);
                if (isDebug.booleanValue()) {
                    logger.debug("WebService\u8bf7\u6c42\u62a5\u6587xml:" + xmlContent);
                }
            }
            if (null == (ws = this.wsStore.get(service))) {
                logger.error("\u672a\u914d\u7f6e" + service + "\u7684\u8bf7\u6c42\uff01");
            }
            if (null != request.getQueryString() && "wsdl".equalsIgnoreCase(request.getQueryString())) {
                String wsdlAddr = ws.getWsdlAddr();
                if (StringUtils.isEmpty((CharSequence)wsdlAddr)) {
                    logger.error("\u672a\u914d\u7f6e" + service + "\u7684\u5165\u53c2\u8282\u70b9\u3010wsdl_addr\u3011\uff01");
                }
                wsdlAddr = PropertiesUtils.getProperty("OSS_ACCESS_URL") + PropertiesUtils.getProperty("OSS_WSDL_FILEPATH") + wsdlAddr;
                return wsdlAddr;
            }
            if (null != xmlContent) {
                String json = XmlUtils.xml2JSON(xmlContent);
                if (isDebug.booleanValue()) {
                    logger.debug("WebService\u8bf7\u6c42\u62a5\u6587" + json);
                }
                JSONObject paramJson = JSONObject.fromObject((Object)json);
                List<String> paramRootList = ws.getParamRoot();
                if (CollectionUtils.isEmpty(paramRootList)) {
                    logger.error("\u672a\u914d\u7f6e" + service + "\u7684\u5165\u53c2\u8282\u70b9\u3010ws_param_root\u3011\uff01");
                }
                for (String root : paramRootList) {
                    paramJson = (JSONObject)paramJson.get(root);
                }
                ModifyHttpServletRequestWrapper httpReq = new ModifyHttpServletRequestWrapper(request);
                String apiService = ws.getApiService();
                if (null == apiService) {
                    logger.error("\u672a\u914d\u7f6e" + service + "\u7684\u5185\u90e8\u8bf7\u6c42\u8282\u70b9\u3010apiService\u3011\uff01");
                }
                long start = System.currentTimeMillis();
                Object obj = this.restController.invoke((HttpServletRequest)httpReq, response, paramJson.toString(), apiService, null);
                long end = System.currentTimeMillis();
                logger.info("\u8bf7\u6c42\u670d\u52a1" + service + "\u8fd4\u56de\uff1a " + obj.toString());
                logger.info("\u8bf7\u6c42\u670d\u52a1" + service + "\u8017\u65f6\uff1a " + (end - start));
                RequestEntity entity = new RequestEntity(new RequestHeader());
                RequestBody body = new RequestBody();
                body.setResp(obj);
                entity.setBody(body);
                returnXml = JaxbXmlUtil.convertToXml(entity);
            }
            logger.info("\u8bf7\u6c42\u670d\u52a1" + service + "\u8fd4\u56de\uff1a " + returnXml);
            return returnXml;
        }
        catch (Exception e) {
            logger.error("\u5916\u90e8\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
            RequestEntity entity = new RequestEntity(new RequestHeader());
            RequestBody body = new RequestBody();
            body.setResp(null);
            entity.setBody(body);
            returnXml = JaxbXmlUtil.convertToXml(entity);
            return returnXml;
        }
    }

    private String getIpAddress(HttpServletRequest request) throws IOException {
        String ip;
        block13: {
            block12: {
                ip = request.getHeader("X-Forwarded-For");
                if (logger.isDebugEnabled()) {
                    logger.debug("getIpAddress(HttpServletRequest) - X-Forwarded-For - String ip=" + ip);
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block12;
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                    if (isDebug.booleanValue()) {
                        logger.debug("getIpAddress(HttpServletRequest) - Proxy-Client-IP - String ip=" + ip);
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                    if (isDebug.booleanValue()) {
                        logger.debug("getIpAddress(HttpServletRequest) - WL-Proxy-Client-IP - String ip=" + ip);
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                    if (logger.isInfoEnabled()) {
                        logger.debug("getIpAddress(HttpServletRequest) - HTTP_CLIENT_IP - String ip=" + ip);
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                    if (isDebug.booleanValue()) {
                        logger.debug("getIpAddress(HttpServletRequest) - HTTP_X_FORWARDED_FOR - String ip=" + ip);
                    }
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block13;
                ip = request.getRemoteAddr();
                if (isDebug.booleanValue()) {
                    logger.debug("getIpAddress(HttpServletRequest) - getRemoteAddr - String ip=" + ip);
                }
                break block13;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            JsonNode initWsJson = InitToConsumerXmlServlet.getInitWsJson();
            Iterator beanWsList = null;
            if (null != initWsJson) {
                beanWsList = initWsJson.elements();
            }
            while (null != beanWsList && beanWsList.hasNext()) {
                JsonNode bean = (JsonNode)beanWsList.next();
                String apiService = bean.get("apiservice").asText();
                String wsReqRoot = bean.get("ws_req_service").asText();
                String wsParamRoot = bean.get("ws_param_root").asText();
                String wsdlAddr = bean.get("wsdl_addr").asText();
                String[] paramArr = wsParamRoot.split(";");
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(paramArr));
                WsMappingBO ws = new WsMappingBO();
                ws.setApiService(apiService);
                ws.setParamRoot(arrayList);
                ws.setWsReqRoot(wsReqRoot);
                ws.setWsdlAddr(wsdlAddr);
                this.wsStore.put(wsReqRoot, ws);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init ws service error:", e);
        }
    }
}

