/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.util.RSAUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TokenFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TokenFilter.class);
    private List<String> excludedUris = new ArrayList<String>();
    private CacheClient cacheClient;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        this.cacheClient = (CacheClient)context.getBean(CacheClient.class);
        String uris = filterConfig.getInitParameter("exclude");
        if (uris != null) {
            String[] excludeUri = uris.split(";");
            for (int i = 0; i != excludeUri.length; ++i) {
                this.excludedUris.add(excludeUri[i]);
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse rep = (HttpServletResponse)servletResponse;
        if (this.isContains(req.getRequestURI())) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)rep);
            return;
        }
        if (!this.canAccess(req)) {
            HashMap<String, String> rMap = new HashMap<String, String>();
            rMap.put("code", "401");
            rMap.put("message", "\u7528\u6237\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u9646!");
            PrintWriter printWriter = rep.getWriter();
            rep.setContentType("application/json");
            rep.setCharacterEncoding("utf-8");
            System.out.println(JSON.toJSONString(rMap));
            printWriter.write(JSON.toJSONString(rMap));
            printWriter.flush();
            return;
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)rep);
    }

    private boolean canAccess(HttpServletRequest req) {
        try {
            String token = req.getHeader("cas-x-token");
            if (token != null && !"".equals(token) && !"null".equals(token)) {
                System.out.println("token si:" + token);
                String realToken = RSAUtils.defaultDecrypt(token);
                System.out.println("real token is :{}" + realToken);
                String[] t = realToken.split("\\|");
                String userId = t[0];
                if (this.cacheClient.get(userId) != null) {
                    String rv = this.cacheClient.get(userId).toString();
                    JSONObject rmap = JSON.parseObject((String)rv);
                    System.out.println("redis is:{}" + rmap.toString());
                    String cacheToken = rmap.get("token").toString();
                    if (token.equals(cacheToken)) {
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bf7\u6c42token\u6821\u9a8c\u5931\u8d25,\u8bf7\u6c42url\u4e3a:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)req.getRequestURL(), (Object)e.getMessage());
        }
        return false;
    }

    private boolean isContains(String uri) {
        if (uri.contains(".")) {
            return true;
        }
        for (String excludedUri : this.excludedUris) {
            if (!uri.contains(excludedUri)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

