/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.thread;

import com.tydic.newretail.bo.RequestRecordBO;
import com.tydic.newretail.util.DateUtils;
import com.tydic.newretail.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class WriteRestLogsThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WriteRestLogsThread.class);
    private static final String LOGS_FILE_NAME = "restcontroller";
    private static final String LOGS_FILE_SUFFIX = ".out";
    private static final String LOGS_FILE_BAK_SUFFIX = ".log";
    private RequestRecordBO recordBO;

    public void addRequestRecordBO(RequestRecordBO record) {
        this.recordBO = record;
    }

    @Override
    public void run() {
        File file;
        if (null == this.recordBO) {
            return;
        }
        String path = System.getProperty("catalina.home") + File.separator + "logs";
        try {
            file = this.mkdir(path);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return;
        }
        try {
            String createDate = DateUtils.formatDate(FileUtils.getCreateTime(file.getPath()), "yyyy-MM-dd");
            String lastDate = DateUtils.formatDate(org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)-1), "yyyy-MM-dd");
            if (createDate.equals(lastDate)) {
                String backupPath = path + File.separator + LOGS_FILE_NAME + LOGS_FILE_BAK_SUFFIX + "." + lastDate;
                File backupFile = new File(backupPath);
                if (!backupFile.exists()) {
                    backupFile.createNewFile();
                }
                FileCopyUtils.copy((File)file, (File)backupFile);
                file.delete();
                file = this.mkdir(path);
            }
        }
        catch (IOException e) {
            logger.error("\u521b\u5efa\u65e5\u5fd7\u5907\u4efd\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
        }
        String dateStr = DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss SSS");
        StringBuffer str = new StringBuffer();
        str.append(dateStr).append("\n").append(this.recordBO.toString());
        FileUtils.appendFile(file.getPath(), str.toString());
    }

    private File mkdir(String path) throws IOException {
        String logsFile;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(logsFile = path + File.separator + LOGS_FILE_NAME + LOGS_FILE_SUFFIX)).exists()) {
            file.createNewFile();
        }
        return file;
    }
}

