/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util;

import com.tydic.newretail.util.DateUtils;
import com.tydic.newretail.util.JsonDateValueProcessor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.DefaultDefaultValueProcessor;
import net.sf.json.processors.DefaultValueProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.lang3.StringUtils;

public class ConvertParamsUtils {
    private static Pattern STR_PATTERN = Pattern.compile("[A-Z]([a-z\\d]+)?");

    public static String convertToString(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder result = new StringBuilder();
        String line = null;
        boolean readFlag = true;
        try {
            do {
                if (StringUtils.isNotBlank((CharSequence)(line = bufferedReader.readLine()))) {
                    result.append(line);
                    continue;
                }
                readFlag = false;
            } while (readFlag);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                inputStreamReader.close();
                inputStream.close();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public static String convertToString(FileInputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder result = new StringBuilder();
        String line = null;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                inputStreamReader.close();
                inputStream.close();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public static String convertToStringNull(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder result = new StringBuilder();
        String line = null;
        boolean readFlag = true;
        try {
            do {
                if ((line = bufferedReader.readLine()) != null) {
                    result.append(line + "\n");
                    continue;
                }
                readFlag = false;
            } while (readFlag);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                inputStreamReader.close();
                inputStream.close();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public static JSONObject transJsonParams(String json, boolean isCamel) {
        JSONObject jSONArray2 = new JSONObject();
        JSONObject jSONArray1 = JSONObject.fromObject((Object)json);
        if (null == jSONArray1 || jSONArray1.size() <= 0) {
            return jSONArray1;
        }
        Iterator it = jSONArray1.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object object = jSONArray1.get(key);
            boolean isLower = false;
            char c = key.charAt(0);
            if (Character.isLowerCase(c)) {
                isLower = true;
            }
            if (object.getClass().toString().endsWith("JSONObject")) {
                if (isCamel) {
                    if (isLower) {
                        jSONArray2.accumulate(ConvertParamsUtils.camel2Underline(key), (Object)ConvertParamsUtils.transJsonParams(object.toString(), true));
                        continue;
                    }
                    jSONArray2.accumulate(key, (Object)ConvertParamsUtils.transJsonParams(object.toString(), true));
                    continue;
                }
                if (isLower) {
                    jSONArray2.accumulate(key, (Object)ConvertParamsUtils.transJsonParams(object.toString(), false));
                    continue;
                }
                jSONArray2.accumulate(ConvertParamsUtils.underlineToCamel(key), (Object)ConvertParamsUtils.transJsonParams(object.toString(), false));
                continue;
            }
            if (object.getClass().toString().endsWith("JSONArray")) {
                if (isCamel) {
                    if (isLower) {
                        jSONArray2.accumulate(ConvertParamsUtils.camel2Underline(key), (Object)ConvertParamsUtils.transJsonArrayParams(jSONArray1.getJSONArray(key).toString(), isCamel));
                        continue;
                    }
                    jSONArray2.accumulate(key, (Object)ConvertParamsUtils.transJsonArrayParams(jSONArray1.getJSONArray(key).toString(), isCamel));
                    continue;
                }
                if (isLower) {
                    jSONArray2.accumulate(key, (Object)ConvertParamsUtils.transJsonArrayParams(jSONArray1.getJSONArray(key).toString(), isCamel));
                    continue;
                }
                jSONArray2.accumulate(ConvertParamsUtils.underlineToCamel(key), (Object)ConvertParamsUtils.transJsonArrayParams(jSONArray1.getJSONArray(key).toString(), isCamel));
                continue;
            }
            if (isCamel) {
                if (isLower) {
                    jSONArray2.accumulate(ConvertParamsUtils.camel2Underline(key), object);
                    continue;
                }
                jSONArray2.accumulate(key, object);
                continue;
            }
            if (isLower) {
                jSONArray2.accumulate(key, object);
                continue;
            }
            jSONArray2.accumulate(ConvertParamsUtils.underlineToCamel(key), object);
        }
        return jSONArray2;
    }

    public static JSONArray transJsonArrayParams(String jsonArray, boolean isReq) {
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray1 = JSONArray.fromObject((Object)jsonArray);
        for (int i = 0; i < jSONArray1.size(); ++i) {
            Object jArray = jSONArray1.get(i);
            if (jArray.getClass().toString().endsWith("JSONObject")) {
                JSONObject json = ConvertParamsUtils.transJsonParams(jArray.toString(), isReq);
                if (null == json || json.size() <= 0) continue;
                jSONArray2.add((Object)json);
                continue;
            }
            if (jArray.getClass().toString().endsWith("JSONArray")) {
                jSONArray2.add((Object)ConvertParamsUtils.transJsonArrayParams(jArray.toString(), isReq));
                continue;
            }
            jSONArray2.add(jArray);
        }
        return jSONArray2;
    }

    public static String underlineToCamel(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.toLowerCase();
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
                continue;
            }
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String camel2Underline(String line) {
        if (line == null || "".equals(line)) {
            return "";
        }
        line = String.valueOf(line.charAt(0)).toUpperCase().concat(line.substring(1));
        StringBuffer sb = new StringBuffer();
        Matcher matcher = STR_PATTERN.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(word.toUpperCase());
            sb.append(matcher.end() == line.length() ? "" : "_");
        }
        return sb.toString();
    }

    public static JSONObject getRspStr(String transId, JSONArray reserved, String apiName, JSONObject attached, Object busiRsp, String appId, JSONObject apiRsp) {
        JSONObject jsonTemp = null;
        if (null != busiRsp) {
            jsonTemp = new JSONObject();
            try {
                JSONObject objJson = JSONObject.fromObject((Object)busiRsp, (JsonConfig)ConvertParamsUtils.getConfig());
                jsonTemp.put((Object)"BODY", (Object)objJson);
            }
            catch (Exception e) {
                jsonTemp.put((Object)"BODY", busiRsp);
            }
        }
        String timeStamp = DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss SSS");
        StringBuilder rsp = new StringBuilder();
        rsp.append("{\"HEAD\": {").append("\"APP_ID\":").append("\"" + appId + "\",").append("\"TIMESTAMP\":").append("\"" + timeStamp + "\",").append("\"TRANS_ID\":").append("\"" + transId + "\",").append("\"" + ConvertParamsUtils.camel2Underline("code") + "\":").append("\"" + apiRsp.getString("code").replace("GATEWAY_", "") + "\",").append("\"" + ConvertParamsUtils.camel2Underline("message") + "\":").append("\"" + apiRsp.getString("message") + "\",").append("\"RESERVED\":").append(reserved.toString()).append("},");
        String body = "\"BODY\": {}";
        if (null != jsonTemp) {
            String bodyStr = jsonTemp.toString();
            if (bodyStr.startsWith("{")) {
                bodyStr = bodyStr.substring(1, bodyStr.length());
            }
            if (bodyStr.endsWith("}")) {
                bodyStr = bodyStr.substring(0, bodyStr.length() - 1);
            }
            body = bodyStr;
        }
        rsp.append(body).append(",").append("\"ATTACHED\": ").append(attached.toString()).append("}");
        return JSONObject.fromObject((Object)rsp.toString());
    }

    public static String encode(String str) {
        String strDigest = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] data = md5.digest(str.getBytes("utf-8"));
            strDigest = ConvertParamsUtils.bytesToHexString(data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return strDigest;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getServiceName(String url, String uri) {
        int index = url.lastIndexOf(uri) + uri.length();
        if (url.lastIndexOf(uri) < 0 || index == url.length()) {
            return null;
        }
        String service = url.substring(index, url.length());
        return service;
    }

    public static JSONObject getErrorRsp(String respCode, String respDesc) {
        JSONObject result = new JSONObject();
        result.put((Object)"code", (Object)respCode);
        result.put((Object)"message", (Object)respDesc);
        return result;
    }

    public static JsonConfig getConfig() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerDefaultValueProcessor(Double.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Long.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Integer.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Integer.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return null == value;
            }
        });
        jsonConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonDateValueProcessor());
        return jsonConfig;
    }

    public static void main(String[] args) {
        JSONObject json = new JSONObject();
        JSONObject body = new JSONObject();
        body.put((Object)"test", (Object)"test");
        json.put((Object)"BODY", (Object)"123");
        String bodyStr = json.toString();
        if (bodyStr.startsWith("{")) {
            bodyStr = bodyStr.substring(1, bodyStr.length());
        }
        if (bodyStr.endsWith("}")) {
            bodyStr = bodyStr.substring(0, bodyStr.length() - 1);
        }
        System.out.println(bodyStr);
    }
}

