/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util;

import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PropertiesUtils {
    private static TreeMap treeMap = new TreeMap();
    private static Properties propertiesFileLoader;

    public static void setPropertiesFileLoader(Properties propertiesFileLoader) {
        PropertiesUtils.propertiesFileLoader = propertiesFileLoader;
    }

    public static void init(Properties propertiesFileLoader) {
        if (propertiesFileLoader != null) {
            PropertiesUtils.propertiesFileLoader = propertiesFileLoader;
        }
        if (propertiesFileLoader != null) {
            propertiesFileLoader.entrySet().stream().forEach(e -> treeMap.put(e.getKey(), e.getValue()));
        }
    }

    public static String getProperty(String key) {
        if (!treeMap.containsKey(key)) {
            PropertiesUtils.init(propertiesFileLoader);
        }
        return null == treeMap.get(key) ? null : String.valueOf(treeMap.get(key)).trim();
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value;
    }

    public static Long getLongProperty(String key) {
        String value = PropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    public static Long getLongProperty(String key, Long defaultValue) {
        Long value = PropertiesUtils.getLongProperty(key);
        return null == value ? defaultValue : value;
    }

    public static Integer getIntProperty(String key) {
        String value = PropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static Integer getIntProperty(String key, Integer defaultValue) {
        Integer value = PropertiesUtils.getIntProperty(key);
        return null == value ? defaultValue : value;
    }

    public static Boolean getBooleanProperty(String key) {
        String value = PropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static Boolean getBooleanProperty(String key, Boolean defaultValue) {
        Boolean value = PropertiesUtils.getBooleanProperty(key);
        return null == value ? defaultValue : value;
    }
}

