/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public final class StringUtil {
    private static final char START_SEP_1 = '$';
    private static final char START_SEP_2 = '{';
    private static final char STOP_SEP_1 = '}';
    private static final ThreadLocal<ObjectMapper> OBJECT_MAPPER_THREAD_LOCAL = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };

    public static String parseParameterText(String origin, Object javaBean) {
        Properties params;
        ObjectMapper objectMapper = OBJECT_MAPPER_THREAD_LOCAL.get();
        try {
            params = (Properties)objectMapper.readValue(objectMapper.writeValueAsString(javaBean), Properties.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("parseParameterText for javaBean error", e);
        }
        return StringUtil.parseParameterText(origin, params, null);
    }

    public static String parseParameterText(String origin, Properties params) {
        return StringUtil.parseParameterText(origin, params, null);
    }

    public static String parseParameterText(String origin, Properties params, List<String> keys) {
        return StringUtil.getParameteredText(origin, params, null, keys);
    }

    public static String parseParameterText(String origin, String ... args) {
        return StringUtil.getParameteredText(origin, null, args, null);
    }

    private static String getParameteredText(String origin, Properties argsStore, String[] args, List<String> keys) {
        if (argsStore == null) {
            argsStore = new Properties();
        }
        for (int i = 0; args != null && i < args.length; ++i) {
            argsStore.setProperty(Integer.toString(i), args[i]);
        }
        int len = origin.length();
        int status = 0;
        StringBuilder key = new StringBuilder();
        StringBuilder parsedText = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char value = origin.charAt(i);
            if (value == '$') {
                if (status == 1) {
                    parsedText.append('$');
                    key.delete(0, key.length());
                } else if (status == 2) {
                    parsedText.append('$').append('{');
                    key.delete(0, key.length());
                }
                status = 1;
                continue;
            }
            if (status == 1) {
                if (value == '{') {
                    status = 2;
                    continue;
                }
                status = 0;
                parsedText.append('$').append(value);
            }
            if (status == 2) {
                if (value == '}') {
                    status = 0;
                    String localKey = key.toString();
                    key.delete(0, key.length());
                    if (keys != null) {
                        keys.add(localKey);
                    }
                    if (!argsStore.containsKey(localKey)) {
                        throw new IllegalArgumentException("EL expression[${" + localKey + '}' + "] not exists in " + argsStore + ".");
                    }
                    parsedText.append(argsStore.getProperty(localKey));
                    continue;
                }
                key.append(value);
                continue;
            }
            parsedText.append(value);
        }
        if (key.length() != 0) {
            if (status == 1) {
                parsedText.append('$');
            } else if (status == 2) {
                parsedText.append('$').append('{');
            }
            parsedText.append(key.toString());
        }
        return parsedText.toString();
    }
}

