/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static String getToken(String appId, String timeStamp, String transId, String reserved, String appSecret) {
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)timeStamp) || StringUtils.isBlank((CharSequence)transId) || StringUtils.isBlank((CharSequence)appSecret)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5165\u53c2\u4e3a\u7a7a");
        }
        String token = null;
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("APP_ID", appId);
        paramsMap.put("TIMESTAMP", timeStamp);
        paramsMap.put("TRANS_ID", transId);
        String params = TokenUtils.sortMapByASCII(paramsMap);
        params = params + appSecret;
        token = TokenUtils.MD5(params);
        return token;
    }

    private static String sortMapByASCII(Map<String, String> paramsMap) {
        if (MapUtils.isEmpty(paramsMap)) {
            return null;
        }
        String params = "";
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(paramsMap.entrySet());
        try {
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
        }
        catch (Exception e) {
            log.error("\u6392\u5e8f\u5931\u8d25" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        for (Map.Entry entry : infoIds) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            params = params + (String)entry.getKey() + (String)entry.getValue();
        }
        return params;
    }

    private static String MD5(String str) {
        String result = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes("UTF-8"));
            byte[] b = md5.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

