/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util.fastdfs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDFSHelper {
    private static final Logger logger = LoggerFactory.getLogger(FastDFSHelper.class);
    private static TrackerClient trackerClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(FileItem fileItem) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        InputStream fis = null;
        try {
            String fileid;
            fis = fileItem.getInputStream();
            NameValuePair[] meta_list = null;
            byte[] file_buff = null;
            if (fis != null) {
                int len = fis.available();
                file_buff = new byte[len];
                fis.read(file_buff);
            }
            if ((trackerServer = trackerClient.getConnection()) == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            String string = fileid = storageClient1.upload_file1(file_buff, FastDFSHelper.getFileExt(fileItem.getName()), meta_list);
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                }
            }
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(File file, String path) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        FileInputStream fis = null;
        try {
            String fileid;
            NameValuePair[] meta_list = null;
            fis = new FileInputStream(file);
            byte[] file_buff = null;
            if (fis != null) {
                int len = fis.available();
                file_buff = new byte[len];
                fis.read(file_buff);
            }
            if ((trackerServer = trackerClient.getConnection()) == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            String string = fileid = storageClient1.upload_file1(file_buff, FastDFSHelper.getFileExt(path), meta_list);
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                }
            }
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(byte[] data, String extName) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        try {
            String fileid;
            NameValuePair[] meta_list = null;
            trackerServer = trackerClient.getConnection();
            if (trackerServer == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            String string = fileid = storageClient1.upload_file1(data, extName, meta_list);
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream download(String fileId) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        String groupName = "group1";
        try {
            ByteArrayInputStream inputStream;
            trackerServer = trackerClient.getConnection();
            if (trackerServer == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer, groupName);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            byte[] bytes = storageClient1.download_file1(fileId);
            ByteArrayInputStream byteArrayInputStream = inputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream download(String groupName, String fileId) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        try {
            ByteArrayInputStream inputStream;
            trackerServer = trackerClient.getConnection();
            if (trackerServer == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer, groupName);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            byte[] bytes = storageClient1.download_file1(fileId);
            ByteArrayInputStream byteArrayInputStream = inputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delete(String groupName, String fileId) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        try {
            int result;
            trackerServer = trackerClient.getConnection();
            if (trackerServer == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer, groupName);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            int n = result = storageClient1.delete_file1(fileId);
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            int n = 0;
            return n;
        }
        finally {
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delete(String fileId) {
        TrackerServer trackerServer = null;
        StorageServer storageServer = null;
        StorageClient1 storageClient1 = null;
        String groupName = "group1";
        try {
            int result;
            trackerServer = trackerClient.getConnection();
            if (trackerServer == null) {
                logger.error("getConnection return null");
            }
            storageServer = trackerClient.getStoreStorage(trackerServer, groupName);
            storageClient1 = new StorageClient1(trackerServer, storageServer);
            int n = result = storageClient1.delete_file1(fileId);
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            int n = 0;
            return n;
        }
        finally {
            if (storageServer != null) {
                try {
                    storageServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackerServer != null) {
                try {
                    trackerServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            storageClient1 = null;
        }
    }

    public static String modify(String oldGroupName, String oldFileId, File file, String path) {
        String fileid = null;
        try {
            fileid = FastDFSHelper.upload(file, path);
            if (fileid == null) {
                return null;
            }
            int delResult = FastDFSHelper.delete(oldGroupName, oldFileId);
            if (delResult != 0) {
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            return null;
        }
        return fileid;
    }

    private static String getFileExt(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName) || !fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static void testUpload() throws Exception {
        String path = "C:\\ttest\\12.jpg";
        File file = new File(path);
        String fileId = FastDFSHelper.upload(file, path);
        System.out.println("\u672c\u5730\u6587\u4ef6\uff1a" + path + "\uff0c\u4e0a\u4f20\u6210\u529f\uff01 \u6587\u4ef6ID\u4e3a\uff1a" + fileId);
    }

    public static void testDownLoad() throws Exception {
        String fileId = "group1/M00/00/00/wKgKcl7pvAWAQiwrAAPy_UsFAeE336.jpg";
        InputStream inputStream = FastDFSHelper.download("group1", fileId);
        if (inputStream == null) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728!");
            return;
        }
        System.out.println(inputStream.available());
        String path = "C:\\ttest\\mtt.jpg";
        System.out.println(path);
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(path));
    }

    public static void testDel() throws Exception {
        String fileId = "group1/M00/00/00/wKgKcl7pvAWAQiwrAAPy_UsFAeE336.jpg";
        int result = FastDFSHelper.delete("group1", fileId);
        System.out.println(result == 0 ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25:" + result);
    }

    static {
        String conf = Thread.currentThread().getContextClassLoader().getResource("fdfs_client.conf").getPath();
        System.out.println(conf);
        try {
            ClientGlobal.init((String)conf);
            trackerClient = new TrackerClient();
        }
        catch (IOException | MyException e) {
            e.printStackTrace();
            logger.error("FastDFS init Error", e);
        }
    }
}

