/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.tydic.newretail.bo.FileBO;
import com.tydic.newretail.util.PropertiesUtils;
import com.tydic.newretail.util.oss.OssConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class OssFileUtils
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(OssFileUtils.class);
    private static String endpoint;
    private static String downEndpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String accessUrl;
    private static OssConfig ossConfig;
    private static OssConfig downloadOssConfig;
    @Autowired
    private Properties propertiesFileLoader;

    public void init() {
        endpoint = PropertiesUtils.getProperty("OSS_ENDPOINT", "").trim();
        downEndpoint = PropertiesUtils.getProperty("OSS_DOWNLOAD_ENDPOINT", "").trim();
        accessKeyId = PropertiesUtils.getProperty("OSS_ACCESSKEY", "").trim();
        accessKeySecret = PropertiesUtils.getProperty("OSS_ACCESSKEY_SECRET", "").trim();
        bucketName = PropertiesUtils.getProperty("OSS_BUCKETNAME", "").trim();
        accessUrl = PropertiesUtils.getProperty("OSS_ACCESS_URL", "").trim();
        if (StringUtils.isNotBlank((CharSequence)endpoint) && StringUtils.isNotBlank((CharSequence)accessKeyId) && StringUtils.isNotBlank((CharSequence)accessKeySecret) && StringUtils.isNotBlank((CharSequence)accessUrl)) {
            ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)downEndpoint) && StringUtils.isNotBlank((CharSequence)accessKeyId) && StringUtils.isNotBlank((CharSequence)accessKeySecret)) {
            downloadOssConfig = new OssConfig(downEndpoint, accessKeyId, accessKeySecret);
        }
    }

    public static OssConfig getUploadOssConfig() {
        return ossConfig;
    }

    public static OssConfig getDownloadOssConfig() {
        return downloadOssConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OSSObjectSummary> listFiles(String filePath, Boolean readSubFile, OssConfig ossConfig) {
        List sums = new ArrayList();
        OSSClient ossClient = OssFileUtils.getOssclient(ossConfig);
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(ossConfig.getBucketName());
            if (!readSubFile.booleanValue()) {
                listObjectsRequest.setDelimiter("/");
            }
            if (!filePath.startsWith("/")) {
                filePath = "/" + filePath;
            }
            if (!filePath.endsWith("/")) {
                filePath = filePath + "/";
            }
            listObjectsRequest.setPrefix(bucketName + filePath);
            ObjectListing objectListing = ossClient.listObjects(listObjectsRequest);
            sums = objectListing.getObjectSummaries();
        }
        catch (OSSException var7) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
        }
        catch (ClientException var8) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
        }
        catch (Exception E) {
            log.error(E.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return sums;
    }

    public static void uploadFileToPath(File file, String uploadPath, OssConfig ossConfig) {
        if (uploadPath.startsWith("/")) {
            uploadPath = uploadPath.substring(1, uploadPath.length());
        }
        if (null == ossConfig) {
            ossConfig = OssFileUtils.ossConfig;
        }
        OssFileUtils.uploadFilePubMethod(file, uploadPath, ossConfig);
    }

    public static File downloadFileFromPath(String filePath, OssConfig ossConfig, boolean reName) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1, filePath.length());
        }
        if (null == ossConfig) {
            ossConfig = downloadOssConfig;
        }
        return OssFileUtils.downloadFilePubMethod(filePath, ossConfig, reName);
    }

    private static File downloadFilePubMethod(String filePath, OssConfig ossConfig, boolean reName) {
        OSSClient ossClient = OssFileUtils.getOssclient(ossConfig);
        String dir = System.getProperty("java.io.tmpdir");
        File dirFile = null;
        dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        if (reName) {
            fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        }
        dir = dir + File.separator + fileName;
        dirFile = new File(dir);
        try {
            ossClient.getObject(new GetObjectRequest(bucketName, filePath), dirFile);
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + bucketName + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return dirFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFilePubMethod(File file, String uploadPath, OssConfig ossConfig) {
        OSSClient ossClient = OssFileUtils.getOssclient(ossConfig);
        String fileName = file.getName();
        FileInputStream content = null;
        try {
            content = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            ossClient.putObject(bucketName, uploadPath + fileName, (InputStream)content, meta);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("\u68c0\u67e5\u6587\u4ef6\u3010" + fileName + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
        finally {
            try {
                if (null != content) {
                    ((InputStream)content).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public static OSSClient getOssclient(OssConfig ossConfig) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setSupportCname(true);
        OSSClient ossClient = new OSSClient(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), conf);
        return ossClient;
    }

    public static File downLoadZipFile(List<FileBO> fileList, String zipName, OssConfig ossConfig) throws IOException {
        if (null == ossConfig) {
            ossConfig = downloadOssConfig;
        }
        OSSClient ossClient = OssFileUtils.getOssclient(ossConfig);
        File zipFile = File.createTempFile("test", ".zip");
        try {
            FileOutputStream f = new FileOutputStream(zipFile);
            CheckedOutputStream csum = new CheckedOutputStream(f, new Adler32());
            ZipOutputStream zos = new ZipOutputStream(csum);
            for (FileBO fileBO : fileList) {
                OSSObject ossObject = ossClient.getObject(bucketName, fileBO.getFilePath());
                InputStream inputStream = ossObject.getObjectContent();
                String prex = fileBO.getFilePath().substring(fileBO.getFilePath().lastIndexOf("."), fileBO.getFilePath().length());
                zos.putNextEntry(new ZipEntry(fileBO.getFileName() + prex));
                int bytesRead = 0;
                while ((bytesRead = inputStream.read()) != -1) {
                    zos.write(bytesRead);
                }
                inputStream.close();
                zos.closeEntry();
            }
            zos.close();
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u6279\u91cf\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519:", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return zipFile;
    }

    public static void main(String[] args) {
        downEndpoint = "http://10.124.146.61/test-gdhb-file-gd";
        endpoint = "http://develop.unicom.local/test-gdhb-file-gd";
        accessKeyId = "UK8Db3KCYuRUZN9z";
        accessKeySecret = "Oc95AjgzW1twNC9qKZyVKbgWpx4qrc";
        bucketName = "test-gdhb-file-gd";
        downloadOssConfig = new OssConfig(downEndpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        System.out.println("Spring\u5bb9\u5668\u52a0\u8f7d\u5b8c\u6210\u89e6\u53d1,\u53ef\u7528\u4e8e\u521d\u59cb\u5316\u73af\u5883\uff0c\u51c6\u5907\u6d4b\u8bd5\u6570\u636e\u3001\u52a0\u8f7d\u4e00\u4e9b\u6570\u636e\u5230\u5185\u5b58");
        PropertiesUtils.setPropertiesFileLoader(this.propertiesFileLoader);
        this.init();
    }
}

