package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题：AgrSupplierCatalogBO
 * 说明：协议合作类目正式表
 * 时间：2024/10/10 11:22
 *
 * @author 周钰焱
 */
@Data
public class AgrSupplierCatalogBO implements Serializable {
    private static final long serialVersionUID = -7117545274107354996L;
    /**
     * 主键ID
     */
    private Long id;
    /**
     * 协议id
     */
    private Long agrId;
    /**
     * 合同编号（企业协议编号）
     */
    private String enAgrCode;
    /**
     * 协议编码
     */
    private String agrCode;
    /**
     * 一级类目ID
     */
    private Long oneCatalogId;
    /**
     * 一级类目名称
     */
    private String oneCatalogName;
    /**
     * 一级类目编码
     */
    private String oneCatalogCode;
    /**
     * 二级类目ID
     */
    private Long twoCatalogId;
    /**
     * 二级类目名称
     */
    private String twoCatalogName;
    /**
     * 二级类目编码
     */
    private String twoCatalogCode;
    /**
     * 三级类目ID
     */
    private Long threeCatalogId;
    /**
     * 三级类目名称
     */
    private String threeCatalogName;
    /**
     * 三级类目编码
     */
    private String threeCatalogCode;
    /**
     * 四级类目ID
     */
    private Long fourCatalogId;
    /**
     * 四级类目名称
     */
    private String fourCatalogName;
    /**
     * 四级类目编码
     */
    private String fourCatalogCode;
    /**
     * 成交服务费
     */
    private BigDecimal serviceFee;
    /**
     * 创建者
     */
    private Long createUserId;
    /**
     * 创建者名称
     */
    private String createUserName;
    /**
     * 创建机构id
     */
    private Long createOrgId;
    /**
     * 创建机构名称
     */
    private String createOrgName;
    /**
     * 创建公司id
     */
    private Long createCompanyId;
    /**
     * 创建公司名称
     */
    private String createCompanyName;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 更新者
     */
    private Long updateUserId;
    /**
     * 修改者名称
     */
    private String updateUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 0 正常　1 删除
     */
    private Integer delFlag;
    /**
     * 排序
     */
    private String orderBy;
    private List<AgrSupplierCatalogTempBO> children = new ArrayList<>(); // 子节点列表
}
