package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题：AgrSupplierCatalogTempBO
 * 说明：合作类目临时表temp
 * 时间：2024/10/9 15:17
 *
 * @author 周钰焱
 */
@Data
public class AgrSupplierCatalogTempBO implements Serializable {

    private static final long serialVersionUID = -5001587478016328496L;
    /**
     * 主键ID
     */
    private Long id;
    /**
     * 协议id
     */
    private Long agrId;
    /**
     * 协议编码
     */
    private String agrCode;
    /**
     * 来源类型1协议新增2协议变更
     */
    private Integer sourceType;
    /**
     * 一级类目ID
     */
    private Long oneCatalogId;
    /**
     * 一级类目名称
     */
    private String oneCatalogName;
    /**
     * 二级类目ID
     */
    private Long twoCatalogId;
    /**
     * 二级类目名称
     */
    private String twoCatalogName;
    /**
     * 三级类目ID
     */
    private Long threeCatalogId;
    /**
     * 三级类目名称
     */
    private String threeCatalogName;
    /**
     * 四级类目ID
     */
    private Long fourCatalogId;
    /**
     * 四级类目名称
     */
    private String fourCatalogName;
    /**
     * 成交服务费
     */
    private BigDecimal serviceFee;
    /**
     * 创建者
     */
    private Long createUserId;
    /**
     * 创建者名称
     */
    private String createUserName;
    /**
     * 创建机构id
     */
    private Long createOrgId;
    /**
     * 创建机构名称
     */
    private String createOrgName;
    /**
     * 创建公司id
     */
    private Long createCompanyId;
    /**
     * 创建公司名称
     */
    private String createCompanyName;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 更新者
     */
    private Long updateUserId;
    /**
     * 修改者名称
     */
    private String updateUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 0 正常　1 删除
     */
    private Integer delFlag;
    /**
     * 排序
     */
    private String orderBy;
    private List<AgrSupplierCatalogTempBO> children = new ArrayList<>(); // 子节点列表
}
