package com.tydic.utils.npc.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 标题：NpcRpcProperties
 * 说明：本机RPC调用配置项
 * 时间：2021/9/4 15:13
 *
 * @author 何秀全
 */
@Data
@ConfigurationProperties(prefix = "npc.native")
public class NpcNativeProperties {
    /**
     * 是否开启rpc转http调用切面
     */
    private Boolean isOpenAop = false;
    /**
     * 本机RPC切点包路径，多个使用英文逗号[,]分隔
     */
    private String pointcutPackage = "com.tydic.utils.npc.aaa";
    /**
     * RPC服务器地址
     */
    private String serverAddress = "http://39.105.66.173:10130/deploy/federate/noauth/rpc";
    /**
     * RPC ControllerUrl地址
     */
    private String urlSuffix = "/deploy/federate/noauth/rpc";
    /**
     * 是否开启rpc controller，默认false
     */
    private Boolean isOpenRpc = false;
}
