package com.tydic.extend.field.utils;

import cn.hutool.core.util.ReflectUtil;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * @ClassName ObjectUtils
 * @Description 对象工具
 * @Author liugs
 * @Date 2022/10/9 15:05
 */
public class ObjectUtils {
    /**
     * 描述
     * @param arguments
     * @param paramMap
     * @return void
     * @author liugs
     * @date 2022/10/9 15:07
     */
    public static void putRequestParamIntoParamMap(Object[] arguments, Map<String, Object> paramMap) throws Throwable {
        if (null != arguments) {
            for (Object arg : arguments) {
                convertObjectToMap(arg, paramMap);
            }
        }
    }

    /**
     * 描述 将对象转为map
     * @param object
     * @param fieldValueMap
     * @return void
     * @author liugs
     * @date 2022/10/9 15:10
     */
    public static void convertObjectToMap(Object object, Map<String, Object> fieldValueMap) throws Throwable {
        // 获取对象所有字段
        Field[] fields = ReflectUtil.getFields(object.getClass());
        for (Field item : fields) {
            //设置些属性是可以访问的
            item.setAccessible(true);
            //属性名
            String fieldName = item.getName();
            if (null != item.get(object)) {
                Object fieldValue = item.get(object);
                fieldValueMap.put(fieldName, fieldValue);
            }
        }
    }
}
