package com.tydic.extend.field.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * 描述：序列生成器，使用雪花序列
 *
 * @author tgy
 * @date 2020/8/14 15:43
 */
@Slf4j
public class Sequence {

    /**
     * 雪花序列，使用volatile，防止高并发下的编译优化，指令重排，且对其它线程即时可见
     */
    private static volatile Snowflake snowflake = null;


    /**
     * 私有构造器初始化
     */
    private Sequence() {

    }

    /**
     * 使用双重检查 + 锁保证单例，且为private，只对外暴露nextId()方法，保证接口简单
     */
    private static Snowflake initInstance() {
        if (snowflake == null) {
            // 不为空，才会走获取锁的过程，且内部再次判断是否为空，保证绝对唯一，配合volatile，禁止指令重排
            synchronized (Sequence.class) {
                if (snowflake == null) {
                    long workId = RandomUtil.randomLong(16);
                    long dataCenterId = RandomUtil.randomLong(16);
                    snowflake = IdUtil.createSnowflake(workId, dataCenterId);
                }
            }
        }
        return snowflake;
    }

    /**
     * 获取下一个id
     */
    public static long nextId() {
        return initInstance().nextId();
    }

    public static void main(String[] args) {
        // 使用100个线程获取，测试
        for (int i = 0; i < 100; i++) {
            new Thread(() -> {
                System.out.println(Sequence.nextId());
            }, String.valueOf(i)).start();
        }
    }
}


