/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.extend.field.advice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.extend.field.model.ExtendFieldChildConfigDataBo;
import com.tydic.extend.field.model.ExtendFieldConfigDataBo;
import com.tydic.extend.field.utils.ObjectUtils;
import com.tydic.extend.field.utils.Sequence;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class HandleExtendFieldByPointCutAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HandleExtendFieldByPointCutAdvice.class);
    public static final Pattern PLACE_PATTERN = Pattern.compile("(\\$\\{)([\\w]+)(})");
    public static final String SNOWFLAKE_PLACEHOLDER = "SNOWFLAKE";
    private CacheClient cacheClient;
    private JdbcTemplate jdbcTemplate;

    public HandleExtendFieldByPointCutAdvice(CacheClient cacheClient, JdbcTemplate jdbcTemplate) {
        this.cacheClient = cacheClient;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object rspObj = invocation.proceed();
        StringBuilder cacheKeyBuilder = new StringBuilder();
        cacheKeyBuilder.append(invocation.getMethod().getDeclaringClass().getName()).append(".").append(invocation.getMethod().getName()).append(".").append("ExtField");
        Object config = this.cacheClient.get(cacheKeyBuilder.toString());
        if (ObjectUtil.isEmpty((Object)config)) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u6269\u5c55\u914d\u7f6e");
            return rspObj;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ObjectUtils.putRequestParamIntoParamMap(invocation.getArguments(), paramMap);
        ObjectUtils.convertObjectToMap(rspObj, paramMap);
        ExtendFieldConfigDataBo configDataBo = (ExtendFieldConfigDataBo)JSON.parseObject((String)config.toString(), ExtendFieldConfigDataBo.class);
        if ("1".equals(configDataBo.getOperateType())) {
            log.info("===\u5f00\u59cb\u5904\u7406\u6269\u5c55\u5b57\u6bb5\u4fe1\u606f\u5165\u5e93");
            this.extendFieldInsert(configDataBo, paramMap);
            log.info("===\u6269\u5c55\u5b57\u6bb5\u4fe1\u606f\u5165\u5e93\u5b8c\u6210");
        } else {
            log.info("===\u5f00\u59cb\u5904\u7406\u6269\u5c55\u5b57\u6bb5\u67e5\u8be2");
            this.extendFieldQuery(configDataBo, paramMap, rspObj);
            log.info("===\u6269\u5c55\u5b57\u6bb5\u4fe1\u606f\u67e5\u8be2\u5b8c\u6210");
        }
        return rspObj;
    }

    private void extendFieldInsert(ExtendFieldConfigDataBo configDataBo, Map<String, Object> paramMap) {
        Object extendFieldBo = paramMap.remove("extFields");
        if (ObjectUtil.isNotEmpty((Object)extendFieldBo)) {
            List extendFieldBoList = JSON.parseArray((String)JSON.toJSONString((Object)extendFieldBo), BaseExtendFieldBo.class);
            this.doInsert(configDataBo.getDynamicSql(), paramMap, extendFieldBoList);
        }
        if (CollectionUtil.isNotEmpty(configDataBo.getSubFieldConfig())) {
            for (ExtendFieldChildConfigDataBo configItem : configDataBo.getSubFieldConfig()) {
                Object childObj = paramMap.remove(configItem.getFieldCode());
                if (ObjectUtil.isEmpty((Object)childObj)) continue;
                this.childExtendFieldInsert(childObj, configItem, paramMap);
            }
        }
    }

    private void childExtendFieldInsert(Object childObj, ExtendFieldChildConfigDataBo configItem, Map<String, Object> paramMap) {
        Object extendFieldBo;
        if (childObj instanceof List) {
            Class<?> clazz = childObj.getClass();
            Method method = ReflectUtil.getMethod(clazz, (String)"size", (Class[])new Class[0]);
            int size = (Integer)ReflectUtil.invoke((Object)childObj, (Method)method, (Object[])new Object[0]);
            Method getMethod = ReflectUtil.getMethod(clazz, (String)"get", (Class[])new Class[]{Integer.TYPE});
            Object firstListItem = ReflectUtil.invoke((Object)childObj, (Method)getMethod, (Object[])new Object[]{0});
            if (!(firstListItem instanceof BaseExtendBo)) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                Object listItem = ReflectUtil.invoke((Object)childObj, (Method)getMethod, (Object[])new Object[]{i});
                this.childExtendFieldInsert(listItem, configItem, paramMap);
            }
        } else if (childObj instanceof BaseExtendBo && ObjectUtil.isNotEmpty((Object)(extendFieldBo = ReflectUtil.getFieldValue((Object)childObj, (String)"extFields")))) {
            List extendFieldBoList = JSON.parseArray((String)JSON.toJSONString((Object)extendFieldBo), BaseExtendFieldBo.class);
            this.doInsert(configItem.getDynamicSql(), paramMap, extendFieldBoList);
        }
        if (CollectionUtil.isNotEmpty(configItem.getSubFieldConfig())) {
            for (ExtendFieldChildConfigDataBo config : configItem.getSubFieldConfig()) {
                Object subObj = ReflectUtil.getFieldValue((Object)childObj, (String)config.getFieldCode());
                if (ObjectUtil.isEmpty((Object)subObj)) continue;
                this.childExtendFieldInsert(subObj, config, paramMap);
            }
        }
    }

    private void doInsert(String dynamicSql, Map<String, Object> paramMap, List<BaseExtendFieldBo> extendFieldBoList) {
        ArrayList<String> dynamicSqlList = new ArrayList<String>();
        for (BaseExtendFieldBo item : extendFieldBoList) {
            Map extendFieldValueMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)item), Map.class);
            extendFieldValueMap.putAll(paramMap);
            dynamicSqlList.add(this.buildDynamicSql(dynamicSql, extendFieldValueMap));
        }
        log.info("===\u672c\u6b21\u6269\u5c55\u5b57\u6bb5\u5165\u5e93\u6267\u884c\u7684SQL\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(dynamicSqlList));
        try {
            int[] result = this.jdbcTemplate.batchUpdate(dynamicSqlList.toArray(new String[dynamicSqlList.size()]));
            log.info("\u8bed\u53e5\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)result);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6269\u5c55\u5b57\u6bb5\u5165\u5e93\u8bed\u53e5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException("\u6269\u5c55\u5b57\u6bb5\u4fe1\u606f\u5165\u5e93\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void extendFieldQuery(ExtendFieldConfigDataBo configDataBo, Map<String, Object> paramMap, Object rspObj) throws Throwable {
        if (rspObj instanceof BaseExtendBo) {
            ReflectUtil.setFieldValue((Object)rspObj, (String)"extFields", this.doQuery(null, paramMap, configDataBo.getDynamicSql()));
        }
        if (CollectionUtil.isNotEmpty(configDataBo.getSubFieldConfig())) {
            for (ExtendFieldChildConfigDataBo childConfigDataBo : configDataBo.getSubFieldConfig()) {
                this.childExtendFieldQuery(childConfigDataBo, paramMap, rspObj);
            }
        }
    }

    private void childExtendFieldQuery(ExtendFieldChildConfigDataBo childConfigDataBo, Map<String, Object> paramMap, Object rspObj) throws Throwable {
        Object subObject = ReflectUtil.getFieldValue((Object)rspObj, (String)childConfigDataBo.getFieldCode());
        if (ObjectUtil.isEmpty((Object)subObject)) {
            return;
        }
        if (subObject instanceof List) {
            Class<?> clazz = subObject.getClass();
            Method sizeMethod = ReflectUtil.getMethod(clazz, (String)"size", (Class[])new Class[0]);
            int size = (Integer)ReflectUtil.invoke((Object)subObject, (Method)sizeMethod, (Object[])new Object[0]);
            Method getMethod = ReflectUtil.getMethod(clazz, (String)"get", (Class[])new Class[]{Integer.TYPE});
            Object firstSubItem = ReflectUtil.invoke((Object)subObject, (Method)getMethod, (Object[])new Object[]{0});
            if (!(firstSubItem instanceof BaseExtendBo)) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                Object subItem = ReflectUtil.invoke((Object)subObject, (Method)getMethod, (Object[])new Object[]{i});
                ReflectUtil.setFieldValue((Object)subItem, (String)"extFields", this.doQuery(subItem, paramMap, childConfigDataBo.getDynamicSql()));
            }
        } else if (subObject instanceof BaseExtendBo) {
            ReflectUtil.setFieldValue((Object)subObject, (String)"extFields", this.doQuery(subObject, paramMap, childConfigDataBo.getDynamicSql()));
        }
        if (CollectionUtil.isNotEmpty(childConfigDataBo.getSubFieldConfig())) {
            for (ExtendFieldChildConfigDataBo childConfigItem : childConfigDataBo.getSubFieldConfig()) {
                this.childExtendFieldQuery(childConfigItem, paramMap, subObject);
            }
        }
    }

    private List<BaseExtendFieldBo> doQuery(Object obj, Map<String, Object> paramMap, String dynamicSql) throws Throwable {
        ArrayList<BaseExtendFieldBo> extendFieldBoList = new ArrayList<BaseExtendFieldBo>();
        HashMap<String, Object> objValueMap = new HashMap<String, Object>(16);
        if (ObjectUtil.isNotEmpty((Object)obj)) {
            ObjectUtils.convertObjectToMap(obj, objValueMap);
        }
        objValueMap.putAll(paramMap);
        List queryForList = null;
        String queryDynamicSql = this.buildDynamicSql(dynamicSql, objValueMap);
        log.error("===\u672c\u6b21\u6267\u884c\u7684\u6269\u5c55\u5b57\u6bb5\u67e5\u8be2SQL\u8bed\u53e5\uff1a{}", (Object)queryDynamicSql);
        try {
            queryForList = this.jdbcTemplate.queryForList(queryDynamicSql);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6269\u5c55\u5b57\u6bb5\u67e5\u8be2\u8bed\u53e5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        if (CollectionUtil.isNotEmpty((Collection)queryForList)) {
            queryForList.forEach(item -> extendFieldBoList.add((BaseExtendFieldBo)JSON.parseObject((String)JSON.toJSONString((Object)item), BaseExtendFieldBo.class)));
        }
        return extendFieldBoList;
    }

    private String buildDynamicSql(String dynamicSql, Map<String, Object> paramMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PLACE_PATTERN.matcher(dynamicSql);
        while (matcher.find()) {
            String group = matcher.group(2);
            if (paramMap.get(group) == null) {
                if (SNOWFLAKE_PLACEHOLDER.equals(group)) {
                    matcher.appendReplacement(stringBuffer, String.valueOf(Sequence.nextId()));
                    continue;
                }
                matcher.appendReplacement(stringBuffer, "null");
                continue;
            }
            matcher.appendReplacement(stringBuffer, "'" + paramMap.get(group).toString() + "'");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().trim();
    }
}

