/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthByRoleAndOrgQryUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeReceiverBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtRspBo;
import com.tydic.fsc.busibase.external.api.notice.FscNoticeSendExtService;
import com.tydic.fsc.common.ability.api.FscNotCheckInspOrderNotificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscNotCheckInspOrderNotificationAbilityReqBo;
import com.tydic.fsc.common.ability.bo.FscNotCheckInspOrderNotificationAbilityRspBo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscNotCheckInspOrderNotificationAbilityService"})
public class FscNotCheckInspOrderNotificationAbilityServiceImpl
implements FscNotCheckInspOrderNotificationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscNotCheckInspOrderNotificationAbilityServiceImpl.class);
    @Value(value="#{'${fsc.notCheckInspOrderNotification.defaultSource:2}'.split(',')}")
    private List<Integer> defaultSource;
    @Value(value="${qry.url:http://39.105.66.173:10220/query}")
    private String generalQueryUrl;
    @Value(value="#{'${fsc.notCheckInspOrderNotification.defaultRoles:business:null:jiaoxingjiesuanzhuanze}'.split(',')}")
    private List<String> defaultRoles;
    @Value(value="${fsc.notCheckInspOrderNotification.taskCode:fsc_not_check_insp_notification}")
    private String taskCode;
    @Value(value="${fsc.notCheckInspOrderNotification.qryCode:951850387126652928}")
    private String qryCode;
    @Autowired
    private AuthGetUserByRoleAndOrgService selectUserByRoleAndOrgWebService;
    @Autowired
    private FscNoticeSendExtService fscNoticeSendExtService;

    @PostMapping(value={"notifyNotCheckInspOrder"})
    public FscNotCheckInspOrderNotificationAbilityRspBo notifyNotCheckInspOrder(@RequestBody FscNotCheckInspOrderNotificationAbilityReqBo reqBo) {
        DateTime lastEndOfMonth = DateUtil.endOfMonth((Date)DateUtil.lastMonth());
        List<AuthByRoleAndOrgQryUserInfoBo> recipientList = this.getRecipient();
        if (!CollectionUtils.isEmpty(recipientList)) {
            Map<Long, List<AuthByRoleAndOrgQryUserInfoBo>> recipientListMap = recipientList.stream().collect(Collectors.groupingBy(AuthByRoleAndOrgQryUserInfoBo::getOrgId));
            recipientListMap.forEach((orgId, recipients) -> this.callNotice((List<AuthByRoleAndOrgQryUserInfoBo>)recipients, this.getRecordsTotal(lastEndOfMonth, (Long)orgId)));
        }
        return new FscNotCheckInspOrderNotificationAbilityRspBo();
    }

    private void callNotice(List<AuthByRoleAndOrgQryUserInfoBo> recipients, Integer recordsTotal) {
        if (recordsTotal > 0) {
            FscNoticeSendExtReqBo fscNoticeSendExtReqBo = new FscNoticeSendExtReqBo();
            fscNoticeSendExtReqBo.setTaskCode(this.taskCode);
            fscNoticeSendExtReqBo.setSendId("1");
            fscNoticeSendExtReqBo.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            fscNoticeSendExtReqBo.setReceivers(recipients.stream().map(e -> {
                FscNoticeReceiverBO fscNoticeReceiverBO = new FscNoticeReceiverBO();
                fscNoticeReceiverBO.setReceiverId(Convert.toStr((Object)e.getUserId()));
                fscNoticeReceiverBO.setReceiverName(e.getCustName());
                return fscNoticeReceiverBO;
            }).collect(Collectors.toList()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("notCheckInspOrderNotificationCount", (Object)recordsTotal);
            fscNoticeSendExtReqBo.setData(jsonObject.toJSONString());
            log.info("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscNoticeSendExtReqBo));
            FscNoticeSendExtRspBo fscNoticeSendExtRspBo = this.fscNoticeSendExtService.sendNotice(fscNoticeSendExtReqBo);
            log.info("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscNoticeSendExtReqBo));
            if (!"0000".equals(fscNoticeSendExtRspBo.getRespCode())) {
                log.error("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff1a{}", (Object)fscNoticeSendExtRspBo.getRespDesc());
            }
        }
    }

    private Integer getRecordsTotal(DateTime lastEndOfMonth, Long orgId) {
        String qryParam = this.buildQryParam(orgId, lastEndOfMonth.getTime());
        log.info("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)qryParam);
        String rspStr = HttpUtil.post((String)this.generalQueryUrl, (String)qryParam, (int)6000);
        log.info("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)rspStr);
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        return Convert.toInt((Object)jsonObject.get((Object)"recordsTotal"), (Integer)0);
    }

    private String buildQryParam(Long orgId, long time) {
        JSONObject reqParams = new JSONObject();
        reqParams.put("code", (Object)this.qryCode);
        reqParams.put("inspectionCreateTimeExp", (Object)time);
        reqParams.put("purNo", (Object)orgId);
        JSONArray relInfo = new JSONArray();
        relInfo.add((Object)"0,3");
        reqParams.put("relInfo", (Object)relInfo);
        JSONArray orderSourceList = new JSONArray();
        orderSourceList.addAll(this.defaultSource);
        reqParams.put("orderSourceList", (Object)orderSourceList);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("queryCountFlag", (Object)true);
        jsonObject.put("reqParams", (Object)reqParams.toJSONString());
        return jsonObject.toJSONString();
    }

    private List<AuthByRoleAndOrgQryUserInfoBo> getRecipient() {
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        authGetUserByRoleAndOrgReqBo.setPageNo(-1);
        authGetUserByRoleAndOrgReqBo.setPageSize(-1);
        authGetUserByRoleAndOrgReqBo.setLevelFlag(Integer.valueOf(1));
        authGetUserByRoleAndOrgReqBo.setRoleCodes(this.defaultRoles);
        log.info("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u67e5\u8be2\u5f85\u901a\u77e5\u4eba\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)authGetUserByRoleAndOrgReqBo));
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.selectUserByRoleAndOrgWebService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        log.info("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u67e5\u8be2\u5f85\u901a\u77e5\u4eba\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)userByRoleAndOrg));
        if (!"0000".equals(userByRoleAndOrg.getRespCode())) {
            log.error("\u7ed3\u7b97\u672a\u5bf9\u8d26\u7ed3\u7b97\u5355\u63d0\u9192\u670d\u52a1\uff0c\u67e5\u8be2\u5f85\u901a\u77e5\u4eba\u5f02\u5e38\uff1a{}", (Object)userByRoleAndOrg.getRespDesc());
        }
        return userByRoleAndOrg.getRows();
    }
}

