/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fund.base.wordfilter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.fund.base.wordfilter.FilterSet;
import com.tydic.fund.base.wordfilter.SymbolConvert;
import com.tydic.fund.base.wordfilter.WordNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WordFilter {
    private static final Logger log = LoggerFactory.getLogger(WordFilter.class);
    private static final FilterSet SET = new FilterSet();
    private static final Map<Integer, WordNode> NODES = Maps.newHashMapWithExpectedSize((int)2048);
    private static final Set<Integer> STOP_WD_SET = Sets.newHashSet();
    private static final char SIGN = '*';

    private static void init() {
        String wordFilePath = WordFilter.class.getResource("/").getPath() + "wordfilter";
        WordFilter.addSensitiveWord(WordFilter.readWordFromFile(wordFilePath));
        WordFilter.addStopWord();
    }

    private static List<String> readWordFromFile(String path) {
        ArrayList words = Lists.newArrayListWithExpectedSize((int)2048);
        File file = new File(path);
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            if (fs != null && fs.length > 0) {
                for (File fItem : fs) {
                    words.addAll(WordFilter.readWordFromFile(fItem.getPath()));
                }
            }
        } else if (file.isFile() && file.exists()) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String buf;
                while ((buf = br.readLine()) != null) {
                    if ("".equals(buf.trim())) continue;
                    words.add(buf);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return words;
    }

    private static void addStopWord() {
        List<String> words = SymbolConvert.getStopWords();
        if (!CollectionUtils.isEmpty(words)) {
            for (String curr : words) {
                char[] chs;
                for (char c : chs = curr.toCharArray()) {
                    STOP_WD_SET.add(WordFilter.charConvert(c));
                }
            }
        }
    }

    private static void addSensitiveWord(List<String> words) {
        if (CollectionUtils.isEmpty(words)) {
            log.error("------\u672a\u6210\u529f\u52a0\u8f7d\u654f\u611f\u8bcd\u8bcd\u5e93---------");
            return;
        }
        for (String curr : words) {
            WordNode fnode;
            char[] chs = curr.toCharArray();
            int convertChar = WordFilter.charConvert(chs[0]);
            if (SET.contains(convertChar)) {
                SET.add(convertChar);
                fnode = new WordNode(convertChar, chs.length == 1);
                NODES.put(convertChar, fnode);
            } else {
                fnode = NODES.get(convertChar);
                if (!fnode.isLast() && chs.length == 1) {
                    fnode.setLast();
                }
            }
            int lastIndex = chs.length - 1;
            for (int i = 1; i < chs.length; ++i) {
                fnode = fnode.addIfNoExist(WordFilter.charConvert(chs[i]), i == lastIndex);
            }
        }
    }

    public static String doFilter(String src) {
        if (CollectionUtils.isEmpty(NODES)) {
            log.error("------\u654f\u611f\u8bcd\u8282\u70b9\u4e3a\u7a7a---------");
            return src;
        }
        if (!StringUtils.isEmpty((Object)src)) {
            char[] chs = src.toCharArray();
            int length = chs.length;
            for (int i = 0; i < length; ++i) {
                WordNode node;
                int currChar = WordFilter.charConvert(chs[i]);
                if (SET.contains(currChar) || (node = NODES.get(currChar)) == null) continue;
                boolean couldMark = false;
                int markNum = -1;
                if (node.isLast()) {
                    couldMark = true;
                    markNum = 0;
                }
                int k = i;
                int cpCurrChar = currChar;
                while (++k < length) {
                    int temp = WordFilter.charConvert(chs[k]);
                    if (temp == cpCurrChar || !CollectionUtils.isEmpty(STOP_WD_SET) && STOP_WD_SET.contains(temp)) continue;
                    if ((node = node.querySub(temp)) == null) break;
                    if (node.isLast()) {
                        couldMark = true;
                        markNum = k - i;
                    }
                    cpCurrChar = temp;
                }
                if (!couldMark) continue;
                for (k = 0; k <= markNum; ++k) {
                    chs[k + i] = 42;
                }
                i += markNum;
            }
            return new String(chs);
        }
        return src;
    }

    public static boolean isContains(String src) {
        if (!StringUtils.isEmpty((Object)src) && !CollectionUtils.isEmpty(NODES)) {
            char[] chs = src.toCharArray();
            int length = chs.length;
            for (int i = 0; i < length; ++i) {
                WordNode node;
                int currChar = WordFilter.charConvert(chs[i]);
                if (SET.contains(currChar) || (node = NODES.get(currChar)) == null) continue;
                boolean couldMark = false;
                if (node.isLast()) {
                    couldMark = true;
                }
                int k = i;
                int cpcurrc = currChar;
                while (++k < length) {
                    int temp = WordFilter.charConvert(chs[k]);
                    if (temp == cpcurrc || !CollectionUtils.isEmpty(STOP_WD_SET) && STOP_WD_SET.contains(temp)) continue;
                    if ((node = node.querySub(temp)) == null) break;
                    if (node.isLast()) {
                        couldMark = true;
                    }
                    cpcurrc = temp;
                }
                if (!couldMark) continue;
                return true;
            }
        }
        return false;
    }

    private static int charConvert(char src) {
        int r = SymbolConvert.qj2bj(src);
        return r >= 65 && r <= 90 ? r + 32 : r;
    }

    static {
        try {
            WordFilter.init();
        }
        catch (Exception e) {
            log.error("------\u521d\u59cb\u5316\u654f\u611f\u8bcd\u5931\u8d25---------", (Throwable)e);
        }
    }
}

