package com.tydic.dyc.oc.service.domainservice.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocAfOrderRefundDetailBo
 * 说明:退款明细信息
 * 时间:2022/2/14 13:46
 * 作者:tkl
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocAfOrderRefundDetailBo implements Serializable {
    private static final long serialVersionUID = 2528398982216802173L;

    /**
     * 支付单id
     */
    private Long payOrderId;

    /**
     * 流水号
     */
    private String outPayOrderNo;

    /**
     * 售后金额
     */
    private BigDecimal payFee;

    /**
     * 退款金额
     */
    private BigDecimal realReturnFee;

    /**
     * 退款账户id
     */
    private String purAccount;

    /**
     * 退款账户名称
     */
    private String purAccountName;

    /**
     * 退款标志  0 扣款  1 退款
     */
    private Integer interType;

    /**
     * 退款标志翻译
     */
    private String interTypeStr;

    /**
     * 退款状态
     */
    private String payState;

    /**
     * 退款状态翻译
     */
    private String payStateStr;

    /**
     * 支付方式  1 微信  2 支付宝  3 企业支付
     */
    private Integer payType;

    /**
     * 支付方式翻译
     */
    private String payTypeStr;

    /**
     * 时间
     */
    private Date createTime;
}
