package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;

import java.util.List;

/**
 * 标题:UocReceiveItInspOrderNoItemReqBo
 * 说明:
 * 时间:2023/8/31 14:22
 * 作者:Dum
 */
@Data
public class UocReceiveItInspOrderNoItemReqBo extends BaseReqBo {

    /**
     * 销售单ID
     */
    private Long saleOrderId;
    /**
     * 销售单编号
     */
    private String saleOrderNo;
    /**
     * 附件信息
     */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /**
     * 验收人id
     */
    private String inspOperId;
    /**
     * 验收人名称
     */
    private String inspOperName;
    /**
     * 验收时间
     */
    private String inspTime;

    /**
     * 验收金额
     */
    private String inspMoney;
    /**
     * 验收类型（1：验收；2：拒收）
     */
    private String inspType;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 验收完结 true是 false否
     */
    private Boolean inspFinish;
    /**
     * 销售明细
     */
    private List<UocCreateInspEstimateSaleItemBo> saleOrderItemList;
}
