package com.tydic.dyc.oc.service.common.bo;

/**
 * 描述：订单中心产品出参返回编码常量
 *
 * @author tgy
 * @date 2021/2/19 19:18
 */
public class UocProRspConstants {


    /*编码生成规则：订单中心编码开头：10开头的6位编码
	调用成功的编码无需再自行定义，统一使用：RESP_CODE_SUCCESS
	每个接口调用失败的编码需自行定义，规则如下：
	编码key：以RESP_CODE开头，以ERROR结束，中间为自定义部分，
	自定义原则为具有可读性的英文单词（可简写），多个单词以“_”分隔，如：RESP_CODE_DEAL_ORDER_ERROR。
	编码值：原子层以1开头，如：1001；业务层以2开头，如：2001；组合层以3开头，如：3001，ability层以4开头，如：4001；编码值长度为4位
	注意：订单中心整体编码前面要加21，方便应用层识别和统一管理编码
	*/
    /**
     * 系统成功
     */
    public static final String RSP_CODE_SUCCESS = "0000";

    /**
     * 成功通用描述
     */
    public static final String RSP_DESC_SUCCESS = "成功";

    /**
     * 系统失败
     */
    public static final String RSP_CODE_FAILUR = "8888";

    /**
     * 失败通用描述
     */
    public static final String RSP_DESC_FAILUR = "失败";

    /**
     * 通知中心成功编码
     */
    public static final String NOTIFY_CODE_SUCCESS = "0";


    //----------------------------------通用异常，第三位0开头，START----------------------------------
    /**
     * 通用入参必填字段不能为空编码
     */
    public static final String RSP_CODE_PARAMETERS_NULL = "100001";
    /**
     * 通用入参必填字段不符合规范编码
     */
    public static final String RSP_CODE_PARAMETERS_ERROR = "100002";
    /**
     * 通用系统异常编码
     */
    public static final String RSP_CODE_SYSTEM_EXCEPTION = "100100";
    /**
     * 查询结果为空
     */
    public static final String QUERY_RESULT_IS_EMPTY = "100200";
    /**
     * 订单状态校验失败
     */
    public static final String ORDER_STATE_CHECK_FAIL = "100031";
    /**
     * 状态机处理失败
     */
    public static final String STATE_MACHINE_HANDLE_FAIL = "100032";
    /**
     * (下单)查询协议出错
     */
    public static final String CREATE_ORDER_AFR_ERROR = "100006";
    /**
     * (下单)商品价格校验出错
     */
    public static final String CREATE_ORDER_GOODS_ERROR = "10005";
    /**
     * 订单不存在
     */
    public static final String ORDER_DOSE_NOT_EXIST = "10000";
    /**
     * 创建订单发送mq失败
     */
    public static final String CREATE_ORDER_SENDMQ_FAIL = "100029";
    /**
     * 查询异常表单不存在
     */
    public static final String ABNORMAL_ORDER_NOTEXSIT = "100030";
    /**
     * 调用接口异常:6000
     */
    public static final String RSP_CODE_CALL_THIRD_SERVICE = "106000";
    /**
     * 参数校验失败异常
     */
    public static final String PARAM_VERIFY_EXCEPTION = "107777";
    //----------------------------------通用异常，第三位0开头，END----------------------------------




    //----------------------------------原子层，第三位1开头，START----------------------------------
    /**
     * 查询数据库mock配置错误
     */
    public static final String RSP_QRY_MOCK_ERROR = "101001";

    /**
     * 订单状态异常
     */
    public static final String ORDER_STATE_EXCPTION = "101002";
    /**
     * RPC mock调用错误
     */
    public static final String RSP_RPC_MOCK_ERROR = "101002";
    /**
     *查询模板配置错误
     */
    public static final String RSP_CODE_QRY_TEMPLETE_ATOM_ERROR = "101003";
    
    /**
     *查询商品信息和价格错误
     */
    public static final String RSP_CODE_EXT_QRY_SKU_INFO_AND_PRICE_ATOM_ERROR = "101004";
    
    /**
     *查询销售订单错误
     */
    public static final String RSP_CODE_QRY_SALE_ORDER_ATOM_ERROR = "101005";

    /**
     *发货单ID生成错误
     */
    public static final String RSP_CODE_GENERATE_ORD_SHIP_SEQ_ATOM_ERROR = "101006";

    /**
     *字典服务成错误
     */
    public static final String RSP_CODE_CORE_DICTIONARY_ATOM_ERROR = "101007";

    /**
     *查询具体字典值错误
     */
    public static final String RSP_CODE_SELECT_DIC_VAL_ATOM_ERROR = "101008";

    /**
     *供应商服务费违约查询错误
     */
    public static final String RSP_CODE_CHECK_SUP_BREAK_CONTRACT_ATOM_ERROR = "101009";

    /**
     *订单中心核心订单到货登记错误
     */
    public static final String RSP_CODE_ARRIVE_REGIST_ATOM_ERROR = "101010";

    /**
     *售后服务单编号生成序列错误
     */
    public static final String RSP_CODE_GENERATE_ORD_AFTER_SALE_SEQ_ATOM_ERROR = "101011";

    /**
     *获取seq错误
     */
    public static final String RSP_CODE_SEQ_ATOM_ERROR = "101012";

    /**
     *订单中心核心支付完成错误
     */
    public static final String RSP_CODE_CORE_COMPLETE_PAY_ORD_ATOM_ERROR = "101013";

    /**
     *订单中心核心售后服务完工错误
     */
    public static final String RSP_CODE_CORE_AFTER_SERV_ORD_FIN_ATOM_ERROR = "101014";

    /**
     *支付单编号生成序列错误
     */
    public static final String RSP_CODE_GEN_ORD_PAY_SEQ_ATOM_ERROR = "101015";

    /**
     *统一插入接口调用日志错误
     */
    public static final String RSP_CODE_COMM_CREATE_INTF_LOG_ATOM_ERROR = "101016";

    /**
     *查询销售订单关于内部订单对账记录信息错误
     */
    public static final String RSP_CODE_ORY_ORD_SALE_ABOUT_ORD_REC_ATOM_ERROR = "101017";

    /**
     *订单中心核心售后服务取消错误
     */
    public static final String RSP_CODE_AFTER_SERV_ORD_CANCEL_ATOM_ERROR = "101018";

    /**
     *查询核心订单详情错误
     */
    public static final String RSP_CODE_CORE_ORY_ORD_DETAIL_ATOM_ERROR = "101018";

    /**
     *订单提醒错误
     */
    public static final String RSP_CODE_ORD_REMIND_ATOM_ERROR = "101019"; 
    
    /**
     *售后退款计算错误
     */
    public static final String RSP_CODE_CAL_RET_FEE_ATOM_ERROR = "101020";
    
    /**
     *订单中心核心业务操作记录错误
     */
    public static final String RSP_CODE_CORE_BUSI_OPER_REC_ATOM_ERROR = "101021";
    
    /**
     *电子超市统一退款错误
     */
    public static final String RSP_CODE_PEB_REF_ATOM_ERROR = "101022";

    /**
     *订单中心核心订单处理错误
     */
    public static final String RSP_CODE_CORE_DEAL_ORD_ATOM_ERROR = "101023";

    /**
     *订单中心核心物流联系人创建错误
     */
    public static final String RSP_CODE_CORE_CRE_LOGI_REL_ATOM_ERROR = "101024";

    /**
     *订单中心核心任务分配错误
     */
    public static final String RSP_CODE_CORE_TASK_ASS_ATOM_ERROR = "101025";

    /**
     *订单中心核心单据状态更新错误
     */
    public static final String RSP_CODE_CORE_CHG_VOU_STA_ATOM_ERROR = "101026";

    /**
     *电子超市用户中心删除购物车错误
     */
    public static final String RSP_CODE_UC_DEL_SHOP_CAR_ATOM_ERROR = "101027";

    /**
     *订单中心核心获取订单ID错误
     */
    public static final String RSP_CODE_CORE_GET_ORD_ID_ATOM_ERROR = "101028";

    /**
     *订单中心核心支付订单创建错误
     */
    public static final String RSP_CODE_CORE_CRE_PAY_ORD_ATOM_ERROR = "101029";

    /**
     *订单中心核心销售单创建错误
     */
    public static final String RSP_CODE_CORE_CRE_SALE_ORD_ATOM_ERROR = "101030";

    /**
     *新增扩展地图错误
     */
    public static final String RSP_CODE_ADD_EXT_MAP_ATOM_ERROR = "101031";

    /**
     *订单中心核心附件生成错误
     */
    public static final String RSP_CODE_CORE_CRE_ACC_ATOM_ERROR = "101032";

    /**
     *电商通用业务操作记录错误
     */
    public static final String RSP_CODE_BUSI_OPER_REC_ATOM_ERROR = "101033";

    /**
     *订单中心核心订单验收错误
     */
    public static final String RSP_CODE_CORE_INS_ATOM_ERROR = "101034";

    /**
     *超额审批判断错误
     */
    public static final String RSP_CODE_ORD_MONEY_CHECK_ATOM_ERROR = "101035";

    /**
     *订单中心核心售后服务单创建错误
     */
    public static final String RSP_CODE_CORE_CRE_AFTER_SERV_ORD_ATOM_ERROR = "101036";

    /**
     *订单中心核心获取单据号列表错误
     */
    public static final String RSP_CODE_CORE_GET_OBJ_ID_ATOM_ERROR = "101037";

    /**
     *服务项列表核心订单查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_AFTER_SERV_ITEM_LIST_ATOM_ERROR = "101038";

    /**
     *订单中心核心任务处理错误
     */
    public static final String RSP_CODE_CORE_DEAL_TASK_INST_ATOM_ERROR = "101039";

    /**
     *订单中心核心拓展属性入库错误
     */
    public static final String RSP_CODE_CORE_EXT_FIELD_IN_ATOM_ERROR = "101040";

    /**
     *订单中心核心通过外部订单号查询单据ID错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_BY_ORD_NO_ATOM_ERROR = "101041";

    /**
     *附件列表核心查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ACC_LIST_ATOM_ERROR = "101042";

    /**
     *订单完结通知错误
     */
    public static final String RSP_CODE_SALE_ORD_INFO_PUSH_ATOM_ERROR = "101043";

    /**
     *订单中心核心订单创建错误
     */
    public static final String RSP_CODE_CORE_CRE_ORD_ATOM_ERROR = "101044";

    /**
     *核心查询订单检验项目列表错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_INS_ITEM_LIST_ATOM_ERROR = "101045";
    
    /**
     *订单项列表核心查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_ITEM_LIST_ATOM_ERROR = "101046";
    
    /**
     *已退货明细查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_AFTER_SERV_DETAIL_ATOM_ERROR = "101047";
    
    /**
     *根据当前用户信息查询其组织机构信息错误
     */
    public static final String RSP_CODE_CORE_QRY_ORG_ATOM_ERROR = "101048";
    
    /**
     *异常单详情查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_ABNOR_DEAL_DETAIL_ATOM_ERROR = "101049"; 
    
    /**
     *核心查询订单详情错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_SHIP_DETAIL_ATOM_ERROR = "101050"; 
    
    /**
     *下单查询延保运费错误
     */
    public static final String RSP_CODE_PEB_INS_TRANS_ATOM_ERROR = "101051";
    
    /**
     *查询商品是否在购物车中存在错误
     */
    public static final String RSP_CODE_PEB_QRY_SKU_EXIT_ATOM_ERROR = "101052";
    
    /**
     *电子超市统一接口调用错误
     */
    public static final String RSP_CODE_PEB_UNI_CALL_INTF_ATOM_ERROR = "101053";
    
    /**
     *专区统计销量错误
     */
    public static final String RSP_CODE_PEB_ADD_SALE_NUM_ATOM_ERROR = "101054";
    
    /**
     *电子超市结算中心扣款错误
     */
    public static final String RSP_CODE_PEB_AC_PAY_ATOM_ERROR = "101055";
    
    /**
     *电子超市电商订单取消错误
     */
    public static final String RSP_CODE_PEB_EB_CANCEL_ORD_ATOM_ERROR = "101056"; 
    
    /**
     *订单中心核心环节状态更新错误
     */
    public static final String RSP_CODE_CORE_TACHE_STATE_UPDATE_ATOM_ERROR = "101057";
    
    /**
     *订单总价计算校验错误
     */
    public static final String RSP_CODE_PEB_PRI_CAL_ATOM_ERROR = "101058"; 
    
    /**
     *核心订单发货错误
     */
    public static final String RSP_CODE_CORE_ORD_SHIP_ATOM_ERROR = "101059";
    
    /**
     *详情检查核心订单查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_INP_DETAIL_ATOM_ERROR = "101060";
    
    /**
     *订单发货单列表查询错误
     */
    public static final String RSP_CODE_CORE_QRY_ORD_SHIP_LIST_ATOM_ERROR = "101061";
    
    /**
     *订单验收配置错误
     */
    public static final String RSP_CODE_PRO_INS_CONF_ATOM_ERROR = "101062";
    
    /**
     *特定环节业务处理错误
     */
    public static final String RSP_CODE_ZONE_SPEC_LINK_BUSI_TO_DEAL_ATOM_ERROR = "101063";
    
    /**
     *电子超市电商接口调用错误
     */
    public static final String RSP_CODE_PEB_EB_SUB_ORD_ATOM_ERROR = "101064";
    
    /**
     *查询tabId对应状态错误
     */
    public static final String RSP_CODE_ORY_TAB_STA_ATOM_ERROR = "101065";

    /**
     *订单中心核心订单状态机启动错误
     */
    public static final String RSP_CODE_STA_PRO_ATOM_ERROR = "101066";

    /**
     *状态配置提醒错误
     */
    public static final String RSP_CODE_STA_CONF_REMIND_ATOM_ERROR = "101067";

    /**
     *查询商品信息和价格错误
     */
    public static final String RSP_CODE_QRY_SKU_INFO_AND_PRI_ATOM_ERROR = "101068";

    /**
     *专区订单提醒错误
     */
    public static final String RSP_CODE_PEB_SEND_MSG_ATOM_ERROR = "101069";

    /**
     *订单中心核心订单状态机处理错误
     */
    public static final String RSP_CODE_RUN_PRO_ATOM_ERROR = "101070";

    /**
     *电子超市消息池信息更新错误
     */
    public static final String RSP_CODE_UPD_MSG_POOL_ATOM_ERROR = "101071";

    /**
     *订单发货单列表查询错误
     */
    public static final String RSP_CODE_ORY_ORD_SHIP_ITEM_LIST_ATOM_ERROR = "101072";

    /**
     *订单列表查询错误
     */
    public static final String RSP_CODE_ORY_ORD_LIST_ATOM_ERROR = "101073";

    /**
     *订单中心核心查询任务实例错误
     */
    public static final String RSP_CODE_CORE_ORY_TASK_INST_ATOM_ERROR = "101074";

    /**
     *预订单确认错误
     */
    public static final String RSP_CODE_PEB_EB_CONFIRM_ORD_ATOM_ERROR = "101075";

    /**
     *订单获取配置中心订单编号错误
     */
    public static final String RSP_CODE_PRO_GET_VOU_NO_ATOM_ERROR = "101076";

    /**
     *测试生成数据错误
     */
    public static final String RSP_CODE_OUT_SERV_TEM_DATA_ERROR = "101077";

    /**
     *加载日志记录错误
     */
    public static final String RSP_CODE_INTER_LOG_BASE_ERROR = "101078";

    //----------------------------------原子层，第三位1开头，END----------------------------------




    //----------------------------------BUSI层，第三位2开头，START----------------------------------
    /**
     * 调用第三方接口失败:2001
     */
    public static final String RSP_ERROR_CODE_CALL_THIRD_SERVICE = "102000";

    /**
     * 调用接口响应数据空:2001
     */
    public static final String RSP_CODE_THREE_DATA_NULL = "102001";
    /**
     *校验业务编码错误
     */
    public static final String RSP_CODE_CHECK_BUSI_CODE_BUSI_ERROR = "102002";
    
    /**
     *订单提醒错误
     */
    public static final String RSP_CODE_ORDER_REMIND_BUSI_ERROR = "102003";
    
    /**
     *发送短信错误
     */
    public static final String RSP_CODE_PEB_INTF_SMS_BUSI_ERROR = "102004";
    
    /**
     *售后维护发运信息错误
     */
    public static final String RSP_CODE_UPDATE_SEND_SKU_BUSI_ERROR = "102005";
    
    /**
     *创建外部订单查询索引错误
     */
    public static final String RSP_CODE_CREATE_OUT_ORD_QRY_BUSI_ERROR = "102006";
    
    /**
     *采购商索引表数据插入错误
     */
    public static final String RSP_CODE_CREATE_PUR_ORD_IDX_BUSI_ERROR = "102006";

    /**
     *异常单列表数据同步信息错误
     */
    public static final String RSP_CODE_ES_SYNC_ABNOR_LIST_BUSI_ERROR = "102007";

    /**
     *成交服务费列同步信息表数据错误
     */
    public static final String RSP_CODE_ES_SYNC_TRANS_SERV_LIST_BUSI_ERROR = "102008";

    /**
     *电子超市异常单处理申请错误
     */
    public static final String RSP_CODE_ABNOR_CRE_BUSI_ERROR = "102009";

    /**
     *电子超市异常单处理申请错误
     */
    public static final String RSP_CODE_ES_SYNC_SHIP_LIST_BUSI_ERROR = "102010"; 
    
    /**
     *供应商售后完成，采购方售后完成确认错误
     */
    public static final String RSP_CODE_PRO_AFTER_SERV_COMPLETE_CONFIRM_BUSI_ERROR = "102011";
    
    /**
     *异常单同步ES错误
     */
    public static final String RSP_CODE_PEB_EXT_ABNOR_SYNC_ES_BUSI_ERROR = "102012"; 
    
    /**
     *取消审批错误
     */
    public static final String RSP_CODE_APPRO_CANCEL_BUSI_ERROR = "102013";
    
    /**
     *批量生成比选单错误
     */
    public static final String RSP_CODE_CRE_BATH_COMP_ORD_BUSI_ERROR = "102014";
    
    /**
     *订单取消撤回错误
     */
    public static final String RSP_CODE_DEAL_CANCEL_BUSI_ERROR = "102015";
    
    /**
     *采购单列表数据同步信息错误
     */
    public static final String RSP_CODE_ES_SYNC_PUR_LIST_BUSI_ERROR = "102016";
    
    /**
     *售后服务审批错误
     */
    public static final String RSP_CODE_AFTER_SALES_SERV_APPRO_BUSI_ERROR = "102017";
    
    /**
     *订单合同状态修改错误
     */
    public static final String RSP_CODE_DEAL_CONTRACT_STA_BUSI_ERROR = "102018";
    
    /**
     *下单添加成交服务费错误
     */
    public static final String RSP_CODE_PEB_EXT_FIELD_IN_BUSI_ERROR = "102019"; 
    
    /**
     *批量生成比选单错误
     */
    public static final String RSP_CODE_ORY_BAT_COMP_ORD_BUSI_ERROR = "102020";

    /**
     *处理客户直接线下售后错误
     */
    public static final String RSP_CODE_DEAL_AFTER_BY_OFFL_BUSI_ERROR = "102021";

    /**
     *处理外部发运消息错误
     */
    public static final String RSP_CODE_AFT_DEL_DEAL_BUSI_ERROR = "102022";

    /**
     *查询售后需要更新新订单ID的外部售后单服务信息错误
     */
    public static final String RSP_CODE_DEAL_AFS_NEW_ORD_ID_BUSI_ERROR = "102023";

    /**
     *ES中核计划列表查询错误
     */
    public static final String RSP_CODE_ES_PLAN_LIST_QRY_BUSI_ERROR = "102024";

    /**
     *电子超市订单超额金额判断错误
     */
    public static final String RSP_CODE_PEB_ORD_MONEY_CHECK_BUSI_ERROR = "102025";

    /**
     *通过ES统计不同订单状态数量错误
     */
    public static final String RSP_CODE_ES_COUNT_STA_NUM_BUSI_ERROR = "102026";

    /**
     *查询通知配置详情错误
     */
    public static final String RSP_CODE_QRY_NOT_CONF_DET_BUSI_ERROR = "102027";

    /**
     *查询订单列表页签数量错误
     */
    public static final String RSP_CODE_QRY_ORD_TAB_NUM_BUSI_ERROR = "102028";

    /**
     *订单调价申请错误
     */
    public static final String RSP_CODE_ORD_ADJ_PRI_BUSI_ERROR = "102029";

    /**
     *删除通知配置错误
     */
    public static final String RSP_CODE_DEL_NOT_CONF_BUSI_ERROR = "102030";

    /**
     *根据父id集合查询字典值错误
     */
    public static final String RSP_CODE_DIC_VAL_BY_CODE_BUSI_ERROR = "102031";

    /**
     *订单列表数据同步信息错误
     */
    public static final String RSP_CODE_SYNC_ORD_LIST_BUSI_ERROR = "102032";

    /**
     *订单发货/施工/服务错误
     */
    public static final String RSP_CODE_ORD_DEL_BUSI_ERROR = "102033";

    /**
     *通用流转错误
     */
    public static final String RSP_CODE_CEN_CIR_BUSI_ERROR = "102034";

    /**
     *订单取消申请错误
     */
    public static final String RSP_CODE_PEB_EXT_CANCEL_BUSI_ERROR = "102035";

    /**
     *中核计划详情查询错误
     */
    public static final String RSP_CODE_PLAN_DET_QRY_BUSI_ERROR = "102036";

    /**
     *历史计划列表错误
     */
    public static final String RSP_CODE_HIS_PLAN_LIST_BUSI_ERROR = "102037";

    /**
     *通过ES查询售后单列表服务错误
     */
    public static final String RSP_CODE_ES_QRY_AFS_LIST_BUSI_ERROR = "102038";

    /**
     *中核商品比选单新增错误
     */
    public static final String RSP_CODE_CRE_COMP_GOODS_BUSI_ERROR = "102039";

    /**
     *同步计划信息到ES错误
     */
    public static final String RSP_CODE_SYNC_PLAN_LIST_BUSI_ERROR = "102040";

    /**
     *订单分配错误
     */
    public static final String RSP_CODE_ORD_ALLO_BUSI_ERROR = "102041";

    /**
     *订单退款错误
     */
    public static final String RSP_CODE_PAY_ORD_REF_BUSI_ERROR = "102042";

    /**
     *查询售后单列表页签数量错误
     */
    public static final String RSP_CODE_QRY_AFS_TAB_NUM_BUSI_ERROR = "102043";

    /**
     *订单审批错误
     */
    public static final String RSP_CODE_ORD_APPRO_BUSI_ERROR = "102044";

    /**
     *电子超市异常单审批错误
     */
    public static final String RSP_CODE_ZONE_ABNOR_AUD_BUSI_ERROR = "102045";

    /**
     *添加通知配置错误
     */
    public static final String RSP_CODE_ADD_NOT_CONF_BUSI_ERROR = "102046";

    /**
     *模板附件详情查询错误
     */
    public static final String RSP_CODE_QRY_ACC_TEMP_INFO_BUSI_ERROR = "102047";

    /**
     *专区异常单处理申请错误
     */
    public static final String RSP_CODE_ZONE_ABNOR_CRE_BUSI_ERROR = "102048";

    /**
     *无流程审批单审批错误
     */
    public static final String RSP_CODE_PEB_APPRO_BUSI_ERROR = "102049";

    /**
     *发货单同步ES错误
     */
    public static final String RSP_CODE_SHIP_SYNC_ES_BUSI_ERROR = "102050";

    /**
     *通过ES查询异常单列表错误
     */
    public static final String RSP_CODE_ES_QRY_ABNOR_LIST_BUSI_ERROR = "102051";

    /**
     *根据条件查询ES当中订单信息错误
     */
    public static final String RSP_CODE_ES_QRY_ORD_LIST_BUSI_ERROR = "102052";

    /**
     *订单中心核心转异常任务错误
     */
    public static final String RSP_CODE_CORE_TO_ERR_TASK_BUSI_ERROR = "102053";

    /**
     *通过ES查询采购单列表错误
     */
    public static final String RSP_CODE_ES_QRY_PUR_LIST_BUSI_ERROR = "102054";

    /**
     *查询通知配置错误
     */
    public static final String RSP_CODE_QRY_NOT_CONF_LIST_BUSI_ERROR = "102055";

    /**
     *查询异常单列表页签数量错误
     */
    public static final String RSP_CODE_QRY_ABNOR_TAB_NUM_BUSI_ERROR = "102056";

    /**
     *查询验收单列表错误
     */
    public static final String RSP_CODE_QRY_INS_LIST_BUSI_ERROR = "102057";

    /**
     *售后按批次维护发运信息错误
     */
    public static final String RSP_CODE_AFTER_MAIN_SHIP_INFO_BUSI_ERROR = "102058";

    /**
     *售后列表数据同步信息错误
     */
    public static final String RSP_CODE_SYNC_AFS_LIST_BUSI_ERROR = "102059";

    /**
     *专业机构索引表数据插入错误
     */
    public static final String RSP_CODE_CRE_PRO_ORD_IDX_BUSI_ERROR = "102060";

    /**
     *电子超市异常单审批错误
     */
    public static final String RSP_CODE_PEB_ABNOR_AUD_BUSI_ERROR = "102061";

    /**
     *京东确认售后错误
     */
    public static final String RSP_CODE_PEB_AFS_CONFIRM_BUSI_ERROR = "102062";

    /**
     *专区订单自动分配错误
     */
    public static final String RSP_CODE_ORD_AUTO_ASS_BUSI_ERROR = "102063";

    /**
     *通用流转处理错误
     */
    public static final String RSP_CODE_PEB_COMMON_FLOW_BUSI_ERROR = "102064";

    /**
     *验收单列表数据同步信息错误
     */
    public static final String RSP_CODE_SYNC_INS_LIST_BUSI_ERROR = "102065";

    /**
     *专区自动流程判断错误
     */
    public static final String RSP_CODE_AUTO_TASK_PRO_BUSI_ERROR = "102066";

    /**
     *电子超市售后服务申请错误
     */
    public static final String RSP_CODE_AFTER_SALE_REQ_BUSI_ERROR = "102067";

    /**
     *电子超市统一下单业务校验错误
     */
    public static final String RSP_CODE_CRE_ORD_CHECK_BUSI_ERROR = "102068";

    /**
     *模板附件增删列表查询错误
     */
    public static final String RSP_CODE_PEB_ACC_TEMP_BUSI_ERROR = "102069";

    /**
     *ES发货单列表查询错误
     */
    public static final String RSP_CODE_ES_QRY_SHIP_LIST_BUSI_ERROR = "102070";

    /**
     *电子超市更新或创建发货单错误
     */
    public static final String RSP_CODE_RET_NOT_SHIP_BUSI_ERROR = "102071";

    /**
     *电子超市订单妥投拒收错误
     */
    public static final String RSP_CODE_ORD_DEL_REJ_BUSI_ERROR = "102072";

    /**
     *组装结算自动开票错误
     */
    public static final String RSP_CODE_BUILD_FSC_BILL_ORD_AUTO_CRE_PAR_BUSI_ERROR = "102073";

    /**
     *询成交服务费列表错误
     */
    public static final String RSP_CODE_QRY_TRAN_SERV_LIST_BUSI_ERROR = "102074";

    /**
     *电子超市确认收货错误
     */
    public static final String RSP_CODE_SALE_ORD_CONF_ALL_BUSI_ERROR = "102075";

    /**
     *售后申请取消错误
     */
    public static final String RSP_CODE_AFTER_APP_FOR_CAN_BUSI_ERROR = "102076";

    /**
     *订单中心核心支付完成错误
     */
    public static final String RSP_CODE_PEB_CUT_PAY_BUSI_ERROR = "102077";

    /**
     *电子超市订单取消错误
     */
    public static final String RSP_CODE_PEB_ORD_CAN_BUSI_ERROR = "102078";

    /**
     *订单到货验收错误
     */
    public static final String RSP_CODE_PEB_ORD_ACC_BUSI_ERROR = "102079";

    /**
     *首钢订单取消处理电商消息错误
     */
    public static final String RSP_CODE_DEAL_CAN_MSG_BUSI_ERROR = "102080";

    /**
     *电商售后确认错误
     */
    public static final String RSP_CODE_PEB_AFTER_CONF_BUSI_ERROR = "102081";

    /**
     *预定单提交错误
     */
    public static final String RSP_CODE_PRE_ORD_SUB_BUSI_ERROR = "102082";

    /**
     *订单详细信息查询错误
     */
    public static final String RSP_CODE_QRY_AFTER_SERV_DET_BUSI_ERROR = "102083";

    /**
     *电子超市订单追踪查询错误
     */
    public static final String RSP_CODE_QRY_LOG_INFO_BUSI_ERROR = "102084";

    /**
     *电子超市自主到货登记错误
     */
    public static final String RSP_CODE_SHIP_ARR_CONF_BUSI_ERROR = "102085";

    /**
     *专区售后申请错误
     */
    public static final String RSP_CODE_ZONE_AFTER_APP_BUSI_ERROR = "102086";

    /**
     *通过拆单创建新的子订单错误
     */
    public static final String RSP_CODE_CRE_ORD_BY_ORD_SPL_BUSI_ERROR = "102087";

    /**
     *电子超市统一下单批量订单创建错误
     */
    public static final String RSP_CODE_CRE_SALE_ORD_BATCH_BUSI_ERROR = "102088";

    /**
     *电子超市预订单提交错误
     */
    public static final String RSP_CODE_PEB_PRE_ORD_SUB_BUSI_ERROR = "102089";

    /**
     *供应商索引列表数据插入错误
     */
    public static final String RSP_CODE_PEB_CRE_SUP_ORD_IDX_BUSI_ERROR = "102090";

    /**
     *查询外部推送消息定时任务错误
     */
    public static final String RSP_CODE_QRY_OUT_PUSH_MSG_BUSI_ERROR = "102091";

    /**
     *电子超市通过外部订单号查询售后服务单信息错误
     */
    public static final String RSP_CODE_QRY_AFS_ORD_BY_OUT_ORD_NO_BUSI_ERROR = "102092";

    /**
     *电子超市订单详情查询服务校验错误
     */
    public static final String RSP_CODE_QRY_ORD_DET_BUSI_ERROR = "102093";

    /**
     *异常单处理详情查询错误
     */
    public static final String RSP_CODE_QRY_ORD_ABNOR_DEAL_DET_BUSI_ERROR = "102094";

    /**
     *订单到货登记错误
     */
    public static final String RSP_CODE_PEB_ORD_REG_BUSI_ERROR = "102095";

    /**
     *更新订单支付单的状态错误
     */
    public static final String RSP_CODE_UPD_PAY_STA_BUSI_ERROR = "102096";

    /**
     *区特殊环节处理错误
     */
    public static final String RSP_CODE_PEB_TASK_HAND_BUSI_ERROR = "102097";

    /**
     *供应商到货确认拒绝错误
     */
    public static final String RSP_CODE_PRO_PUR_ARR_CONF_REJ_BUSI_ERROR = "102098";

    /**
     *更新售后单的京东售后服务单ID错误
     */
    public static final String RSP_CODE_UPD_JD_AFS_ID_BUSI_ERROR = "102099";

    /**
     *电子超市订单售后确认错误
     */
    public static final String RSP_CODE_PEB_SALE_AFTER_SERV_CONF_BUSI_ERROR = "102100";

    /**
     *统一发送通知错误
     */
    public static final String RSP_CODE_SEND_MSG_BUSI_ERROR = "102101";

    /**
     *更新结算相关配置错误
     */
    public static final String RSP_CODE_UPD_FSC_PAY_CONF_BUSI_ERROR = "102102";

    /**
     *更新表uoc_ord_ext_map字段field_value错误
     */
    public static final String RSP_CODE_UPD_FIELD_VAL_FOR_ORD_EXT_MAP_BUSI_ERROR = "102103";

    /**
     *中核三方电商下单错误
     */
    public static final String RSP_CODE_PEB_EXT_CRE_ORD_CHECK_BUSI_ERROR = "102104";

    /**
     *区域下单校验错误
     */
    public static final String RSP_CODE_ZONE_CRE_ORD_CHECK_BUSI_ERROR = "102105";

    /**
     *订单总价计算校验错误
     */
    public static final String RSP_CODE_SELF_CRE_ORD_CHECK_BUSI_ERROR = "102106";

    /**
     *订单中心核心订单创建错误
     */
    public static final String RSP_CODE_AGR_CRE_ORD_BUSI_ERROR = "102107";

    /**
     *自主下单错误
     */
    public static final String RSP_CODE_SELF_CRE_ORD_BUSI_ERROR = "102108";

    /**
     *中核三方电商下单错误
     */
    public static final String RSP_CODE_THIRD_SUP_CRE_ORD_BUSI_ERROR = "102109";
    //----------------------------------BUSI层，第三位2开头，END----------------------------------





    //----------------------------------COMB层，第三位3开头，START----------------------------------
    /**
     * 电子超市统一下单错误
     */
    public static final String RSP_CODE_PEB_CRE_ORDER_COMB_ERROR = "103000";
    
    /**
     * 电商通用订单跟踪错误
     */
    public static final String RSP_CODE_PEB_ORY_LOGI_INFO_COMB_ERROR = "103001";

    /**
     * 电子超市更新或创建发货单错误
     */
    public static final String RSP_CODE_PEB_EXT_RET_NOT_SHIP_COMB_ERROR = "103002";

    /**
     * 电子超市外部订单取消错误
     */
    public static final String RSP_CODE_PEB_EXT_ORD_CAN_COMB_ERROR = "103003";

    /**
     * 电子超市订单妥投拒收错误
     */
    public static final String RSP_CODE_PEB_ORD_DEL_REJ_COMB_ERROR = "103004";

    /**
     * 处理客户直接线下售后错误
     */
    public static final String RSP_CODE_DEAL_AFTER_BY_OFF_LINE_COMB_ERROR = "103005";

    /**
     * 再次加入购物车错误
     */
    public static final String RSP_CODE_AGAIN_ADD_SHIP_CART_COMB_ERROR = "103006";

    /**
     * 退货状态变更处理错误
     */
    public static final String RSP_CODE_CHG_BACK_GOODS_STA_COMB_ERROR = "103007";

    /**
     * 审批错误
     */
    public static final String RSP_CODE_PEB_APPRO_COMB_ERROR = "103008";

    /**
     * 电子超市售后服务申请错误
     */
    public static final String RSP_CODE_PEB_AFTER_SALE_REQ_COMB_ERROR = "103009";

    /**
     * 专区自动流程判断错误
     */
    public static final String RSP_CODE_PEB_AUTO_TASK_PRO_COMB_ERROR = "103010";

    /**
     * 订单索引生成错误
     */
    public static final String RSP_CODE_PEB_CRE_ORD_IDX_COMB_ERROR = "103011";

    /**
     * 订单取消，售后，异常 处理错误
     */
    public static final String RSP_CODE_PEB_REV_COMB_ERROR = "103012";

    /**
     * 电子超市结算扣款错误
     */
    public static final String RSP_CODE_PEB_CUT_PAY_COMB_ERROR = "103013";

    /**
     * 通用流转处理错误
     */
    public static final String RSP_CODE_PEB_COMM_FLOW_COMB_ERROR = "103014";

    /**
     * 电子超市外部订单拆成发货单错误
     */
    public static final String RSP_CODE_PEB_EXT_ORD_SPL_COMB_ERROR = "103015";

    /**
     * 京东售后详情同步定时任务处理错误
     */
    public static final String RSP_CODE_PEB_JD_AFS_SYNC_DET_STA_COMB_ERROR = "103016";

    /**
     * 同步订单ID错误
     */
    public static final String RSP_CODE_PEB_ORD_IDX_SYNC_COMB_ERROR = "103017";

    /**
     * 订单到货验收错误
     */
    public static final String RSP_CODE_PEB_ORD_ACC_COMB_ERROR = "103018";

    /**
     * 电子超市订单取消错误
     */
    public static final String RSP_CODE_PEB_ORD_CAN_COMB_ERROR = "103019";

    /**
     * 电子超市订单超额金额判断错误
     */
    public static final String RSP_CODE_PEB_ORD_MONEY_CHECK_COMB_ERROR = "103020";

    /**
     * 电子超市预订单提交错误
     */
    public static final String RSP_CODE_PEB_PRE_ORD_SUB_COMB_ERROR = "103021";

    /**
     * 电子超市全部验收错误
     */
    public static final String RSP_CODE_PEB_SALE_ORD_ALL_CONF_COMB_ERROR = "103022";

    /**
     * 订单七天自动取消定时任务错误
     */
    public static final String RSP_CODE_PEB_SALE_ORD_SEV_DAY_CAN_COMB_ERROR = "103023";

    /**
     * 电子超市自主到货登记错误
     */
    public static final String RSP_CODE_PEB_SHIP_ARR_CONF_COMB_ERROR = "103024";

    /**
     * 更新订单支付单的状态错误
     */
    public static final String RSP_CODE_PEB_UPD_PAY_STA_COMB_ERROR = "103025";

    /**
     * 电子超市企业异常订单列表查询错误
     */
    public static final String RSP_CODE_PEB_PUR_ORD_LIST_FOR_ABNOR_COMB_ERROR = "103026";

    /**
     * 环节调用服务错误
     */
    public static final String RSP_CODE_PEB_TACHE_CALL_SERV_COMB_ERROR = "103027";

    /**
     * 协议下单错误
     */
    public static final String RSP_CODE_AGR_CRE_ORD_COMB_ERROR = "103028";

    /**
     * 自主下单错误
     */
    public static final String RSP_CODE_SELF_CRE_ORD_COMB_ERROR = "103029";

    /**
     * 中核三方电商下单错误
     */
    public static final String RSP_CODE_THIRD_SUP_CRE_ORD_COMB_ERROR = "103030";

    //----------------------------------COMB层，第三位3开头，END----------------------------------






    //----------------------------------ABILITY层，第三位4开头，START----------------------------------
    /**
     * 合并下单调用错误
     */
    public static final String RSP_MERGE_CREATE_ORDER_ERROR = "104001";


    /**
     * 查询合并下单结果错误
     */
    public static final String RSP_QRY_ORDER_RESULT_ERROR = "104002";


    /**
     * 账期支付
     */
    public static final String RSP_DEAL_PAYMENT_ERROR = "104003";

    /**
     * 供应商到货确认、拒收错误
     */
    public static final String RSP_PURCHASE_ARRIVE_CONFIRM_ERROR = "104004";
    
    /**
     * 按批次维护发运信息错误
     */
    public static final String RSP_CODE_BATCH_MAINTAIN_SHIPINFO_ABILITY_ERROR = "104005"; 
    
    /**
     * 发货单已发货状态更新错误
     */
    public static final String RSP_CODE_RETAILER_NOTICE_ABILITY_ERROR = "104006";
    
    /**
     * 中核批量比选单打印错误
     */
    public static final String RSP_CODE_PRINT_BATCH_COMPARISON_ORDER_ABILITY_ERROR = "104007";
    
    /**
     * 订单详情打印导出错误
     */
    public static final String RSP_CODE_ORDER_DETAIL_PRINT_EXPORT_ABILITY__ERROR = "104008";
    
    /**
     * 售后列表导出错误
     */
    public static final String RSP_CODE_AFTER_SALE_LIST_EXPORT_ABILITY_ERROR = "104009";
    
    /**
     * 历史发货单导出错误
     */
    public static final String RSP_CODE_HIS_SHIP_PRINT_ABILITY_ERROR = "104010";
    
    /**
     * 单据统计信息查询错误
     */
    public static final String RSP_CODE_ORD_STATISTIC_ABILITY_ERROR = "104011";
    
    /**
     * 中核计划完结错误
     */
    public static final String RSP_CODE_PLAN_FINISH_ABILITY_ERROR = "104012"; 
    
    /**
     * 历史售后单导出错误
     */
    public static final String RSP_CODE_HIS_RETURN_PRINT_ABILITY_ERROR = "104013";

    /**
     * 订单列表导出错误
     */
    public static final String RSP_CODE_ORD_LIST_EXPORT_ABILITY_ERROR = "104014";

    /**
     * 京东订单交易模式查询错误
     */
    public static final String RSP_CODE_QRY_ORD_SETTLEMENT_ABILITY_ERROR = "104015";

    /**
     * 超验配置保存错误
     */
    public static final String RSP_CODE_CONFIG_SAVE_ABILITY_ERROR = "104016";

    /**
     * 售后类型查询错误
     */
    public static final String RSP_CODE_AFTER_SERVICE_TYPE_QRY_ABILITY_ERROR = "104017";

    /**
     * 历史验收单导出错误
     */
    public static final String RSP_CODE_HIS_INS_PRT_ABILITY_ERROR = "104018";

    /**
     * 电子超市售后申请错误
     */
    public static final String RSP_CODE_AFTER_SERVICE_APPLY_ABILITY_ERROR = "104019";

    /**
     * 订单关联合同错误
     */
    public static final String RSP_CODE_ORD_LINK_CONTRACT_ABILITY_ERROR = "104020";

    /**
     * 订单关联更新错误
     */
    public static final String RSP_CODE_ORD_REL_UPDATE_ABILITY_ERROR = "104021";

    /**
     * 收货4级地址信息错误
     */
    public static final String RSP_CODE_ORY_BUY_AGAIN_LOGISTICS_ABILITY_ERROR = "104022";

    /**
     * 订单评价配置处理错误
     */
    public static final String RSP_CODE_ORD_EVA_DEAL_ABILITY_ERROR = "104023";

    /**
     * 再次加入购物车错误
     */
    public static final String RSP_CODE_AGAIN_ADD_SHIP_CART_ABILITY_ERROR = "104024";

    /**
     * 绑定合同id错误
     */
    public static final String RSP_CODE_BIND_CONTRACT_ID_ABILITY_ERROR = "104025";

    /**
     * 订单对账状态更新错误
     */
    public static final String RSP_CODE_ORD_SYNC_CHECK_STATUS_ABILITY_ERROR = "104026";

    /**
     * 定时任务消息获取错误
     */
    public static final String RSP_CODE_PUSH_MSG_ABILITY_ERROR = "104027";

    /**
     * 供应商售后完成，采购方售后完成确认错误
     */
    public static final String RSP_CODE_COMPLETE_CONFIRM_ABILITY_ERROR = "104028";

    /**
     * 前端字典服务错误
     */
    public static final String RSP_CODE_PEB_DIC_ABILITY_ERROR = "104029";

    /**
     * 电商通用订单跟踪错误
     */
    public static final String RSP_CODE_ORY_LOG_INFO_ABILITY_ERROR = "104030";

    /**
     * 电子超市订单妥投拒收错误
     */
    public static final String RSP_CODE_ORD_DEL_REJ_ABILITY_ERROR = "104031";

    /**
     * 电子超市全部验收错误
     */
    public static final String RSP_CODE_SALE_ORD_CONFIRM_ABILITY_ERROR = "104032";

    /**
     *查看审批日志记录错误
     */
    public static final String RSP_CODE_APP_PRO_QRY_ABILITY_ERROR = "104033";

    /**
     *订单取消错误
     */
    public static final String RSP_CODE_ORD_CANCEL_ABILITY_ERROR = "104034";

    /**
     *物流信息查询错误
     */
    public static final String RSP_CODE_ORY_LOG_ABILITY_ERROR = "104035";

    /**
     *订单时效类配置处理错误
     */
    public static final String RSP_CODE_ORD_EFF_DEAL_ABILITY_ERROR = "104036";

    /**
     *订单按钮配置错误
     */
    public static final String RSP_CODE_ORD_BUTTON_SETTINGS_ABILITY_ERROR = "104037";

    /**
     *电子超市自主到货登记错误
     */
    public static final String RSP_CODE_SHIP_ARRIVAL_CONFIRM_ABILITY_ERROR = "104038";

    /**
     *删除订单错误
     */
    public static final String RSP_CODE_ORD_DEL_ABILITY_ERROR = "104039";

    /**
     *订单中心支付错误
     */
    public static final String RSP_CODE_ORD_PAY_ABILITY_ERROR = "104040";

    /**
     *订单下单限额配置处理错误
     */
    public static final String RSP_CODE_ORD_QUOTA_ALLOCATION_DEAL_ABILITY_ERROR = "104041";

    /**
     *查询差异化验收配置错误
     */
    public static final String RSP_CODE_PRO_INS_CONF_QRY_ABILITY_ERROR = "104042";

    /**
     *订单物料明细分页查询错误
     */
    public static final String RSP_CODE_ORD_ITEM_INFO_PAGE_QRY_ABILITY_ERROR = "104043";

    /**
     *订单支付回调错误
     */
    public static final String RSP_CODE_ORD_PAY_CALLBACK_ABILITY_ERROR = "104044";

    /**
     *查询三方电商可售后类型和取件方式错误
     */
    public static final String RSP_CODE_QRY_THIRD_AFTER_TYPE_AND_TAKE_ABILITY_ERROR = "104045";

    /**
     *查询审批候选人错误
     */
    public static final String RSP_CODE_QRY_CANDIDATE_ABILITY_ERROR = "104046";

    /**
     *中核订单详情导出错误
     */
    public static final String RSP_CODE_EXT_ORD_DETAIL_EXP_ABILITY_ERROR = "104047";
    /**
     * 计划同步
     */
    public static final String RSP_CODE_SYNC_ABILITY_ERROR = "104048";
    //----------------------------------ABILITY层，第三位4开头，END----------------------------------
}


