package com.tydic.dyc.oc.service.domainservice.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrder
 * 说明:验收单
 * 时间:2022-02-21 14:33
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocInspOrderBo implements Serializable {
	private static final long serialVersionUID = -6213206622150534568L;

	//验收单id")
	private Long inspOrderId;


	//执行明细id")
	private Long implOrderItemId;

	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//发货单编码")
	private String inspOrderNo;

	//外部发货单编码")
	private String inspOrderNoExt;

	//验收单名称")
	private String inspOrderName;

	//验收单类型")
	private Integer inspOrderType;

	//验收单状态")
	private String inspOrderState;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//实付金额")
	private BigDecimal usedFee;

	//开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	//流转状态")
	private String procState;

	//对账状态")
	private String checkState;

	//租户ID")
	private String tenantId;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//验收人电话")
	private String inspOperPhone;

	//验收人名字")
	private String inspOper;

	//允许变更时限")
	private Date allowChngTime;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//备注")
	private String remark;

	//其它备注")
	private String otherRemark;

	//竣工时间")
	private Date finishTime;

	//逾期时间")
	private Date expTime;

	//总金额")
	private BigDecimal totalFee;

	//总数量")
	private Integer totalCount;

	//验收明细")
	private List<UocInspOrderItemBo> uocInspOrderItemList;

	//验收发货关系")
//	private List<UocShipInspRel> uocShipInspRelList;
//
//	//纵向扩展")
//	private List<UocInspOrderMap> extParallelBoList;
//
//	//附件")
//	private List<UocOrderAccessory> uocOrderAccessoryList;

	//订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;

	//订单IDList")
	private List<Long> orderIdList;

	//验收单明细IdList")
	private List<Long> inspOrderItemsIdList;

	//发货明细ID")
	private Long shipOrderItemId;

	//验收变更数量")
	private BigDecimal inspCount;
}
