package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryMsgRspBo extends BaseRspBo {
    /**
     * ID主键(必填项)
     */
    private Long id;
    /**
     * 消息ID(必填项)
     */
    private String msgId;
    /**
     * 消息类型
     * 1   代表订单拆分变更
     * 2   代表商品价格变更
     * 5   代表该订单已妥投（买断模式代表外单已妥投或外单已拒收）
     * 10 代表订单取消（不区分取消原因）
     */
    private Integer msgType;
    /**
     * 消息内容(必填项)
     */
    private String msgContent;
    /**
     * 状态
     */
    private Integer msgState;
    /**
     * 单据ID
     */
    private Long objId;
    /**
     * 单据类型
     * 1订单
     * 2.销售单
     * 3 发货单
     * 4.收货单
     * 5.售后服务单
     * <p>
     * 99.其他
     */
    private Integer objType;
    /**
     * 订单ID(必填项)
     */
    private Long orderId;
    /**
     * 供货商ID(必填项)
     */
    private Long supNo;
    /**
     * 创建时间(必填项)
     */
    private Date createTime;
    /**
     * 消息推送时间(必填项)
     */
    private Date pushTime;
    //修改时间
    private Date chngTime;
    /**
     * 运行状态
     * 0 失败
     * 1 成功
     * 2 待处理
     */
    private Integer runResult;
    //失败次数
    private Integer failureCount;
    //失败原因
    private String failureReason;
    //外部订单ID
    private String outOrderId;
    //订单类型
    private Integer orderType;
    //不识别类型记录
    private String resultString;
    //发货单号
    private String packageId;
    //售后单号
    private String serviceId;
    //外部父订单
    private String pOrderId;
    /**
     * 排序
     */
    private String orderBy;
}
