package com.tydic.dyc.oc.service.domainservice.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 描述: 〈供应商信息〉
 * @author : yuhao
 * @date : 2022/8/8 15:53
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSupplierInfoBo implements Serializable {

    private static final long serialVersionUID = 3783593955029417797L;
    /**
     * 供应商ID
     */
    private Long supplierId;
    /**
     * 供应商编码
     */
    private String supplierCode;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 供应商联系人
     */
    private String supRelaName;
    /**
     * 供应商联系电话
     */
    private String supRelaMobile;
    /**
     * 供应商联系人邮箱
     */
    private String contactEmail;
    /**
     * 例外的商品类型
     */
    private List<String> extSkuCategoryIds;
    /**
     * 支付配置信息
     */
    private List<UocCreateOrderServiceReqPayConfBo> payConfigBos;
    /**
     * 例外支付配置信息
     */
    private List<UocCreateOrderServiceReqPayConfBo> extPayConfigBos;
    /**
     * 是否收取月度成交服务费
     * 1 收取 0 不收取'
     */
    private String monthServiceFee;
    /**
     * 月度收取节点 1下单成功后收取 2 验收成功后收取'
     */
    private String monthReceiveNode;
    /**
     * 是否收取年度成交服务费 1 收取 0 不收取'
     */
    private String yearServiceFee;
    /**
     * 年度度收取节点 1下单成功后收取 2 验收成功后收取'
     */
    private String yearReceiveNode;
    /**
     * 销售品类信息
     */
    private List<UocSupplierSignContractSalesBO> salesBOS;
//    /**
//     *年度规则信息
//     */
//    private List<DycUocSupplierSignContractYearFuncBO> contractYearBOS;
    /**
     * 机构数
     */
    private String supOrgPath;
}
