package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupTransFeeBO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 描述: 〈领域服务-销售单详情查询 出参〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocGetSaleOrderDetailServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = -4841620251700130359L;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 外部电商单号
     */
    private String outOrderId;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 订单时间
     */
    private Date orderTime;

    /**
     * 三方信息id
     */
    private Long stakeholderId;

    /**
     * 销售单编码
     */
    private String saleOrderNo;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;

    /**
     * 销售单名称
     */
    private String saleOrderName;

    /**
     * 销售单类型
     */
    private Integer saleOrderType;

    /**
     * 销售单状态
     */
    private String saleOrderState;

    /**
     * 销售单状态翻译
     */
    private String saleOrderStateStr;

    /**
     * 供应商是否确认
     */
    private Boolean isSupplierConfirmFlag;

    /**
     * 销售单单说明
     */
    private String saleOrderDesc;

    /**
     * 订单来源 1 自营单品  2 电商导入 3 协议生成
     */
    private Integer orderSource;

    /**
     * 订单来源翻译
     */
    private String orderSourceStr;

    /**
     * 支付类型
     */
    private Integer payMod;

    /**
     * 付款方式，0 预付款按比例支付,1 按协议约束支付,2 按账期支付
     */
    private String payType;

    /**
     * 付款方式翻译
     */
    private String payTypeStr;
    /**
     * 商品销售总金额
     */
    private BigDecimal totalGoodsSaleFee;

    /**
     * 商品采购总金额
     */
    private BigDecimal totalGoodsPurchaseFee;

    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 优惠金额
     */
    private BigDecimal totalActShareFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 协议编号
     */
    private String agreementNo;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 支付状态，1400（待支付），1401（已付款），1402（付款失败）
     */
    private Integer payState;

    /**
     * 支付状态翻译，1400（待支付），1401（已付款），1402（付款失败）
     */
    private String payStateStr;

    /**
     * 环节编码
     */
    private String procState;

    /**
     * 税率
     */
    private String taxRate;

    /**
     * 付款比例
     */
    private String payRatio;

    /**
     * 竣工标志 1 竣工  0 在途
     */
    private Integer finishFlag;

    /**
     * 竣工标志翻译
     */
    private String finishFlagStr;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 订单时间
     */
    private Date createTime;

    /**
     * 创建人姓名
     */
    private String createOperName;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 取消时间
     */
    private Date cancelTime;

    /**
     * 取消人工号
     */
    private String cancelOperId;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 更新人名称
     */
    private String updateOperName;

    /**
     * 取消人
     */
    private String cancelOperName;

    /**
     * 供应商拒单原因
     */
    private String rejectReason;

    /**
     * 供应商拒单时间
     */
    private Date rejectTime;

    /**
     * 供应商拒单人
     */
    private String rejectOperId;

    /**
     * 供应商拒单人名称
     */
    private String rejectOperName;

    /**
     * 竣工时间
     */
    private Date finishTime;

    /**
     * 逾期时间
     */
    private Date expTime;

    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;

    /**
     * 结算模式翻译
     */
    private String modelSettleStr;

    /**
     * 采购类别1 物资 2 施工 3 服务
     */
    private Integer purchaseType;

    /**
     * 采购类别翻译
     */
    private String purchaseTypeStr;

    /**
     * 备注
     */
    private String remark;

    /**
     * 期望送达时间
     */
    private Date sendTime;

    /**
     * 采购方账套id
     */
    private String purAccount;

    /**
     * 采购方账套名称
     */
    private String purAccountName;

    /**
     * 采购方联系人
     */
    private String purContactName;

    /**
     * 采购方联系人电话
     */
    private String purMobile;

    /**
     * 采购方下单人用户id
     */
    private String purUserId;

    /**
     * 采购方下单人真实姓名
     */
    private String purUocStateChngOrderCreateServiceName;


    /**
     * 采购方下单人真实姓名
     */
    private String purName;

    /**
     * 采购方下单人登录名
     */
    private String purUserName;

    /**
     * 采购方公司id
     */
    private String purCompanyId;

    /**
     * 采购公司编码
     */
    private String purCompanyNo;

    /**
     * 采购方公司名称
     */
    private String purCompanyName;

    /**
     * 采购方机构id
     */
    private String purOrgId;

    /**
     * 采购方机构编码
     */
    private String purOrgNo;

    /**
     * 采购方机构名称
     */
    private String purOrgName;

    /**
     * 下单组织机构路径
     */
    private String purOrgPath;

    /**
     * 需方联系人名称
     */
    private String purNeedName;

    /**
     * 需方联系电话
     */
    private String purNeedMobile;

    /**
     * 供应商id
     */
    private String supId;

    /**
     * 供应商编码
     */
    private String supNo;

    /**
     * 供应商名称
     */
    private String supName;

    /**
     * 供应商联系人
     */
    private String supRelaName;

    /**
     * 供应商联系电话
     */
    private String supRelaMobile;

    /**
     * 运营单位机构id
     */
    private String proId;

    /**
     * 运营单位机构编码
     */
    private String proNo;

    /**
     * 运营机构名称
     */
    private String proName;

    /**
     * 运营机构机构树路径
     */
    private String proOrgPath;

    /**
     * 运营机构账户名称
     */
    private String proAccountName;

    /**
     * 运营机构账户
     */
    private String proAccount;

    /**
     * 运营机构联系人
     */
    private String proRelaName;

    /**
     * 运营机构联系电话
     */
    private String proRelaMobile;

    /**
     * 协议经办人id（配送专责）
     */
    private String proDeliveryId;

    /**
     * 协议经办人名字（配送专责）
     */
    private String proDeliveryName;

    /**
     * 采购模式 1计划，2非计划
     */
    private Integer purchaseMode;

    /**
     * 采购模式翻译
     */
    private String purchaseModeStr;

    /**
     * 铺货单位id
     */
    private String distirbutionId;

    /**
     * 铺货单位名称
     */
    private String distirbutionName;

    /**
     * 铺货单位联系人
     */
    private String distirbutionIdContactName;

    /**
     * 铺货单位电话
     */
    private String distirbutionIdContactMobile;

    /**
     * 三方信息
     */
    private UocGetSaleOrderDetailServiceRspStakeholderBo uocGetSaleOrderDetailServiceRspStakeholderBo;

    /**
     * 收获人地址信息
     */
    private UocGetSaleOrderDetailServiceRspReceiverAddressBo receiverAddressBo;

    /**
     * 发票信息
     */
    private UocGetSaleOrderDetailServiceRspInvoiceBo invoiceBo;

    /**
     * 发票邮寄信息
     */
    private UocGetSaleOrderDetailServiceRspReceiverAddressBo invoiceAddressBo;

    /**
     * 下单附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> orderAccessoryList;

    /**
     * 据单附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> rejectAccessoryList;

    /**
     * 取消附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> cancelAccessoryList;
    
    /**
     * 取消申请附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> cancelApplyAccessoryList;

    /**
     * 到货登记附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> arriveRegistAccessoryList;


    /**
     * 销售单纵向拓展信息
     */
    private List<UocBaseExtParallelBo> saleOrderDetailServiceRspExtBoList;


    /**
     * 销售单明细信息
     */
    private List<UocGetSaleOrderDetailServiceRspItemBo> saleOrderDetailServiceRspItemBoList;


    /**
     * 流程数据
     */
    private UocGetSaleOrderDetailServiceRspPorcBo procInst;

    /**
     * 已完成环节数据-移动端专用
     */
    private List<UocGetSaleOrderDetailServiceRspPorcBo> finishTacheInfo;

    /**
     * 审批流程数据
     */
    private UocGetSaleOrderDetailServiceRspPorcBo auditProcInst;

    /**
     * 协议信息
     */
    private UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfo;

    /**
     * 订单核实信息
     */
    private UocGetSaleOrderDetailServiceRspVerifyInfoBo orderVerifyInfo;

    /**
     * 发货单信息
     */
    private List<UocGetSaleOrderDetailServiceRspShipOrderInfoBo> shipOrderInfo;

    /**
     * 验收单信息
     */
    private List<UocGetSaleOrderDetailServiceRspInspOrderInfoBo> inspOrderInfo;

    /**
     * 支付单信息
     */
    private List<UocGetSaleOrderDetailServiceRspShouldPayOrderBo> payOrderInfo;

    /**
     * 审批单列表
     */
    private List<UocSaleOrderAuditBO> auditOrderBoList;

    /**
     * 整单审批单列表
     */
    private List<UocSaleOrderAuditBO> wholeAuditOrderBoList;
    
    
    /**
     *
     * 审批单plus列表
     */
    private List<UocSaleOrderAuditBO> approvalPlusAuditOrderList;
    
    /**
     *是否有收发货详情
     */
    private Boolean isShipFlag;

    /**
     * 商品类型剩余可超验数量
     */
    List<UocGetSaleOrderDetailServiceRspItemBo> commodityTypeInspSuperCountList;


    /**
     * 预算模式
     */
    private String budgetModelCode;
    private String budgetModelName;

    /**
     * 财务事项申请单id
     */
    private String financialId;
    /**
     * 财务事项申请单名称
     */
    private String financialName;


    /**
     * 成本中心id
     */
    private String costCenterId;
    /**
     * 成本中心名称
     */
    private String costCenterName;


    /**
     * 归口部门
     */
    private String relevantDeptName;



    /**
     * 预算项目id
     */
    private String budgetProjectId;
    /**
     * 预算项目名称
     */
    private String budgetProjectName;


    /**
     * 是否统采订单 0:是；1不是
     */
    private String unifiedPurOrderFlag;

    /**
     * 是否统采订单 0:是；1不是
     */
    private String unifiedPurOrderFlagStr;


    /**
     * 收支项目id
     */
    private String incomeAndExpProjectId;
    /**
     * 收支项目名称
     */
    private String incomeAndExpProjectName;

    /**
     * 服务失效时间
     */
    private String serviceFailTime;
    /**
     * 服务生效时间
     */
    private String serviceEffectiveTime;
    /**
     * 是否it合同翻译
     */
    private String itAgrOrderCode;
    /**
     * 是否it类协议订单
     */
    private String itAgrOrderCodeStr;
    /**
     * 合同编号
     */
    private String jhContractNo;
    /**
     * 项目类型
     */
    private String jhAgrProjectType;
    /**
     * 主办部门
     */
    private String jhAgrDepartment;
    /**
     * 合同类别
     */
    private String jhAgrContractType;

    /**
     * 铺货单位ID
     */
    private String managementOrgId;
    /**
     * 铺货单位名称
     */
    private String managementOrgName;
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 发货单id（用英文逗号拼接）
     */
    private String shipOrderIds;

    private String orderCode;
    /**
     * 申请人
     */
    private String applicationName;
    /**
     * 申请主题
     */
    private String applicationTheme;

    /**
     * 申请类型(1.部门申请;2.项目申请)
     */
    private String applicationType;
    /**
     * 申请部门/项目名称
     */
    private String applicationDept;

    /**
     * 采购类型(1.MRO;2.非MRO)
     */
    private String purchaseAppType;
    /**
     * 扣款账户
     */
    private String reduceAccount;
    /**
     * 扣款账户
     */
    private String reduceAccountStr;
    /**
     * 申请单号
     */
    private String applicationCode;
    /**
     * 审批流编码
     */
    private String auditFlowKey;

    /**
     * 原始父订单编号
     */
    private String oldParentOrderCode;

    /**
     * 已占用运费
     */
    private BigDecimal totalOccupyTransFee;
    /**
     * 审批完成时间
     */
    private Date auditFinishTime;
    /**
     * 待发货完成时间
     */
    private Date toSendFinishTime;
    /**
     * 发货完成时间
     */
    private Date sendFinishTime;
    /**
     * 订单完成时间
     */
    private Date completeFinishTime;
    /**
     * 申请类型(1.部门申请;2.项目申请)
     */
    private String applicationTypeStr;
    /**
     * 采购类型(1.MRO;2.非MRO)
     */
    private String purchaseAppTypeStr;
}


