package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupTransFeeBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderAuditBO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:48
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocGetOrderAllDetailServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = -6763251865187297180L;

    /**
     * 采购方编码
     */
    private String purNo;

    /**
     * 采购方名称
     */
    private String purName;

    /**
     * 采购方账户名称
     */
    private String purAccountName;

    /**
     * 采购方账户
     */
    private String purAccount;

    /**
     * 采购方账户持有人编码
     */
    private String purAccountOwnId;

    /**
     * 采购方账户持有人名称
     */
    private String purAccountOwnName;

    /**
     * 采购方联系人电话
     */
    private String purMobile;

    /**
     * 采购方下单人编号
     */
    private String purPlaceOrderId;

    /**
     * 采购方下单人名称
     */
    private String purPlaceOrderName;

    /**
     * 采购方下单人登录名
     */
    private String purLogName;

    /**
     * 采购方公司id
     */
    private String purCompanyId;

    /**
     * 采购方公司名称
     */
    private String purCompanyName;

    /**
     * 下单组织机构编码
     */
    private String purOrgId;

    /**
     * 下单组织机构路径
     */
    private String purOrgPath;

    /**
     * 需方联系人名称
     */
    private String purRelaName;

    /**
     * 需方联系电话
     */
    private String purRelaMobile;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 父订单id
     */
    private Long upperOrderId;

    /**
     * 订单编码
     */
    private String orderNo;

    /**
     * 外部订单编码
     */
    private String orderNoExt;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 订单级别 1 个人订单 2 企业订单
     */
    private Integer orderLevel;

    /**
     * 支付类型
     */
    private Integer payMod;

    /**
     * 支付方式
     */
    private String payType;

    /**
     * 支付方式翻译
     */
    private String payTypeStr;

    /**
     * 支付状态
     */
    private String payState;

    /**
     * 支付状态翻译
     */
    private String payStateStr;

    /**
     * 订单状态
     */
    private String orderState;

    /**
     * 订单状态翻译
     */
    private String orderStateStr;

    /**
     * 采购模式 1计划，2非计划
     */
    private Integer purchaseMode;

    /**
     * 采购模式翻译
     */
    private String purchaseModeStr;

    /**
     * 流转状态
     */
    private String procState;

    /**
     * 订单说明
     */
    private String orderDesc;

    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;
    /**
     * 销售金额
     */
    private BigDecimal totalGoodsSaleFee;

    /**
     * 采购金额
     */
    private BigDecimal totalGoodsPurchaseFee;

    /**
     * 优惠金额
     */
    private BigDecimal totalActShareFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 竣工标志 1 竣工  0 在途
     */
    private Integer finishFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 撤单时间
     */
    private Date cancelTime;

    /**
     * 撤单工号
     */
    private String cancelOperId;

    /**
     * 撤单人名称
     */
    private String cancelOperName;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 竣工时间
     */
    private Date finishTime;

    /**
     * 逾期时间
     */
    private Date expTime;

    /**
     * 地址信息
     */
    private UocGetOrderAllDetailServiceRspOrderLogisticsBo logisticsBo;

    /**
     * 发票信息
     */
    private UocGetOrderAllDetailServiceRspOrderInvoiceBo invoiceBo;

    /**
     * 商品信息
     */
    private List<UocGetOrderAllDetailServiceRspOrderCommInfoBo> commInfoBos;

    /**
     * 附件
     */
    private List<UocGetOrderAllDetailServiceRspAccessoryBo> accessoryBos;

    /**
     * 订单流程实例
     */
    private List<UocGetOrderAllDetailServiceRspProcInstBo> procInstBos;

    /**
     * 订单横向扩展数据
     */
    private UocBaseExtCrossBo extCrossBo;

    /**
     * 订单纵向扩展数据
     */
    private List<UocBaseExtParallelDetailBo> extParallelBo;

    /**
     * 订单三方信息
     */
    private List<UocGetOrderAllDetailServiceRspSaleStakeBo> saleStakeBos;

    /**
     * 审批状态
     */
    private String auditOrderStatus;

    /**
     * 审批状态
     */
    private String auditOrderStatusStr;
    /**
     * 申请人
     */
    private String applicationName;
    /**
     * 申请主题
     */
    private String applicationTheme;

    /**
     * 申请类型(1.部门申请;2.项目申请)
     */
    private String applicationType;
    /**
     * 申请类型(1.部门申请;2.项目申请)
     */
    private String applicationTypeStr;
    /**
     * 申请部门/项目名称
     */
    private String applicationDept;

    /**
     * 采购类型(1.MRO;2.非MRO)
     */
    private String purchaseAppType;
    /**
     * 采购类型(1.MRO;2.非MRO)
     */
    private String purchaseAppTypeStr;
    /**
     * 扣款账户
     */
    private String reduceAccount;
    /**
     * 扣款账户
     */
    private String reduceAccountStr;
    /**
     * 申请单号
     */
    private String applicationCode;
    /**
     * 审批流编码
     */
    private String auditFlowKey;

    /**
     * 原始父订单编号
     */
    private String oldParentOrderCode;

    /**
     * 已占用运费
     */
    private BigDecimal totalOccupyTransFee;
    /**
     * 审批单列表
     */
    private List<UocSaleOrderAuditBO> auditOrderBoList;
    /**
     * 审批流程数据
     */
    private UocGetSaleOrderDetailServiceRspPorcBo auditProcInst;
}


