package com.tydic.dyc.oc.constants;

/**
 * 标题:UocStatusConstants
 * 说明:订单中心状态常量
 * 时间:2022/3/3 14:04
 * 作者:田桂银
 */
public class UocStateConstants {

    /**
     * 销售单状态
     */
    public static class SaleOrder {

        /**
         * 创建-创建
         */
        public static final String XS_CJ_CJ = "XS_CJ_CJ";

        /**
         * 分配-待分配
         */
        public static final String XS_FP_DFP = "XS_FP_DFP";

        /**
         * 分配-分配中
         */
        public static final String XS_FP_FPZ = "XS_FP_FPZ";

        /**
         * 调价-待调价
         */
        public static final String XS_TJ_DTJ = "XS_TJ_DTJ";

        /**
         * 调价-提交审批
         */
        public static final String XS_TJ_TJSP = "XS_TJ_TJSP";

        /**
         * 确认-待确认
         */
        public static final String XS_QR_DQR = "XS_QR_DQR";

        /**
         * 确认-拒单待处理
         */
        public static final String XS_QR_JDDCL = "XS_QR_JDDCL";

        /**
         * 确认-已拒单
         */
        public static final String XS_QR_JD = "XS_QR_JD";

        /**
         * 审批-待审批
         */
        public static final String XS_SP_DSP = "XS_SP_DSP";

        /**
         * 审批-审批中
         */
        public static final String XS_SP_SPZ = "XS_SP_SPZ";

        /**
         * 审批-驳回
         */
        public static final String XS_SP_BH = "XS_SP_BH";

        /**
         * 付款-付款中
         */
        public static final String XS_FK_FKZ = "XS_FK_FKZ";

        /**
         * 发货-待发货
         */
        public static final String XS_FH_DFH = "XS_FH_DFH";

        /**
         * 发货-发货中
         */
        public static final String XS_FH_FHZ = "XS_FH_FHZ";

        /**
         * 发货-发货完成
         */
        public static final String XS_FH_FHWC = "XS_FH_FHWC";

        /**
         * 到货-部分到货
         */
        public static final String XS_DH_BFDH = "XS_DH_BFDH";

        /**
         * 到货-全部到货确认
         */
        public static final String XS_DH_DH = "XS_DH_DH";

        /**
         * 到货-拒收
         */
        public static final String XS_DH_JS = "XS_DH_JS";

        /**
         * 验收-部分验收
         */
        public static final String XS_YS_BFYS = "XS_YS_BFYS";

        /**
         * 验收-验收
         */
        public static final String XS_YS_YS = "XS_YS_YS";

        /**
         * 取消-取消申请中
         */
        public static final String XS_QX_QXSQ = "XS_QX_QXSQ";

        /**
         * 取消-已取消
         */
        public static final String XS_QX_QX = "XS_QX_QX";

        /**
         * 下单失败
         */
        public static final String XS_XD_SB = "XS_XD_SB";
        
        /*已拆单*/
        public static final String XS_SPLIT = "XS_SPLIT";
    
        /*预算核验中*/
        public static final String XS_YSHYZ = "XS_YSHYZ";
    
        /*履约中*/
        public static final String XS_LYZ = "XS_LYZ";
        /**
         * 	供应商调价
         */
        public static final String XS_SUP_ADJUST = "XS_SUP_ADJUST";
        /**
         * 	运营确认调价
         */
        public static final String XS_PRO_ADJUST = "XS_PRO_ADJUST";
        /**
         * 	采购单位确认调价
         */
        public static final String XS_PUR_ADJUST = "XS_PUR_ADJUST";

    }

    /**
     * 整单状态
     */
    public static class Order {
        public static final String P_CODE = "WHOLE_ORDER_STATE_BACK";
        /**
         * 审批-驳回取消
         */
        public static final String ZD_SP_BHQX = "ZD_SP_BHQX";
        /**
         * 审批-取消
         */
        public static final String ZD_SP_QX = "ZD_SP_QX";

        /**
         * 审批-通过
         */
        public static final String ZD_SP_TG = "ZD_SP_TG";

    }

    /**
     * 销售单环节编码
     */
    public static class SaleTachCode {

        /**
         * 待发货
         */
        public static final String TC1_DFH = "E0005";
        public static final String TC2_DFH = "E0006";
        public static final String TC3_DFH = "E0009";

        /**
         * 等待拒收环节编码
         */
        public static final String XS_DH_JS = "E0011";
    }

    /**
     * 验收单状态
     */
    public static class InspOrder {

        public static final String P_CODE = "INSP_ORDER_STATE";

        /**
         * 验收-验收
         */
        public static final String YS_YS_YS = "YS_YS_YS";
    }

    /**
     * 发货单状态
     */
    public static class ShipOrder {
        /**
         * 字典
         */
        public static final String P_CODE = "SHIP_ORDER_STATE";
        /**
         * FH_FH_YFH 已发货
         */
        public static final String FH_FH_FH = "FH_FH_FH";
        /**
         * FH_FH_DQR 到货待确认
         */
        public static final String FH_FH_DQR = "FH_FH_DQR";
        /**
         * FH_FH_YDH 已到货
         */
        public static final String FH_FH_YSH = "FH_FH_YDH";
        /**
         * FH_FH_JS 已拒收
         */
        public static final String FH_FH_JS = "FH_FH_JS";
        /**
         * FH_FH_YS 已验收
         */
        public static final String FH_FH_YS = "FH_FH_YS";
    }

    /**
     * 异常单状态
     */
    public static class ChngOrder {
        /**
         * 数量变更
         */
        public static class NUM {
            /**
             * 字典
             */
            public static final String P_CODE = "CHNG_ORDER_STATE_NUM";
            /**
             * 确认中 CHNG_CHNG_QRZ
             */
            public static final String CHNG_CHNG_QRZ = "CHNG_CHNG_QRZ";
            /**
             * 确认 CHNG_CHNG_QR
             */
            public static final String CHNG_CHNG_QR = "CHNG_CHNG_QR";
            /**
             * 拒绝 CHNG_CHNG_JJ
             */
            public static final String CHNG_CHNG_JJ = "CHNG_CHNG_JJ";
        }

        /**
         * 销售单取消 取消申请单状态
         */
        public static class SALE_ORDER_CANCEL {
            /**
             * 字典
             */
            public static final String P_CODE = "CHNG_ORDER_STATE_SALE_ORDER_CANCEL";
            /**
             * 取消申请中/供应商确认中 CHNG_XS_QXSQZ
             */
            public static final String CHNG_XS_QXSQZ = "CHNG_XS_QXSQZ";
            /**
             * 已确认 CHNG_XS_YQR
             */
            public static final String CHNG_XS_YQR = "CHNG_XS_YQR";
            /**
             * 已拒绝 CHNG_XS_YJJ
             */
            public static final String CHNG_XS_YJJ = "CHNG_XS_YJJ";
            /**
             * 已撤销 CHNG_XS_YCX
             */
            public static final String CHNG_XS_YCX = "CHNG_XS_YCX";
        }

        /**
         * 异常变更
         */
        public static class CHNG_ORDER_STATE {
            /**
             * 字典
             */
            public static final String P_CODE = "CHNG_ORDER_STATE";
            /**
             * 确认 CHNG_CHNG_QR
             */
            public static final String CHNG_CHNG_QR = "CHNG_CHNG_QR";
        }

        /**
         * 变更类型 1:状态变更 2:采购价变更 3:销售价变更 4:加价率变更
         */
        public static class CHNG_TYPE {
            /**
             * 字典(电商包含更全)
             */
            public static final String P_CODE = "EC_CHNG_ORDER_TYPE";
            /**
             * 状态变更
             */
            public static final Integer STATE_CHNG = 1;
            /**
             * 采购价变更
             */
            public static final Integer PURCHASE_PRICE_CHNG= 2;
            /**
             * 销售价变更
             */
            public static final Integer SALE_PRICE_CHNG = 3;
            /**
             * 加价率变更
             */
            public static final Integer MARKUP_RATE_CHNG = 4;
        }
    }


    /**
     * 售后订单状态
     */
    public static class AFOrder {
        /**
         * 字典
         */
        public static final String P_CODE = "AF_ORDER_STATE";
        /**
         * AF_AF_DQR 待确认
         */
        public static final String AF_AF_DQR = "AF_AF_DQR";
        /**
         * AF_AF_QX 取消
         */
        public static final String AF_AF_QX = "AF_AF_QX";
        /**
         * AF_AF_QR 确认售后
         */
        public static final String AF_AF_QR = "AF_AF_QR";
        /**
         * AF_AF_JJ 拒绝
         */
        public static final String AF_AF_JJ = "AF_AF_JJ";
        /**
         * AF_AF_COMPLATE 售后完成
         */
        public static final String AF_AF_COMPLATE = "AF_AF_COMPLATE";
        /**
         * AF_AF_QRWC 确认售后完成
         */
        public static final String AF_AF_QRWC = "AF_AF_QRWC";
    }


    /**
     * 支付单状态
     */
    public static class PAY_STATUS {
        /**
         * 待付款
         */
        public static final Integer WAIT_PAY = 1400;
        /**
         * 已付款
         */
        public static final Integer PAYED = 1401;
        /**
         * 付款失败
         */
        public static final Integer PAYED_FAILED = 1402;
    }

    /**
     * 售后服务单状态
     */
    public static class AFTER_SALE_STATUS {
        /**
         * 已申请待供方确认
         */
        public static final Integer APPLIED_WAIT_SUPPLIER_CONFIRM = 2501;
        /**
         * 售后中
         */
        public static final Integer AFTER_SALE_ING = 2503;
        /**
         * 售后拒绝
         */
        public static final Integer AFTER_SALE_REJECT = 2504;
        /**
         * 已取消
         */
        public static final Integer CANCELED = 2505;
        /**
         * 供方标记售后完成
         */
        public static final Integer SUPPLIER_MARK_AFTER_SALE_FINISHED = 2507;
        /**
         * 买方确认售后完成
         */
        public static final Integer BUYER_CONFIRM_AFTER_SALE_FINISHED = 2508;
    }

    /**
     * 审批单状态
     */
    public static final class AUDIT_ORDER_STATUS {
        /**
         * 驳回
         */
        public static final String REJECT = "0";
        /**
         * 通过
         */
        public static final String PASS = "1";
        /**
         * 待审批
         */
        public static final String WAIT_AUDIT = "2";
    }
    
    public static final class AUDIT_PLUS_ORDER_STATUS {
        /**
         * 审批中
         */
        public static final String AUDITING = "0";
        /**
         * 已审批
         */
        public static final String AUDITED = "1";
        /**
         * 已撤销
         */
        public static final String REVOKE = "3";
    }
    
    /**
     * 变更状态
     */
    public static final class CHNG_STATES {
        /**
         * 字典
         */
        public static final String P_CODE = "ORD_SHIP_ABNORMAL_STATUS";
        /**
         * JS 拒收
         */
        public static final String JS = "FH_FH_JS";

        /**
         * TT 妥投
         */
        public static final String TT = "FH_FH_YDH";
    }
    /**
     * 议价单状态
     */
    public static class BARGAINING_STATES {

        /**
         * 发起议价-报价中
         */
        public static final String YJ_BJZ = "YJ_BJZ";

        /**
         * 供应商-已报价
         */
        public static final String YJ_YBJ = "YJ_YBJ";

        /**
         * 已终止
         */
        public static final String YJ_YZZ = "YJ_YZZ";

        /**
         * 已下单
         */
        public static final String YJ_YXD = "YJ_YXD";

        /**
         * 发起议价-待报价
         */
        public static final String YJ_DBJ = "YJ_DBJ";
        /**
         * 议价失败
         */
        public static final String YJ_SB = "YJ_SB";


    }

    /**
     * 议价-报价单状态
     */
    public static class BARGAINING_QUOTATION_STATES {

        /**
         * 未报价
         */
        public static final String BJ_WBJ = "0";

        /**
         * 已报价
         */
        public static final String BJ_YBJ = "1";
        /**
         * 报价失败
         */
        public static final String BJ_FAIL = "3";
        /**
         * 已中标
         */
        public static final String BJ_WON_BID = "4";


    }

    /**
     * 验收单支付状态，10未支付，20支付中，30已支付
     */
    public static class INSP_ORDER_STATUS {

        /**
         * 未支付
         */
        public static final Integer NOT_PAY = 10;

        /**
         * 支付中
         */
        public static final Integer PAYING = 20;

        /**
         * 已支付
         */
        public static final Integer PAYED = 30;
    }
}


