package com.tydic.dyc.oc.service.domainservice.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题:UocQryShipOrderDetailsRspDetailItemBo
 * 说明:发货明细信息
 * 时间:2022/3/14 15:26
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryShipOrderDetailsRspDetailItemBo implements Serializable {
    private static final long serialVersionUID = -2548277411118302336L;

    //发货明细id")
    private Long shipOrderItemId;

    //执行明细id")
    private Long implOrderItemId;

    //销售明细id")
    private Long saleOrderItemId;

    //明细状态")
    private String shipItemState;

    //明细状态翻译")
    private String shipItemStateStr;

    //计量单位")
    private String unitName;

    //发货数量")
    private BigDecimal sendCount;

    //到货数量             供应商到货登记时预留字段")
    private BigDecimal arriveCount;

    //拒收数量")
    private BigDecimal refuseCount;

    //退货数量")
    private BigDecimal returnCount;

    //售后中数量")
    private BigDecimal afterServingCount;

    //可售后数量")
    private BigDecimal availableAfServCount;

    //验收数量")
    private BigDecimal inspCount;
    
    //验收销售金额（验收数量*销售单价）")
    private BigDecimal inspSaleFee;

    //异常变更在途数量，表示异常供应商确认之前的记录数量")
    private BigDecimal chngingCount;

    //备注")
    private String remark;

    //单品ID")
    private String skuId;

    //单品名称")
    private String skuName;

    //商品名称")
    private String commodityName;

    //商品ID")
    private String commodityId;

    //采购数量")
    private BigDecimal purchaseCount;

    //采购金额")
    private BigDecimal purchaseFee;

    //销售金额")
    private BigDecimal saleFee;

    //采购金额")
    private BigDecimal purchasePrice;

    //销售金额")
    private BigDecimal salePrice;

    //税金")
    private String taxPrice;

    //税率")
    private String tax;

    //sku物料编码")
    private String skuMaterialId;

    //sku外部单品id")
    private String skuExtSkuId;

    //sku品牌id")
    private Long skuBrandId;

    //供应商id")
    private String supplierId;

    //店铺id")
    private String supplierShopId;

    //单品品牌名称")
    private String skuBrandName;

    //sku明细id")
    private String skuItemId;

    //sku物料名称")
    private String skuMaterialName;

    //sku物料类型名称")
    private String skuMaterialTypeName;

    //sku物料类型id")
    private String skuMaterialTypeId;

    //型号")
    private String model;

    //规格")
    private String spec;

    //材质")
    private String texture;

    //图号")
    private String figure;

    //一级类目")
    private Long l1Catalog;

    //二级类目")
    private Long l2Catalog;

    //三级类目")
    private Long l3Catalog;

    //一级类目名称")
    private String l1CatalogName;

    //二级类目名称")
    private String l2CatalogName;

    //三级类目名称")
    private String l3CatalogName;

    //sku单品主图url")
    private String skuMainPicUrl;

    /**
     * 计量单位位数
     */
    private String unitDigit;

    /**
     * 退货时间，空代表不支持
     */
    private Integer rejectAllowDate;

    /**
     * 换货时间，空代表不支持
     */
    private Integer exchangeAllowDate;

    /**
     * 维修时间，空代表不支持
     */
    private Integer maintainAllowDate;

    /**
     * 商品重量
     */
    private BigDecimal goodsWeight;

    /**
     * 已退货明细销售金额
     */
    private BigDecimal retrunSendSaleFee;

    /**
     * 已退货明细采购金额
     */
    private BigDecimal retrunSendPurchaseFee;

    /**
     * 发货明细销售金额
     */
    private BigDecimal sendSaleFee;

    /**
     * 发货明细采购金额
     */
    private BigDecimal sendPurchaseFee;
}
