package com.tydic.dyc.oc.service.domainservice.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述: 〈应付单信息〉
 * @author : yuhao
 * @date : 2022/7/21 18:09
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocShouldPayOrderBo implements Serializable {
    private static final long serialVersionUID = 8686747661738904522L;
    /**
     * 应付ID
     */
    private Long shouldPayId;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 应付单类型：1：账期应付、2：预付款应付
     */
    private Integer shouldPayType;
    /**
     * 对象id
     */
    private Long objectId;
    /**
     * 对象类型
     */
    private Integer objectType;
    /**
     * 支付配置ID
     */
    private Long payConfId;
    /**
     * 结算应付ID
     */
    private Long fscShouldPayId;
    /**
     * 对象编码
     */
    private String objectNo;
    /**
     * 应付金额
     */
    private BigDecimal shouldPayFee;
    /**
     * 应付日期
     */
    private Date shouldPayDate;
    /**
     * 付款方ID
     */
    private Long payerId;
    /**
     * 付款方名称
     */
    private String payerName;
    /**
     * 收款方ID
     */
    private Long payeeId;
    /**
     * 收款方名称
     */
    private String payeeName;
    /**
     * 合同id
     */
    private String contractId;
    /**
     * 合同编号
     */
    private String contractNo;
    /**
     * 违约金比例
     */
    private BigDecimal penaltyRatio;
    /**
     * 已付金额
     */
    private BigDecimal paidFee;
    /**
     * 是否支付完成：0：未支付；1：支付完成
     */
    private Integer isPayCompleted;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 应该推送时间
     */
    private Date shouldPushTime;
    /**
     * 实际推送时间
     */
    private Date actualPushTime;
}
